/*
 * Decompiled with CFR 0.152.
 */
package com.zero.admoblibrary.excuter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.zero.admoblibrary.util.PlatformUtil;
import com.zero.common.base.BaseNative;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TAdNativeInfo;
import com.zero.common.bean.TrackInfor;
import com.zero.common.interfacz.IadNative;
import com.zero.common.utils.AdLogUtil;
import com.zero.common.utils.AutomatedLogUtil;
import com.zero.common.utils.SensitiveUtil;
import java.util.ArrayList;
import java.util.List;

public class AdmobNative
extends BaseNative {
    private AdLoader f;
    private int g = 1;
    private int h = 1;
    private List<TAdNativeInfo> i = null;
    private int j = 0;
    private int k = 2;

    public AdmobNative(Context context, String string, int n, int n2, TrackInfor trackInfor) {
        super(context, string, n2, trackInfor);
        this.g = n <= 0 ? this.h : n;
        AdLogUtil.Log().d("AdmobNative", "choicesPosition is " + this.j + ", reqType is " + this.k);
    }

    public void loadAd() {
        if (this.mContext != null && this.mContext.get() != null) {
            AutomatedLogUtil.AutomatedRecord((String)"Admob", (String)this.mPlacementId, (String)"Native", (String)"LoadAd");
            this.i = new ArrayList<TAdNativeInfo>();
            AdLoader.Builder builder = new AdLoader.Builder(((Context)this.mContext.get()).getApplicationContext(), this.mPlacementId.trim());
            builder.forUnifiedNativeAd(new UnifiedNativeAd.OnUnifiedNativeAdLoadedListener(){

                public void onUnifiedNativeAdLoaded(UnifiedNativeAd unifiedNativeAd) {
                    if (AdmobNative.this.f != null) {
                        TAdNativeInfo tAdNativeInfo = PlatformUtil.getTAdNativeInfo(unifiedNativeAd, AdmobNative.this.mAdt, AdmobNative.this.getTtl(), (IadNative)AdmobNative.this);
                        if (tAdNativeInfo != null) {
                            if (!SensitiveUtil.isSensitive((String)tAdNativeInfo.getTitle()) && !SensitiveUtil.isSensitive((String)tAdNativeInfo.getDescription())) {
                                if (!tAdNativeInfo.isMaterielValid()) {
                                    AdLogUtil.Log().e("AdmobNative", "admob has no icon&image");
                                    tAdNativeInfo.destroyAd();
                                } else {
                                    AdmobNative.this.i.add(tAdNativeInfo);
                                }
                            } else {
                                tAdNativeInfo.destroyAd();
                                AdLogUtil.Log().e("AdmobNative", "admob ad include sensitive word: " + tAdNativeInfo.getTitle() + "," + tAdNativeInfo.getDescription());
                            }
                        }
                        if (AdmobNative.this.f != null && !AdmobNative.this.f.isLoading()) {
                            AdLogUtil.Log().d("AdmobNative", "admob ad load finish");
                            AdmobNative.this.isLoaded = true;
                            if (AdmobNative.this.i.size() > 0) {
                                AdmobNative.this.allianceLoad(System.currentTimeMillis() - AdmobNative.this.startTime, AdmobNative.this.defultCode, AdmobNative.this.defultMsg);
                                if (AdmobNative.this.mAdRequestBody != null && AdmobNative.this.mAdRequestBody.getAllianceListener() != null) {
                                    AdmobNative.this.mAdRequestBody.getAllianceListener().onAllianceLoad(AdmobNative.this.i);
                                    AutomatedLogUtil.AutomatedRecord((String)"Admob", (String)AdmobNative.this.mPlacementId, (String)"Native", (String)"Loaded");
                                } else {
                                    AdmobNative.this.b();
                                }
                            } else {
                                AdmobNative.this.allianceLoad(System.currentTimeMillis() - AdmobNative.this.startTime, TAdErrorCode.SENSITIVE_ERROR.getErrorCode(), TAdErrorCode.SENSITIVE_ERROR.getErrorMessage());
                                if (AdmobNative.this.mAdRequestBody != null && AdmobNative.this.mAdRequestBody.getAllianceListener() != null) {
                                    AdmobNative.this.mAdRequestBody.getAllianceListener().onAllianceError(TAdErrorCode.SENSITIVE_ERROR);
                                }
                            }
                        }
                    } else {
                        if (unifiedNativeAd != null) {
                            unifiedNativeAd.destroy();
                        }
                        AdLogUtil.Log().e("AdmobNative", "admob adLoader is null");
                    }
                }
            });
            this.f = builder.withAdListener(new AdListener(){

                public void onAdFailedToLoad(int n) {
                    AdLogUtil.Log().d("AdmobNative", "admob ad load failed, error code is " + n);
                    if (AdmobNative.this.f != null && !AdmobNative.this.f.isLoading()) {
                        AdmobNative.this.isLoaded = true;
                        if (!AdmobNative.this.i.isEmpty()) {
                            if (AdmobNative.this.mAdRequestBody != null && AdmobNative.this.mAdRequestBody.getAllianceListener() != null) {
                                AdmobNative.this.mAdRequestBody.getAllianceListener().onAllianceLoad(AdmobNative.this.i);
                            } else {
                                AdmobNative.this.b();
                            }
                        } else if (AdmobNative.this.mAdRequestBody != null && AdmobNative.this.mAdRequestBody.getAllianceListener() != null) {
                            AdmobNative.this.allianceLoad(System.currentTimeMillis() - AdmobNative.this.startTime, n, AdmobNative.this.defultMsg);
                            AdmobNative.this.mAdRequestBody.getAllianceListener().onAllianceError(new TAdErrorCode(n, ""));
                        }
                    } else {
                        AdLogUtil.Log().d("AdmobNative", "admob adLoader isLoading");
                    }
                }

                public void onAdLeftApplication() {
                    super.onAdLeftApplication();
                }

                public void onAdClicked() {
                    super.onAdClicked();
                    AdLogUtil.Log().d("AdmobNative", "adMob ad clicked");
                    AutomatedLogUtil.AutomatedRecord((String)"Admob", (String)AdmobNative.this.mPlacementId, (String)"Native", (String)"Click");
                    AdmobNative.this.allianceOnclick();
                    if (AdmobNative.this.mAdRequestBody != null && AdmobNative.this.mAdRequestBody.getAllianceListener() != null) {
                        AdmobNative.this.mAdRequestBody.getAllianceListener().onClicked();
                    }
                }

                public void onAdClosed() {
                    super.onAdClosed();
                }

                public void onAdImpression() {
                    AdLogUtil.Log().d("AdmobNative", "admob ad impression");
                    super.onAdImpression();
                    AdmobNative.this.allianceShow();
                    AutomatedLogUtil.AutomatedRecord((String)"Admob", (String)AdmobNative.this.mPlacementId, (String)"Native", (String)"Impression");
                    if (AdmobNative.this.mAdRequestBody != null && AdmobNative.this.mAdRequestBody.getAllianceListener() != null) {
                        AdmobNative.this.mAdRequestBody.getAllianceListener().onShow();
                    }
                }
            }).withNativeAdOptions(new NativeAdOptions.Builder().setReturnUrlsForImageAssets(this.mAdRequestBody != null && this.mAdRequestBody.isUrlForImage()).setAdChoicesPlacement(this.j != 4 ? this.j : 0).build()).build();
            if (this.f != null && !this.f.isLoading()) {
                AdRequest.Builder builder2 = new AdRequest.Builder();
                if (PlatformUtil.deviceIds.size() > 0) {
                    for (String string : PlatformUtil.deviceIds) {
                        builder2.addTestDevice(string);
                    }
                }
                AdRequest adRequest = builder2.build();
                this.f.loadAds(adRequest, this.g);
                this.startTime = System.currentTimeMillis();
                this.allianceStart();
                AdLogUtil.Log().d("AdmobNative", "admob start load ad, ad count is " + this.g);
            }
        }
    }

    private void b() {
        if (this.i != null && this.i.size() > 0) {
            for (TAdNativeInfo tAdNativeInfo : this.i) {
                tAdNativeInfo.release();
            }
            this.i.clear();
        }
    }

    public void destroyAd() {
        super.destroyAd();
        this.f = null;
        this.b();
        AdLogUtil.Log().d("AdmobNative", "destroy");
    }

    public void registerViewForInteraction(ViewGroup viewGroup, List<View> list, TAdNativeInfo tAdNativeInfo) {
        AutomatedLogUtil.AutomatedRecord((String)"Admob", (String)this.mPlacementId, (String)"Native", (String)"Show");
    }

    public void unregisterView(@NonNull TAdNativeInfo tAdNativeInfo) {
    }

    public void setChoicesPosition(int n) {
        this.j = n;
    }
}

