/*
 * Decompiled with CFR 0.152.
 */
package com.zero.admoblibrary.excuter;

import android.content.Context;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.InterstitialAd;
import com.zero.common.base.BaseInterstitial;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TrackInfor;
import com.zero.common.utils.AdLogUtil;
import com.zero.common.utils.AutomatedLogUtil;

public class AdmobInterstitia
extends BaseInterstitial {
    private InterstitialAd d;

    public AdmobInterstitia(Context context, String string, String string2) {
        this(context, string, string2, null);
    }

    public AdmobInterstitia(Context context, String string, String string2, TrackInfor trackInfor) {
        super(context, string, string2, trackInfor);
        AdLogUtil.Log().d("AdmobInterstitia", "placemen id:=" + this.mPlacementId);
    }

    public void loadAd() {
        if (this.mContext != null && this.mContext.get() != null) {
            AutomatedLogUtil.AutomatedRecord((String)"Admob", (String)this.mPlacementId, (String)"Interstitia", (String)"LoadAd");
            this.d = new InterstitialAd(((Context)this.mContext.get()).getApplicationContext());
            this.d.setAdUnitId(this.mPlacementId);
            this.d.setAdListener(new AdListener(){

                public void onAdClosed() {
                    super.onAdClosed();
                    AdLogUtil.Log().d("AdmobInterstitia", "Interstitial close");
                    AutomatedLogUtil.AutomatedRecord((String)"Admob", (String)AdmobInterstitia.this.mPlacementId, (String)"Interstitia", (String)"Closed");
                    if (AdmobInterstitia.this.mAdRequestBody != null && AdmobInterstitia.this.mAdRequestBody.getAllianceListener() != null) {
                        AdmobInterstitia.this.mAdRequestBody.getAllianceListener().onClosed();
                    }
                }

                public void onAdFailedToLoad(int n) {
                    super.onAdFailedToLoad(n);
                    AdmobInterstitia.this.isLoaded = true;
                    AdLogUtil.Log().e("AdmobInterstitia", "Interstitial is error, error code is " + n);
                    AdmobInterstitia.this.allianceLoad(System.currentTimeMillis(), n + 100, AdmobInterstitia.this.defultMsg);
                    if (AdmobInterstitia.this.mAdRequestBody != null && AdmobInterstitia.this.mAdRequestBody.getAllianceListener() != null) {
                        AdmobInterstitia.this.mAdRequestBody.getAllianceListener().onAllianceError(new TAdErrorCode(n, ""));
                    }
                }

                public void onAdLeftApplication() {
                    AdLogUtil.Log().d("AdmobInterstitia", "Interstitial is click");
                    AutomatedLogUtil.AutomatedRecord((String)"Admob", (String)AdmobInterstitia.this.mPlacementId, (String)"Interstitia", (String)"Click");
                    AdmobInterstitia.this.allianceOnclick();
                    if (AdmobInterstitia.this.mAdRequestBody != null && AdmobInterstitia.this.mAdRequestBody.getAllianceListener() != null) {
                        AdmobInterstitia.this.mAdRequestBody.getAllianceListener().onClicked();
                    }
                }

                public void onAdLoaded() {
                    AdLogUtil.Log().d("AdmobInterstitia", "Interstitial is Loaded");
                    AdmobInterstitia.this.isLoaded = true;
                    AutomatedLogUtil.AutomatedRecord((String)"Admob", (String)AdmobInterstitia.this.mPlacementId, (String)"Interstitia", (String)"Loaded");
                    AdmobInterstitia.this.allianceLoad(System.currentTimeMillis(), AdmobInterstitia.this.defultCode, AdmobInterstitia.this.defultMsg);
                    if (AdmobInterstitia.this.mAdRequestBody != null && AdmobInterstitia.this.mAdRequestBody.getAllianceListener() != null) {
                        AdmobInterstitia.this.mAdRequestBody.getAllianceListener().onAllianceLoad();
                    }
                }

                public void onAdClicked() {
                    super.onAdClicked();
                }

                public void onAdImpression() {
                    super.onAdImpression();
                    AutomatedLogUtil.AutomatedRecord((String)"Admob", (String)AdmobInterstitia.this.mPlacementId, (String)"Interstitia", (String)"Impression");
                }
            });
            AdLogUtil.Log().d("AdmobInterstitia", "adMob Interstitial ad start load, placement id is:=" + this.mPlacementId);
            if (!this.d.isLoading() && !this.d.isLoaded()) {
                AdRequest adRequest = new AdRequest.Builder().build();
                this.d.loadAd(adRequest);
                this.startTime = System.currentTimeMillis();
                this.allianceStart();
            }
        }
    }

    public void show() {
        try {
            if (this.d != null && this.d.isLoaded()) {
                this.d.show();
                this.allianceShow();
                AdLogUtil.Log().d("AdmobInterstitia", "adMob Interstitial ad show");
                AutomatedLogUtil.AutomatedRecord((String)"Admob", (String)this.mPlacementId, (String)"Interstitia", (String)"Show");
                if (this.mAdRequestBody != null && this.mAdRequestBody.getAllianceListener() != null) {
                    this.mAdRequestBody.getAllianceListener().onShow();
                }
            } else {
                AdLogUtil.Log().e("AdmobInterstitia", "adMob Interstitial is not ready");
            }
        }
        catch (Exception exception) {
            AdLogUtil.Log().e("AdmobInterstitia", "adMob Interstitial show exception");
        }
    }

    public boolean isLoaded() {
        return this.d != null && this.d.isLoaded();
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.d != null) {
            this.d.setAdListener(null);
            this.d = null;
            AdLogUtil.Log().d("AdmobInterstitia", "destroy");
        }
    }
}

