/*
 * Decompiled with CFR 0.152.
 */
package com.zero.admoblibrary.excuter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.zero.admoblibrary.util.PlatformUtil;
import com.zero.common.base.BaseNative;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TAdNativeInfo;
import com.zero.common.bean.TrackInfor;
import com.zero.common.utils.AdLogUtil;
import com.zero.common.utils.AdUtil;
import java.util.List;

public class AdmobNative
extends BaseNative {
    private AdLoader g;
    private int h = 1;
    private int i = 0;
    private int j = 2;

    public AdmobNative(Context context, String string, String string2, int n, int n2, TrackInfor trackInfor) {
        super(context, string, string2, n2, trackInfor);
        this.mAdNumber = n <= 0 ? this.h : n;
        AdLogUtil.Log().d("AdmobNative", "choicesPosition is " + this.i + ", reqType is " + this.j);
    }

    protected void onNativeAdStartLoad() {
        if (this.g != null && !this.g.isLoading()) {
            this.post(PlatformUtil.handler, new Runnable(){

                @Override
                public void run() {
                    try {
                        AdmobNative.this.g.loadAds(PlatformUtil.getAdRequest(), AdmobNative.this.mAdNumber);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    AdLogUtil.Log().d("AdmobNative", "admob native load mPlacementId:" + AdmobNative.this.mPlacementId + " num:" + AdmobNative.this.mAdNumber);
                }
            });
        }
    }

    protected void initNative() {
        if (this.mContext != null && this.mContext.get() != null) {
            this.mNatives.clear();
            AdLoader.Builder builder = new AdLoader.Builder(((Context)this.mContext.get()).getApplicationContext(), this.mPlacementId.trim());
            builder.forUnifiedNativeAd(new UnifiedNativeAd.OnUnifiedNativeAdLoadedListener(){

                public void onUnifiedNativeAdLoaded(UnifiedNativeAd unifiedNativeAd) {
                    if (AdmobNative.this.g != null) {
                        TAdNativeInfo tAdNativeInfo = PlatformUtil.getTAdNativeInfo(unifiedNativeAd, AdmobNative.this.mAdt, AdmobNative.this.getTtl(), AdmobNative.this);
                        int n = AdmobNative.this.filter(tAdNativeInfo);
                        if (n == 0) {
                            AdmobNative.this.mNatives.add(tAdNativeInfo);
                        } else {
                            AdUtil.release((TAdNativeInfo)tAdNativeInfo);
                        }
                        if (AdmobNative.this.g != null && !AdmobNative.this.g.isLoading()) {
                            AdLogUtil.Log().d("AdmobNative", " ad load finish");
                            if (AdmobNative.this.mNatives.size() > 0) {
                                AdmobNative.this.adLoaded(AdmobNative.this.mNatives);
                            } else {
                                AdmobNative.this.adFailedToLoad(new TAdErrorCode(n, "adMob load failed filter"));
                                AdLogUtil.Log().e("AdmobNative", "ad not pass sensitive check or no icon or image filter:" + n);
                            }
                        }
                    } else {
                        if (unifiedNativeAd != null) {
                            unifiedNativeAd.destroy();
                        }
                        AdLogUtil.Log().e("AdmobNative", "adLoader is null");
                    }
                }
            });
            this.g = builder.withAdListener(new AdListener(){

                public void onAdFailedToLoad(int n) {
                    AdLogUtil.Log().d("AdmobNative", "ad load failed, error code is " + n);
                    if (AdmobNative.this.g != null && !AdmobNative.this.g.isLoading()) {
                        if (!AdmobNative.this.mNatives.isEmpty()) {
                            AdmobNative.this.adLoaded(AdmobNative.this.mNatives);
                        } else {
                            AdmobNative.this.adFailedToLoad(new TAdErrorCode(n, "adMob load failed"));
                        }
                    } else {
                        AdLogUtil.Log().d("AdmobNative", " adLoader isLoading");
                    }
                }

                public void onAdLeftApplication() {
                    super.onAdLeftApplication();
                }

                public void onAdClicked() {
                    super.onAdClicked();
                    AdmobNative.this.adClicked();
                }

                public void onAdClosed() {
                    super.onAdClosed();
                    AdmobNative.this.adClosed();
                }

                public void onAdImpression() {
                    AdLogUtil.Log().d("AdmobNative", "ad impression");
                    AdmobNative.this.adImpression();
                }
            }).withNativeAdOptions(new NativeAdOptions.Builder().setAdChoicesPlacement(this.i != 4 ? this.i : 0).build()).build();
        }
    }

    protected boolean isNativeBanner() {
        return false;
    }

    public void destroyAd() {
        super.destroyAd();
        this.g = null;
        AdLogUtil.Log().d("AdmobNative", "destroy");
    }

    public void registerViewForInteraction(ViewGroup viewGroup, List<View> list, TAdNativeInfo tAdNativeInfo) {
    }

    public void unregisterView(@NonNull TAdNativeInfo tAdNativeInfo) {
    }

    public void setChoicesPosition(int n) {
        this.i = n;
    }
}

