/*
 * Decompiled with CFR 0.152.
 */
package com.zero.admoblibrary.excuter;

import android.content.Context;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.reward.RewardItem;
import com.google.android.gms.ads.reward.RewardedVideoAd;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.zero.admoblibrary.util.PlatformUtil;
import com.zero.common.base.BaseRewarded;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TrackInfor;
import com.zero.common.utils.AdLogUtil;

public class AdmobRewardedVideo
extends BaseRewarded {
    private RewardedVideoAd l;

    public AdmobRewardedVideo(Context context, String string, String string2, TrackInfor trackInfor) {
        super(context, string, string2, trackInfor);
    }

    protected void initRewardedVideo() {
        if (this.mContext == null || this.mContext.get() == null) {
            return;
        }
        this.l = MobileAds.getRewardedVideoAdInstance((Context)((Context)this.mContext.get()));
        this.l.setRewardedVideoAdListener(new RewardedVideoAdListener(){

            public void onRewardedVideoAdLoaded() {
                AdLogUtil.Log().d("AdmobRewardedVideo", "Ad Loaded");
                AdmobRewardedVideo.this.adLoaded();
            }

            public void onRewardedVideoAdOpened() {
            }

            public void onRewardedVideoStarted() {
                AdLogUtil.Log().d("AdmobRewardedVideo", "Ad Impression");
                AdmobRewardedVideo.this.adImpression();
            }

            public void onRewardedVideoAdClosed() {
                AdLogUtil.Log().d("AdmobRewardedVideo", "Ad Closed");
                AdmobRewardedVideo.this.adClosed();
            }

            public void onRewarded(RewardItem rewardItem) {
                AdLogUtil.Log().d("AdmobRewardedVideo", "rewardItem = " + rewardItem.getAmount());
                AdmobRewardedVideo.this.adRewarded();
            }

            public void onRewardedVideoAdLeftApplication() {
                AdLogUtil.Log().d("AdmobRewardedVideo", "Ad Clicked");
                AdmobRewardedVideo.this.adClicked();
            }

            public void onRewardedVideoAdFailedToLoad(int n) {
                AdLogUtil.Log().d("AdmobRewardedVideo", "FailedToLoad = " + n);
                AdmobRewardedVideo.this.adFailedToLoad(new TAdErrorCode(n, ""));
            }

            public void onRewardedVideoCompleted() {
                AdLogUtil.Log().d("AdmobRewardedVideo", "Video Completed");
            }
        });
    }

    protected void onRewardedVideoStartLoad() {
        if (this.l != null && !this.l.isLoaded()) {
            try {
                this.l.loadAd(this.mPlacementId, PlatformUtil.getAdRequest());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    protected void onRewardedVideoShow() {
        if (this.l != null && this.l.isLoaded()) {
            this.l.show();
        }
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.l != null) {
            this.l.setRewardedVideoAdListener(null);
            this.l.destroy();
            this.l = null;
            AdLogUtil.Log().d("AdmobRewardedVideo", "destroy");
        }
    }
}

