/*
 * Decompiled with CFR 0.152.
 */
package com.zero.adxlibrary.excuter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.zero.adx.ad.TAdBannerView;
import com.zero.adx.ad.request.TAdRequest;
import com.zero.adx.constant.TAdErrorCode;
import com.zero.adx.impl.TAdListener;
import com.zero.common.base.BaseBanner;
import com.zero.common.bean.TrackInfor;
import com.zero.common.utils.AdLogUtil;
import com.zero.common.utils.AutomatedLogUtil;
import com.zero.common.widget.WrapTadView;

public class AdxBanner
extends BaseBanner {
    private static final String TAG = "AdxBanner";
    private static final String AD_PLATFORM = "Adx";
    private static final String AD_POSITION = "Banner";
    private TAdBannerView tAdBannerView;
    private int mBannerSize;
    private WrapTadView mParentView;

    public AdxBanner(Context context, String mPlacementId, int mBannerSize) {
        this(context, mPlacementId, mBannerSize, null);
    }

    public AdxBanner(Context context, String mPlacementId, int mBannerSize, TrackInfor track) {
        super(context, mPlacementId, track);
        this.mBannerSize = mBannerSize;
        AdLogUtil.Log().d(TAG, "placemen id:=" + mPlacementId + ",bannerSize:=" + mBannerSize);
    }

    public void loadAd() {
        this.getBannerView();
        if (this.tAdBannerView != null) {
            AdLogUtil.Log().d(TAG, "tan banner start load ad");
            AutomatedLogUtil.AutomatedRecord((String)AD_PLATFORM, (String)this.mPlacementId, (String)AD_POSITION, (String)"LoadAd");
            this.onAddView();
            this.tAdBannerView.setVisibility(8);
            this.startTime = System.currentTimeMillis();
            this.allianceStart();
            this.tAdBannerView.loadAd();
        }
    }

    private void onAddView() {
        if (this.mParentView != null) {
            this.mParentView.onAddView((View)this.tAdBannerView);
        }
    }

    private void getBannerView() {
        if (this.mContext != null && this.mContext.get() != null) {
            this.tAdBannerView = new TAdBannerView((Context)this.mContext.get(), this.mPlacementId);
            TAdRequest tAdRequest = new TAdRequest.TAdRequestBuild().setListener(new TAdListener(){

                public void onError(TAdErrorCode adError) {
                    AdxBanner.this.allianceLoad(System.currentTimeMillis() - AdxBanner.this.startTime, adError.getErrorCode(), adError.getErrorMessage());
                    AdLogUtil.Log().e(AdxBanner.TAG, "banner is error, error code is " + adError.getErrorCode() + ", error msg is " + adError.getErrorMessage());
                    AdxBanner.this.isLoaded = true;
                    if (AdxBanner.this.mAdRequestBody != null && AdxBanner.this.mAdRequestBody.getAllianceListener() != null) {
                        AdxBanner.this.mAdRequestBody.getAllianceListener().onAllianceError(new com.zero.common.bean.TAdErrorCode(adError.getErrorCode(), adError.getErrorMessage()));
                    }
                }

                public void onAdLoaded() {
                    AdLogUtil.Log().d(AdxBanner.TAG, "banner is Loaded");
                    AdxBanner.this.isLoaded = true;
                    AutomatedLogUtil.AutomatedRecord((String)AdxBanner.AD_PLATFORM, (String)AdxBanner.this.mPlacementId, (String)AdxBanner.AD_POSITION, (String)"Loaded");
                    AdxBanner.this.allianceLoad(System.currentTimeMillis() - AdxBanner.this.startTime, AdxBanner.this.defultCode, AdxBanner.this.defultMsg);
                    if (AdxBanner.this.mAdRequestBody != null && AdxBanner.this.mAdRequestBody.getAllianceListener() != null) {
                        AdLogUtil.Log().d(AdxBanner.TAG, "adView load with listener ");
                        AdxBanner.this.mAdRequestBody.getAllianceListener().onAllianceLoad();
                    } else {
                        AdLogUtil.Log().d(AdxBanner.TAG, "adView show");
                    }
                }

                public void onAdClicked() {
                    AdLogUtil.Log().d(AdxBanner.TAG, "banner is click");
                    AutomatedLogUtil.AutomatedRecord((String)AdxBanner.AD_PLATFORM, (String)AdxBanner.this.mPlacementId, (String)AdxBanner.AD_POSITION, (String)"Click");
                    AdxBanner.this.allianceOnclick();
                    if (AdxBanner.this.mAdRequestBody != null && AdxBanner.this.mAdRequestBody.getAllianceListener() != null) {
                        AdxBanner.this.mAdRequestBody.getAllianceListener().onClicked();
                    }
                }

                public void onAdClosed() {
                    super.onAdClosed();
                    AutomatedLogUtil.AutomatedRecord((String)AdxBanner.AD_PLATFORM, (String)AdxBanner.this.mPlacementId, (String)AdxBanner.AD_POSITION, (String)"Closed");
                    if (AdxBanner.this.mAdRequestBody != null && AdxBanner.this.mAdRequestBody.getAllianceListener() != null) {
                        AdxBanner.this.mAdRequestBody.getAllianceListener().onClosed();
                    }
                }

                public void onTimeOut() {
                    AdxBanner.this.isLoaded = true;
                    AdxBanner.this.allianceLoad(System.currentTimeMillis() - AdxBanner.this.startTime, com.zero.common.bean.TAdErrorCode.NETWORK_TIMEOUT_ERROR.getErrorCode(), com.zero.common.bean.TAdErrorCode.NETWORK_TIMEOUT_ERROR.getErrorMessage());
                    AdLogUtil.Log().e(AdxBanner.TAG, "banner is error, error code is " + com.zero.common.bean.TAdErrorCode.NETWORK_TIMEOUT_ERROR.getErrorCode() + ", error msg is " + com.zero.common.bean.TAdErrorCode.NETWORK_TIMEOUT_ERROR.getErrorMessage());
                    if (AdxBanner.this.mAdRequestBody != null && AdxBanner.this.mAdRequestBody.getAllianceListener() != null) {
                        AdxBanner.this.mAdRequestBody.getAllianceListener().onAllianceError(com.zero.common.bean.TAdErrorCode.NETWORK_TIMEOUT_ERROR);
                    }
                }
            }).build();
            this.tAdBannerView.setAdRequest(tAdRequest);
        }
    }

    public void show(WrapTadView rootView) {
        if (this.tAdBannerView != null) {
            rootView.onAddView((View)this.tAdBannerView);
            this.tAdBannerView.setVisibility(0);
            this.allianceShow();
            AdLogUtil.Log().d(TAG, "adx banner view is show ");
            AutomatedLogUtil.AutomatedRecord((String)AD_PLATFORM, (String)this.mPlacementId, (String)AD_POSITION, (String)"Show");
            if (this.mAdRequestBody != null && this.mAdRequestBody.getAllianceListener() != null) {
                this.mAdRequestBody.getAllianceListener().onShow();
            } else {
                AdLogUtil.Log().e(TAG, "tAdBannerView is destroy before show ");
            }
        } else {
            AdLogUtil.Log().e(TAG, "tAdBannerView is null ");
        }
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.mParentView != null) {
            this.mParentView.onRemoveAllView((View)this.tAdBannerView);
        }
        if (this.tAdBannerView != null) {
            ViewParent viewGroup = this.tAdBannerView.getParent();
            if (viewGroup != null && viewGroup instanceof ViewGroup) {
                ((ViewGroup)viewGroup).removeView((View)this.tAdBannerView);
            }
            this.tAdBannerView.destroy();
            this.tAdBannerView = null;
            AdLogUtil.Log().d(TAG, "adx banner destroy");
        }
    }
}

