/*
 * Decompiled with CFR 0.152.
 */
package com.zero.adxlibrary.excuter;

import android.content.Context;
import com.zero.adx.ad.TAdInterstitial;
import com.zero.adx.ad.request.TAdRequest;
import com.zero.adx.constant.TAdErrorCode;
import com.zero.adx.impl.TAdListener;
import com.zero.common.base.BaseInterstitial;
import com.zero.common.bean.TrackInfor;
import com.zero.common.utils.AdLogUtil;
import com.zero.common.utils.AutomatedLogUtil;

public class AdxInterstitia
extends BaseInterstitial {
    private static final String TAG = "AdxInterstitia";
    private static final String AD_PLATFORM = "Adx";
    private static final String AD_POSITION = "Interstitia";
    private TAdInterstitial mInterstitialAd;

    public AdxInterstitia(Context context, String mPlacementId) {
        this(context, mPlacementId, null);
    }

    public AdxInterstitia(Context context, String placementId, TrackInfor track) {
        super(context, placementId, track);
        AdLogUtil.Log().d(TAG, "placemen id:=" + this.mPlacementId);
    }

    public void loadAd() {
        if (this.mContext != null && this.mContext.get() != null) {
            AutomatedLogUtil.AutomatedRecord((String)AD_PLATFORM, (String)this.mPlacementId, (String)AD_POSITION, (String)"LoadAd");
            this.mInterstitialAd = new TAdInterstitial((Context)this.mContext.get(), this.mPlacementId);
            TAdRequest tAdRequest = new TAdRequest.TAdRequestBuild().setListener(new TAdListener(){

                public void onError(TAdErrorCode adError) {
                    AdxInterstitia.this.allianceLoad(System.currentTimeMillis() - AdxInterstitia.this.startTime, adError.getErrorCode(), adError.getErrorMessage());
                    AdLogUtil.Log().e(AdxInterstitia.TAG, "tan interstitia is error, error code is " + adError.getErrorCode() + ", error msg is " + adError.getErrorMessage());
                    AdxInterstitia.this.isLoaded = true;
                    if (AdxInterstitia.this.mAdRequestBody != null && AdxInterstitia.this.mAdRequestBody.getAllianceListener() != null) {
                        AdxInterstitia.this.mAdRequestBody.getAllianceListener().onAllianceError(new com.zero.common.bean.TAdErrorCode(adError.getErrorCode(), adError.getErrorMessage()));
                    }
                }

                public void onAdClosed() {
                    AdLogUtil.Log().d(AdxInterstitia.TAG, "interstitia is closed");
                    AutomatedLogUtil.AutomatedRecord((String)AdxInterstitia.AD_PLATFORM, (String)AdxInterstitia.this.mPlacementId, (String)AdxInterstitia.AD_POSITION, (String)"Closed");
                    if (AdxInterstitia.this.mAdRequestBody != null && AdxInterstitia.this.mAdRequestBody.getAllianceListener() != null) {
                        AdxInterstitia.this.mAdRequestBody.getAllianceListener().onClosed();
                    }
                }

                public void onAdLoaded() {
                    AdLogUtil.Log().d(AdxInterstitia.TAG, "interstitia is Loaded");
                    AdxInterstitia.this.isLoaded = true;
                    AutomatedLogUtil.AutomatedRecord((String)AdxInterstitia.AD_PLATFORM, (String)AdxInterstitia.this.mPlacementId, (String)AdxInterstitia.AD_POSITION, (String)"Loaded");
                    AdxInterstitia.this.allianceLoad(System.currentTimeMillis() - AdxInterstitia.this.startTime, AdxInterstitia.this.defultCode, AdxInterstitia.this.defultMsg);
                    if (AdxInterstitia.this.mAdRequestBody != null && AdxInterstitia.this.mAdRequestBody.getAllianceListener() != null) {
                        AdLogUtil.Log().d(AdxInterstitia.TAG, "adView load with listener ");
                        AdxInterstitia.this.mAdRequestBody.getAllianceListener().onAllianceLoad();
                    } else {
                        AdLogUtil.Log().d(AdxInterstitia.TAG, "adView show");
                        AdxInterstitia.this.show();
                    }
                }

                public void onAdClicked() {
                    AdLogUtil.Log().d(AdxInterstitia.TAG, "interstitia is click");
                    AutomatedLogUtil.AutomatedRecord((String)AdxInterstitia.AD_PLATFORM, (String)AdxInterstitia.this.mPlacementId, (String)AdxInterstitia.AD_POSITION, (String)"Click");
                    AdxInterstitia.this.allianceOnclick();
                    if (AdxInterstitia.this.mAdRequestBody != null && AdxInterstitia.this.mAdRequestBody.getAllianceListener() != null) {
                        AdxInterstitia.this.mAdRequestBody.getAllianceListener().onClicked();
                    }
                }

                public void onTimeOut() {
                    AdxInterstitia.this.isLoaded = true;
                    AdxInterstitia.this.allianceLoad(System.currentTimeMillis() - AdxInterstitia.this.startTime, com.zero.common.bean.TAdErrorCode.NETWORK_TIMEOUT_ERROR.getErrorCode(), com.zero.common.bean.TAdErrorCode.NETWORK_TIMEOUT_ERROR.getErrorMessage());
                    AdLogUtil.Log().e(AdxInterstitia.TAG, "interstitia is timeout, error code is " + com.zero.common.bean.TAdErrorCode.NETWORK_TIMEOUT_ERROR.getErrorCode() + ", error msg is " + com.zero.common.bean.TAdErrorCode.NETWORK_TIMEOUT_ERROR.getErrorMessage());
                    if (AdxInterstitia.this.mAdRequestBody != null && AdxInterstitia.this.mAdRequestBody.getAllianceListener() != null) {
                        AdxInterstitia.this.mAdRequestBody.getAllianceListener().onAllianceError(com.zero.common.bean.TAdErrorCode.NETWORK_TIMEOUT_ERROR);
                    }
                }
            }).showByApk(true).build();
            this.mInterstitialAd.setAdRequest(tAdRequest);
            if (this.mInterstitialAd != null && !this.mInterstitialAd.isLoaded()) {
                this.mInterstitialAd.loadAd();
                this.startTime = System.currentTimeMillis();
                this.allianceStart();
            }
        }
    }

    public void show() {
        if (this.mInterstitialAd != null && this.mInterstitialAd.isLoaded()) {
            this.mInterstitialAd.show();
            this.allianceShow();
            AdLogUtil.Log().d(TAG, "tan interstitia ad show");
            AutomatedLogUtil.AutomatedRecord((String)AD_PLATFORM, (String)this.mPlacementId, (String)AD_POSITION, (String)"Show");
            if (this.mAdRequestBody != null && this.mAdRequestBody.getAllianceListener() != null) {
                this.mAdRequestBody.getAllianceListener().onShow();
            }
        } else {
            AdLogUtil.Log().d(TAG, "tan interstitia is not ready");
        }
    }

    public boolean isLoaded() {
        return this.mInterstitialAd != null && this.mInterstitialAd.isLoaded();
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.mInterstitialAd != null) {
            this.mInterstitialAd.destroy();
            this.mInterstitialAd = null;
            AdLogUtil.Log().d(TAG, "tan interstitia destroy");
        }
    }
}

