/*
 * Decompiled with CFR 0.152.
 */
package com.zero.adxlibrary.excuter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.zero.adxlibrary.a.a;
import com.zero.common.base.BaseNative;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.bean.TAdNativeInfo;
import com.zero.common.bean.TrackInfor;
import com.zero.common.utils.AdLogUtil;
import com.zero.common.utils.AdUtil;
import com.zero.ta.api.adx.ANative;
import com.zero.ta.common.bean.TaNativeInfo;
import com.zero.ta.common.callback.TaListener;
import com.zero.ta.common.callback.TaRequest;
import com.zero.ta.common.constant.TaErrorCode;
import java.util.List;

public class AdxNative
extends BaseNative {
    private String TAG = "AdxNative";
    private int f = 1;
    private ANative g;

    public AdxNative(Context context, String string, String string2, int n, int n2, TrackInfor trackInfor) {
        super(context, string, string2, n2, trackInfor);
        this.mAdNumber = n <= 0 ? this.f : n;
    }

    protected void onNativeAdStartLoad() {
        if (this.g != null) {
            this.g.loadAd();
        }
        AdLogUtil.Log().d(this.TAG, "adx native load mPlacementId:" + this.mPlacementId + " num:" + this.mAdNumber);
    }

    protected void initNative() {
        if (this.mContext != null && this.mContext.get() != null) {
            this.mNatives.clear();
            this.g = new ANative((Context)this.mContext.get(), this.mPlacementId, this.mAdNumber);
            TaRequest taRequest = new TaRequest.TaRequestBuild().cacheBigImage(!this.isNativeBanner()).setListener(new TaListener(){

                public void onError(TaErrorCode taErrorCode) {
                    AdxNative.this.adFailedToLoad(new TAdErrorCode(taErrorCode.getErrorCode(), taErrorCode.getErrorMessage()));
                }

                public void onAdLoaded(TaNativeInfo taNativeInfo) {
                    AdLogUtil.Log().d(AdxNative.this.TAG, "onAdLoaded single ad");
                    TAdNativeInfo tAdNativeInfo = a.a(taNativeInfo, AdxNative.this.mAdt, AdxNative.this.getTtl(), AdxNative.this);
                    int n = AdxNative.this.filter(tAdNativeInfo);
                    if (n == 0) {
                        AdxNative.this.mNatives.add(tAdNativeInfo);
                    } else {
                        AdUtil.release((TAdNativeInfo)tAdNativeInfo);
                    }
                    if (AdxNative.this.mNatives.size() > 0) {
                        AdxNative.this.adLoaded(AdxNative.this.mNatives);
                    } else {
                        AdxNative.this.adFailedToLoad(new TAdErrorCode(n, "ad filter"));
                        AdLogUtil.Log().e(AdxNative.this.TAG, "ad not pass sensitive check or no icon or image filter:" + n);
                    }
                }

                public void onNativeVideoPlay(String string) {
                    AdxNative.this.nativeVideoPlay(string);
                }

                public void onAdLoaded(List<TaNativeInfo> list) {
                    AdLogUtil.Log().d(AdxNative.this.TAG, "onAdLoaded multi");
                    int n = 0;
                    for (int i = 0; i < list.size(); ++i) {
                        TAdNativeInfo tAdNativeInfo = a.a(list.get(i), AdxNative.this.mAdt, AdxNative.this.getTtl(), AdxNative.this);
                        n = AdxNative.this.filter(tAdNativeInfo);
                        if (n == 0) {
                            AdxNative.this.mNatives.add(tAdNativeInfo);
                            continue;
                        }
                        AdUtil.release((TAdNativeInfo)tAdNativeInfo);
                    }
                    if (AdxNative.this.mNatives.size() > 0) {
                        AdxNative.this.adLoaded(AdxNative.this.mNatives);
                    } else {
                        AdxNative.this.adFailedToLoad(new TAdErrorCode(n, "ad filter"));
                        AdLogUtil.Log().e(AdxNative.this.TAG, "ad not pass sensitive check or no icon or image filter:" + n);
                    }
                }

                public void onTimeOut() {
                    AdxNative.this.adFailedToLoad(TAdErrorCode.NETWORK_TIMEOUT_ERROR);
                }

                public void onAdShow() {
                    super.onAdShow();
                    AdxNative.this.adImpression();
                }

                public void onAdClosed() {
                    super.onAdClosed();
                    AdxNative.this.adClosed();
                }

                public void onAdClicked() {
                    AdxNative.this.adClicked();
                }
            }).build();
            this.g.setAdRequest(taRequest);
        }
    }

    public void destroyAd() {
        super.destroyAd();
        if (this.g != null) {
            this.g.destroy();
            this.g = null;
        }
    }

    public void registerViewForInteraction(ViewGroup viewGroup, List<View> list, TAdNativeInfo tAdNativeInfo) {
        if (viewGroup != null && this.g != null) {
            this.unregisterView(tAdNativeInfo);
            try {
                this.g.registerViews((View)viewGroup, list, (TaNativeInfo)tAdNativeInfo.getNativeAdWrapper().getNativeAd());
            }
            catch (Throwable throwable) {
                AdLogUtil.Log().e(this.TAG, "exception .... ");
            }
        }
    }

    public void unregisterView(TAdNativeInfo tAdNativeInfo) {
        if (this.g == null) {
            return;
        }
        try {
            TaNativeInfo taNativeInfo = (TaNativeInfo)tAdNativeInfo.getNativeAdWrapper().getNativeAd();
            if (this.g != null) {
                this.g.unregisterViews(taNativeInfo);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public ANative getNativeAd() {
        return this.g;
    }
}

