/*
 * Decompiled with CFR 0.152.
 */
package com.zero.common.base;

import android.content.Context;
import com.zero.common.bean.TAdRequestBody;
import com.zero.common.bean.TrackInfor;
import com.zero.common.event.EventTrack;
import com.zero.common.utils.AdLogUtil;
import com.zero.common.utils.RunTimer;
import java.lang.ref.WeakReference;

public class BaseAd {
    protected WeakReference<Context> mContext;
    protected String mPlacementId;
    private String TAG = "BaseAd";
    private TrackInfor trackInfor;
    protected int defultCode = 0;
    protected String defultMsg = "success";
    protected long startTime = 0L;
    protected int errorBase = 100000;
    private int priority = Integer.MAX_VALUE;
    private int ttl;
    private int adSource;
    private long startCacheTime;
    protected TAdRequestBody mAdRequestBody;
    private int delay;
    protected boolean isLoaded = false;
    private RunTimer runTimer;
    private RunTimer.TimeOutCallback timeOutCallback = new RunTimer.TimeOutCallback(){

        @Override
        public void isTimeOut() {
            AdLogUtil.Log().d(BaseAd.this.TAG, "Load ad is time out");
            BaseAd.this.onTimeOut();
        }
    };

    public BaseAd(Context context, String string, TrackInfor trackInfor) {
        if (trackInfor != null) {
            this.trackInfor = trackInfor;
        }
        this.mContext = new WeakReference<Context>(context);
        this.mPlacementId = string;
        this.startCacheTime = System.currentTimeMillis();
    }

    public void allianceStart() {
        if (this.trackInfor != null && this.trackInfor != null) {
            AdLogUtil.Log().d(this.TAG, "BaseAd start " + this.trackInfor.toString());
            EventTrack.getInstance().allianceStart(this.trackInfor);
        }
    }

    public void allianceLoad(Long l, int n, String string) {
        if (this.trackInfor != null && this.trackInfor != null) {
            this.trackInfor.setCost(l);
            this.trackInfor.setCode(n + this.errorBase);
            this.trackInfor.setMsg(string);
            AdLogUtil.Log().d(this.TAG, "BaseAd load " + this.trackInfor.toString());
            EventTrack.getInstance().allianceLoad(this.trackInfor);
        }
    }

    public void allianceShow() {
        if (this.trackInfor != null && this.trackInfor != null) {
            AdLogUtil.Log().d(this.TAG, "BaseAd show " + this.trackInfor.toString());
            EventTrack.getInstance().allianceShow(this.trackInfor);
        }
    }

    public void allianceOnclick() {
        if (this.trackInfor != null && this.trackInfor != null) {
            AdLogUtil.Log().d(this.TAG, "BaseAd click " + this.trackInfor.toString());
            EventTrack.getInstance().allianceOnclick(this.trackInfor);
        }
    }

    public void destroyAd() {
        this.mContext = null;
        this.trackInfor = null;
        this.mAdRequestBody = null;
        this.stopTimer();
    }

    public void setRequestBody(TAdRequestBody tAdRequestBody) {
        this.mAdRequestBody = tAdRequestBody;
    }

    public TAdRequestBody getRequestBody() {
        return this.mAdRequestBody;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int n) {
        this.ttl = n;
    }

    public boolean isExpired() {
        return this.getValidTimeLimit() <= 0L;
    }

    public long getValidTimeLimit() {
        if (this.ttl <= 0) {
            return Long.MAX_VALUE;
        }
        return (long)(this.ttl * 60 * 1000) - Math.abs(System.currentTimeMillis() - this.startCacheTime);
    }

    public int getAdSource() {
        return this.adSource;
    }

    public void setAdSource(int n) {
        this.adSource = n;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int n) {
        this.delay = n;
    }

    public String getPlacementId() {
        return this.mPlacementId;
    }

    public void stopLoader() {
        if (this.isLoaded) {
            return;
        }
        this.destroyAd();
    }

    protected void startTimer() {
        if (this.runTimer == null) {
            this.runTimer = new RunTimer();
            this.runTimer.setScheduleTime(120000);
            this.runTimer.setTimeOutCallback(this.timeOutCallback);
        }
        this.runTimer.runTimerTask();
    }

    protected void stopTimer() {
        if (this.runTimer != null) {
            this.runTimer.resetTimerTask();
            this.runTimer = null;
        }
    }

    public void onTimeOut() {
        this.isLoaded = true;
    }
}

