/*
 * Decompiled with CFR 0.152.
 */
package com.zero.common.utils;

import android.text.TextUtils;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class Preconditions {
    public static void checkArgument(boolean bl) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException();
    }

    public static void checkArgument(boolean bl, Object object) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(String.valueOf(object));
    }

    @NonNull
    public static <T extends CharSequence> T checkStringNotEmpty(T t) {
        if (!TextUtils.isEmpty(t)) {
            return t;
        }
        throw new IllegalArgumentException();
    }

    @NonNull
    public static <T extends CharSequence> T checkStringNotEmpty(T t, Object object) {
        if (!TextUtils.isEmpty(t)) {
            return t;
        }
        throw new IllegalArgumentException(String.valueOf(object));
    }

    @NonNull
    public static <T> T checkNotNull(T t) {
        if (t != null) {
            return t;
        }
        throw new NullPointerException();
    }

    @NonNull
    public static <T> T checkNotNull(T t, Object object) {
        if (t != null) {
            return t;
        }
        throw new NullPointerException(String.valueOf(object));
    }

    public static void checkState(boolean bl, String string) {
        if (bl) {
            return;
        }
        throw new IllegalStateException(string);
    }

    public static void checkState(boolean bl) {
        Preconditions.checkState(bl, null);
    }

    public static int checkFlagsArgument(int n, int n2) {
        if ((n & n2) == n) {
            return n;
        }
        throw new IllegalArgumentException("Requested flags 0x" + Integer.toHexString(n) + ", but only 0x" + Integer.toHexString(n2) + " are allowed");
    }

    @IntRange(from=0L)
    public static int checkArgumentNonnegative(int n, String string) {
        if (n >= 0) {
            return n;
        }
        throw new IllegalArgumentException(string);
    }

    @IntRange(from=0L)
    public static int checkArgumentNonnegative(int n) {
        if (n >= 0) {
            return n;
        }
        throw new IllegalArgumentException();
    }

    public static long checkArgumentNonnegative(long l) {
        if (l >= 0L) {
            return l;
        }
        throw new IllegalArgumentException();
    }

    public static long checkArgumentNonnegative(long l, String string) {
        if (l >= 0L) {
            return l;
        }
        throw new IllegalArgumentException(string);
    }

    public static int checkArgumentPositive(int n, String string) {
        if (n > 0) {
            return n;
        }
        throw new IllegalArgumentException(string);
    }

    public static float checkArgumentFinite(float f, String string) {
        if (!Float.isNaN(f)) {
            if (!Float.isInfinite(f)) {
                return f;
            }
            throw new IllegalArgumentException(string + " must not be infinite");
        }
        throw new IllegalArgumentException(string + " must not be NaN");
    }

    public static float checkArgumentInRange(float f, float f2, float f3, String string) {
        if (!Float.isNaN(f)) {
            if (!(f < f2)) {
                if (!(f > f3)) {
                    return f;
                }
                Object[] objectArray = new Object[3];
                Object[] objectArray2 = objectArray;
                objectArray2[0] = string;
                objectArray2[1] = Float.valueOf(f2);
                objectArray[2] = Float.valueOf(f3);
                throw new IllegalArgumentException(String.format(Locale.US, "%s is out of range of [%f, %f] (too high)", objectArray2));
            }
            Object[] objectArray = new Object[3];
            Object[] objectArray3 = objectArray;
            objectArray3[0] = string;
            objectArray3[1] = Float.valueOf(f2);
            objectArray[2] = Float.valueOf(f3);
            throw new IllegalArgumentException(String.format(Locale.US, "%s is out of range of [%f, %f] (too low)", objectArray3));
        }
        throw new IllegalArgumentException(string + " must not be NaN");
    }

    public static int checkArgumentInRange(int n, int n2, int n3, String string) {
        if (n >= n2) {
            if (n <= n3) {
                return n;
            }
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = string;
            objectArray2[1] = n2;
            objectArray[2] = n3;
            throw new IllegalArgumentException(String.format(Locale.US, "%s is out of range of [%d, %d] (too high)", objectArray2));
        }
        Object[] objectArray = new Object[3];
        Object[] objectArray3 = objectArray;
        objectArray3[0] = string;
        objectArray3[1] = n2;
        objectArray[2] = n3;
        throw new IllegalArgumentException(String.format(Locale.US, "%s is out of range of [%d, %d] (too low)", objectArray3));
    }

    public static long checkArgumentInRange(long l, long l2, long l3, String string) {
        if (l >= l2) {
            if (l <= l3) {
                return l;
            }
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = string;
            objectArray2[1] = l2;
            objectArray[2] = l3;
            throw new IllegalArgumentException(String.format(Locale.US, "%s is out of range of [%d, %d] (too high)", objectArray2));
        }
        Object[] objectArray = new Object[3];
        Object[] objectArray3 = objectArray;
        objectArray3[0] = string;
        objectArray3[1] = l2;
        objectArray[2] = l3;
        throw new IllegalArgumentException(String.format(Locale.US, "%s is out of range of [%d, %d] (too low)", objectArray3));
    }

    public static <T> T[] checkArrayElementsNotNull(T[] objectArray, String string) {
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != null) {
                    continue;
                }
                Object[] objectArray2 = new Object[2];
                objectArray = objectArray2;
                objectArray[0] = string;
                objectArray2[1] = i;
                throw new NullPointerException(String.format(Locale.US, "%s[%d] must not be null", objectArray));
            }
            return objectArray;
        }
        throw new NullPointerException(string + " must not be null");
    }

    @NonNull
    public static <C extends Collection<T>, T> C checkCollectionElementsNotNull(C object, String string) {
        if (object != null) {
            long l = 0L;
            Iterator<T> iterator = object.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != null) {
                    ++l;
                    continue;
                }
                Object[] objectArray = new Object[2];
                object = objectArray;
                object[0] = string;
                objectArray[1] = l;
                throw new NullPointerException(String.format(Locale.US, "%s[%d] must not be null", object));
            }
            return object;
        }
        throw new NullPointerException(string + " must not be null");
    }

    public static <T> Collection<T> checkCollectionNotEmpty(Collection<T> collection, String string) {
        if (collection != null) {
            if (!collection.isEmpty()) {
                return collection;
            }
            throw new IllegalArgumentException(string + " is empty");
        }
        throw new NullPointerException(string + " must not be null");
    }

    public static float[] checkArrayElementsInRange(float[] objectArray, float f, float f2, String string) {
        Preconditions.checkNotNull(objectArray, string + " must not be null");
        for (int i = 0; i < objectArray.length; ++i) {
            float f3 = objectArray[i];
            if (!Float.isNaN(f3)) {
                if (!(f3 < f)) {
                    if (!(f3 > f2)) {
                        continue;
                    }
                    Object[] objectArray2 = new Object[4];
                    objectArray = objectArray2;
                    objectArray[0] = (float)string;
                    objectArray[1] = i;
                    objectArray[2] = Float.valueOf(f);
                    objectArray2[3] = Float.valueOf(f2);
                    throw new IllegalArgumentException(String.format(Locale.US, "%s[%d] is out of range of [%f, %f] (too high)", objectArray));
                }
                Object[] objectArray3 = new Object[4];
                objectArray = objectArray3;
                objectArray[0] = (float)string;
                objectArray[1] = i;
                objectArray[2] = Float.valueOf(f);
                objectArray3[3] = Float.valueOf(f2);
                throw new IllegalArgumentException(String.format(Locale.US, "%s[%d] is out of range of [%f, %f] (too low)", objectArray));
            }
            throw new IllegalArgumentException(string + "[" + i + "] must not be NaN");
        }
        return objectArray;
    }
}

