/*
 * Decompiled with CFR 0.152.
 */
package com.zero.common.toolbox;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.LruCache;
import com.transsion.core.CoreUtil;
import com.transsion.http.util.MD5;
import com.zero.common.bean.TAdErrorCode;
import com.zero.common.toolbox.interfacez.ResponseListener;
import com.zero.common.utils.AdLogUtil;
import com.zero.mediation.c.a.b;
import com.zero.mediation.c.b.c;
import com.zero.mediation.util.a;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

public class AdImageLoadHelper {
    private static final String TAG = "AdImageLoadHelper";
    private static AdImageLoadHelper loader;
    private static LruCache<String, WeakReference<Bitmap>> cache;
    private ReferenceQueue<Bitmap> queue;
    private static final int MB = 0x100000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AdImageLoadHelper with() {
        if (loader != null) return loader;
        Class<AdImageLoadHelper> clazz = AdImageLoadHelper.class;
        synchronized (AdImageLoadHelper.class) {
            if (loader != null) return loader;
            loader = new AdImageLoadHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return loader;
        }
    }

    private AdImageLoadHelper() {
        long l = Runtime.getRuntime().maxMemory() / 8L;
        int n = Math.min(Math.max(0x1400000, (int)l), 0xC800000);
        cache = new LruCache<String, WeakReference<Bitmap>>(n){

            protected int sizeOf(String string, WeakReference<Bitmap> weakReference) {
                if (weakReference.get() != null) {
                    ((Bitmap)weakReference.get()).getByteCount();
                }
                return super.size();
            }
        };
        this.queue = new ReferenceQueue();
    }

    public void loadImage(@NonNull String string, ResponseListener responseListener) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.dispatchResult("", null, responseListener);
            return;
        }
        String string2 = MD5.MD5Encode((String)string);
        WeakReference weakReference = (WeakReference)cache.get((Object)string2);
        if (weakReference != null && weakReference.get() != null && !((Bitmap)weakReference.get()).isRecycled()) {
            this.dispatchResult(string2, (Bitmap)weakReference.get(), responseListener);
        } else {
            this.downloadBitmap(string2, string, responseListener);
        }
    }

    private void downloadBitmap(final String string, final String string2, final ResponseListener responseListener) {
        c c2 = ((c)new c().a(new b(){

            @Override
            protected void onRequestError(TAdErrorCode tAdErrorCode) {
                AdLogUtil.Log().e(AdImageLoadHelper.TAG, "download fail code:" + tAdErrorCode.toString());
                AdImageLoadHelper.this.dispatchResult(MD5.MD5Encode((String)string2), null, responseListener);
            }

            @Override
            public void onServerRequestSuccess(int n, byte[] byArray) {
                Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
                AdImageLoadHelper.this.dispatchResult(string, bitmap, responseListener);
            }
        })).c(string2);
        c2.netRequestPreExecute();
    }

    private void dispatchResult(final String string, final Bitmap bitmap, final ResponseListener responseListener) {
        final Drawable drawable = this.transform(bitmap);
        a.a(new Runnable(){

            @Override
            public void run() {
                if (bitmap != null) {
                    cache.put((Object)string, new WeakReference<Bitmap>(bitmap, AdImageLoadHelper.this.queue));
                }
                if (responseListener != null) {
                    if (drawable == null) {
                        responseListener.onFail();
                    } else {
                        responseListener.onSuccess(drawable);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Drawable transform(@NonNull Bitmap bitmap) {
        BitmapDrawable bitmapDrawable = null;
        if (bitmap == null) {
            return null;
        }
        try {
            bitmapDrawable = new BitmapDrawable(CoreUtil.getContext().getResources(), bitmap);
            return bitmapDrawable;
        }
        catch (Exception exception) {
            AdLogUtil.Log().e(TAG, "transform bitmap to drawable exception");
        }
        finally {
            return bitmapDrawable;
        }
    }
}

