/*
 * Decompiled with CFR 0.152.
 */
package com.zero.mediation.ad.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.zero.common.base.BaseNativeViewHolder;
import com.zero.common.bean.NativeVideoParam;
import com.zero.common.bean.TAdNativeInfo;
import com.zero.common.utils.AdLogUtil;
import com.zero.mediation.R;
import com.zero.ta.api.view.MediaView;
import com.zero.ta.common.bean.AdImage;

public class TMediaView
extends FrameLayout {
    public static final ImageView.ScaleType[] ra = new ImageView.ScaleType[]{ImageView.ScaleType.MATRIX, ImageView.ScaleType.FIT_XY, ImageView.ScaleType.FIT_START, ImageView.ScaleType.FIT_CENTER, ImageView.ScaleType.FIT_END, ImageView.ScaleType.CENTER, ImageView.ScaleType.CENTER_CROP, ImageView.ScaleType.CENTER_INSIDE};
    public ImageView.ScaleType scaleType = ImageView.ScaleType.FIT_CENTER;

    public TMediaView(@NonNull Context context) {
        this(context, null);
    }

    public TMediaView(@NonNull Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public TMediaView(@NonNull Context context, @Nullable AttributeSet scaleTypeArray, int n) {
        super(context, (AttributeSet)scaleTypeArray, n);
        int n2 = context.obtainStyledAttributes((AttributeSet)scaleTypeArray, R.styleable.TMediaView, n, 0).getInt(R.styleable.TMediaView_sspScaleType, 3);
        if (n2 >= 0) {
            scaleTypeArray = ra;
            if (n2 < ra.length) {
                this.scaleType = scaleTypeArray[n2];
            }
        }
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        this.scaleType = scaleType;
    }

    public void attachLayout(@NonNull BaseNativeViewHolder baseNativeViewHolder, TAdNativeInfo tAdNativeInfo, NativeVideoParam nativeVideoParam) {
        FrameLayout.LayoutParams layoutParams;
        BaseNativeViewHolder baseNativeViewHolder2 = baseNativeViewHolder;
        TMediaView tMediaView = this;
        tMediaView.removeAllViews();
        baseNativeViewHolder = layoutParams;
        layoutParams = new FrameLayout.LayoutParams(-1, -1);
        tAdNativeInfo = baseNativeViewHolder2.getMediaView(tMediaView.getContext(), tAdNativeInfo, nativeVideoParam);
        baseNativeViewHolder.gravity = 17;
        if (tAdNativeInfo != null) {
            this.addView((View)tAdNativeInfo, (ViewGroup.LayoutParams)baseNativeViewHolder);
        }
    }

    public void setMediaView(AdImage adImage) {
        View view = this.getMediaView();
        if (view == null) {
            AdLogUtil.Log().e("TMediaView", "childView is null");
            return;
        }
        if (view instanceof MediaView) {
            ((MediaView)view).setMediaView(adImage, this.scaleType);
        }
    }

    public void d(View view) {
        this.removeAllViews();
        if (view.getParent() != null) {
            ((ViewGroup)view.getParent()).removeView(view);
        }
        this.addView(view);
    }

    public View getMediaView() {
        return this.getChildAt(0);
    }
}

