/*
 * Decompiled with CFR 0.152.
 */
package com.zero.mediation.bean;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.zero.common.interfacz.ICacheAd;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class AdCache<T extends ICacheAd> {
    public static AdCacheComp mComparator = new AdCacheComp();
    public HashMap<String, ArrayList<T>> map = new HashMap();
    public AdCacheExpiredWatcher watcher;

    private ArrayList<T> getOrCreateList(String string) {
        ArrayList arrayList = this.map.get(string);
        if (arrayList == null) {
            ArrayList arrayList2;
            arrayList = arrayList2;
            arrayList2 = new ArrayList();
            this.map.put(string, arrayList);
        }
        return arrayList;
    }

    public void addCache(String string, @NonNull T t) {
        int n = Collections.binarySearch(this = ((AdCache)this).getOrCreateList(string), t, mComparator);
        if (n < 0) {
            n = -(n + 1);
        }
        ((ArrayList)this).add(n, t);
    }

    public void addCaches(String string, ArrayList<T> arrayList) {
        ArrayList<T> arrayList2 = this.getOrCreateList(string);
        arrayList2.addAll(arrayList);
        Collections.sort(arrayList2, mComparator);
    }

    public void removeCaches(String string, ArrayList<T> arrayList) {
        ArrayList<T> arrayList2 = ((AdCache)((Object)arrayList2)).map.get(string);
        if (arrayList2 != null) {
            arrayList2.removeAll(arrayList);
        }
    }

    public void removeCache(String string, T t) {
        ArrayList<T> arrayList = ((AdCache)((Object)arrayList)).map.get(string);
        if (arrayList != null) {
            arrayList.remove(t);
        }
    }

    public ArrayList<T> getCaches(@NonNull String iterator, int n) {
        ArrayList<ICacheAd> arrayList = null;
        if ((iterator = this.map.get(iterator)) != null) {
            iterator = ((ArrayList)((Object)iterator)).iterator();
            while (iterator.hasNext()) {
                Iterator iterator2 = iterator;
                ICacheAd iCacheAd = (ICacheAd)iterator2.next();
                iterator2.remove();
                if (iCacheAd.isExpired()) {
                    AdCacheExpiredWatcher adCacheExpiredWatcher = this.watcher;
                    if (adCacheExpiredWatcher != null) {
                        adCacheExpiredWatcher.onExpired(iCacheAd);
                    }
                    iCacheAd.destroyAd();
                    continue;
                }
                if (arrayList == null) {
                    ArrayList<ICacheAd> arrayList2;
                    arrayList = arrayList2;
                    arrayList2 = new ArrayList<ICacheAd>();
                }
                ArrayList<ICacheAd> arrayList3 = arrayList;
                arrayList3.add(iCacheAd);
                if (arrayList3.size() < n) continue;
            }
        }
        return arrayList;
    }

    public T getCache(String object) {
        AdCache adCache = adCache2;
        AdCache adCache2 = null;
        if ((object = adCache.getCaches((String)object, 1)) != null && !((ArrayList)object).isEmpty()) {
            adCache2 = (ICacheAd)((ArrayList)object).get(0);
        }
        return (T)adCache2;
    }

    public boolean hasAds(String iterator) {
        if ((iterator = this.map.get(iterator)) == null) {
            return false;
        }
        iterator = ((ArrayList)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            ICacheAd iCacheAd = (ICacheAd)iterator.next();
            if (iCacheAd.isExpired()) {
                AdCacheExpiredWatcher adCacheExpiredWatcher = this.watcher;
                if (adCacheExpiredWatcher != null) {
                    adCacheExpiredWatcher.onExpired(iCacheAd);
                }
                iCacheAd.destroyAd();
                iterator.remove();
                continue;
            }
            return true;
        }
        return false;
    }

    public int getAdNum(String iterator, int n, String string) {
        int n2 = 0;
        if ((iterator = this.map.get(iterator)) == null) {
            return n2;
        }
        iterator = ((ArrayList)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            ICacheAd iCacheAd = (ICacheAd)iterator.next();
            if (iCacheAd.isExpired()) {
                AdCacheExpiredWatcher adCacheExpiredWatcher = this.watcher;
                if (adCacheExpiredWatcher != null) {
                    adCacheExpiredWatcher.onExpired(iCacheAd);
                }
                iCacheAd.destroyAd();
                iterator.remove();
                continue;
            }
            if (iCacheAd.getAdSource() != n || !TextUtils.equals((CharSequence)iCacheAd.getPlacementId(), (CharSequence)string)) continue;
            ++n2;
        }
        return n2;
    }

    public void registerWatcher(AdCacheExpiredWatcher adCacheExpiredWatcher) {
        this.watcher = adCacheExpiredWatcher;
    }

    public void unRegisterWatcher() {
        this.watcher = null;
    }

    public static interface AdCacheExpiredWatcher {
        public void onExpired(ICacheAd var1);
    }

    public static class AdCacheComp
    implements Comparator<ICacheAd> {
        @Override
        public int compare(ICacheAd iCacheAd, ICacheAd iCacheAd2) {
            if (iCacheAd.isExpired() && !iCacheAd2.isExpired()) {
                return 1;
            }
            if (!iCacheAd.isExpired() && iCacheAd2.isExpired()) {
                return -1;
            }
            if (iCacheAd.getPriority() == iCacheAd2.getPriority()) {
                if (iCacheAd.getValidTimeLimit() - iCacheAd2.getValidTimeLimit() < 0L) {
                    return -1;
                }
                if (iCacheAd.getValidTimeLimit() - iCacheAd2.getValidTimeLimit() > 0L) {
                    return 1;
                }
                return 0;
            }
            return iCacheAd.getPriority() - iCacheAd2.getPriority();
        }
    }
}

