/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.tracker;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import com.transsion.core.deviceinfo.DeviceInfo;
import com.transsion.core.utils.AppUtil;
import com.transsion.crypto.crypter.AesCbcPKCS5RandomCrypter;
import com.transsion.crypto.crypter.RsaEcsPKCS1Encrypter;
import com.transsion.json.Tson;
import com.transsion.push.PushManager;
import com.transsion.push.bean.PushPointInfo;
import com.transsion.push.bean.PushRequest;
import com.transsion.push.bean.TrackerResponse;
import com.transsion.push.config.PushRepository;
import com.transsion.push.db.PushDbManager;
import com.transsion.push.tracker.Tracker;
import com.transsion.push.utils.DeviceUtils;
import com.transsion.push.utils.HttpUtils;
import com.transsion.push.utils.NetUtils;
import com.transsion.push.utils.PushConfigUtils;
import com.transsion.push.utils.PushLogUtils;
import com.transsion.push.utils.PushUtils;
import com.transsion.push.utils.ThreadManager;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class PushTracker {
    private static PushTracker instance = null;
    private Context mContext;

    private PushTracker() {
    }

    public static PushTracker getInstance() {
        if (instance == null) {
            instance = new PushTracker();
        }
        return instance;
    }

    void init(Context context) {
        this.mContext = context.getApplicationContext();
        PushDbManager.getInstance().init(context);
    }

    void track(final Tracker.KEY key, final Bundle bundle) {
        boolean isStartPointReport = PushRepository.getInstance().getSpValue("push_start_point_report", false);
        PushLogUtils.LOG.d((Object)("push tracker isStartPointReport:" + isStartPointReport + ", key:" + key.event));
        if (!isStartPointReport) {
            return;
        }
        ThreadManager.executeInBackground(new Runnable(){

            @Override
            public void run() {
                JSONObject jsonEvt = PushTracker.this.buildEvt(key, bundle);
                if (!PushConfigUtils.isImmediatelyTracker()) {
                    PushDbManager.getInstance().insertMsg(jsonEvt.toString());
                    return;
                }
                JSONObject jsonCommon = PushTracker.this.buildCommon();
                PushTracker.this.postTracker(jsonCommon, jsonEvt);
            }
        });
    }

    public void tracks() {
        boolean isStartPointReport = PushRepository.getInstance().getSpValue("push_start_point_report", false);
        PushLogUtils.LOG.d((Object)("push trackers isStartPointReport:" + isStartPointReport));
        if (!isStartPointReport) {
            PushLogUtils.LOG.d((Object)"check tracker report");
            return;
        }
        if (!PushUtils.isTrackerReport()) {
            return;
        }
        PushLogUtils.LOG.d((Object)"check tracker report");
        ThreadManager.executeInBackground(new Runnable(){

            @Override
            public void run() {
                List<PushPointInfo> points = PushDbManager.getInstance().queryPoints();
                if (points == null || points.size() <= 0) {
                    PushLogUtils.LOG.d((Object)"No tracker content reporting");
                    return;
                }
                JSONObject jsonCommon = PushTracker.this.buildCommon();
                PushTracker.this.postTracker(jsonCommon, points);
            }
        });
    }

    private void postTracker(JSONObject jsonCommon, List<PushPointInfo> points) {
        if (jsonCommon == null || points == null || points.size() <= 0) {
            return;
        }
        try {
            JSONArray jsonArray = new JSONArray();
            for (PushPointInfo point : points) {
                jsonArray.put((Object)new JSONObject(point.evt));
            }
            jsonCommon.put("evt", (Object)jsonArray);
            String body = jsonCommon.toString();
            PushLogUtils.LOG.d((Object)("request body:" + body));
            String url = PushManager.getInstance().getTestEnv() ? "https://test-tracking.twibida.com/v1/sdk/point/report" : (PushManager.getInstance().getDebug() ? "https://mi-pre.shalltry.com/tcm/v1/sdk/point/report" : "https://tracking.twibida.com/v1/sdk/point/report");
            PushLogUtils.LOG.d((Object)("request url:" + url));
            AesCbcPKCS5RandomCrypter crypter = new AesCbcPKCS5RandomCrypter();
            RsaEcsPKCS1Encrypter rsaEcsPKCS1Encrypter = new RsaEcsPKCS1Encrypter("MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBAKEaYIhDF/GSQZagVqAOo7UU/GqDjQBU5muTCS6qPMfAdtKOzbhRpNCJA/ZmgBxPhc8RVLPO9yiJn5g+hy+tz3cCAwEAAQ==");
            PushRequest pushRequest = new PushRequest();
            String data64 = crypter.base64Encode(crypter.encrypt(body));
            String key64 = crypter.base64Encode(rsaEcsPKCS1Encrypter.encrypt(crypter.getPass()));
            pushRequest.data = data64;
            pushRequest.key = key64;
            byte[] uploadData = Tson.toJson((Object)pushRequest).getBytes();
            byte[] response = HttpUtils.makePostRequest(url, uploadData);
            if (response == null) {
                PushLogUtils.LOG.e((Object)"the response data is empty");
                return;
            }
            TrackerResponse trackerResponse = (TrackerResponse)Tson.fromJson((String)new String(response), TrackerResponse.class);
            if (trackerResponse == null || trackerResponse.config == null) {
                PushLogUtils.LOG.e((Object)"parse post points BaseResponse failed");
                return;
            }
            PushLogUtils.LOG.d((Object)("post points response:" + trackerResponse));
            if (trackerResponse.status != 200) {
                PushLogUtils.LOG.e((Object)("post points response status error, status:" + trackerResponse.status + ", " + trackerResponse.message));
                return;
            }
            PushRepository.getInstance().putSpValue("is_immediately_tracker", trackerResponse.config.reportType == 0);
            PushRepository.getInstance().putSpValue("tracker_report_interval", trackerResponse.config.reportTime);
            PushRepository.getInstance().putSpValue("tracker_report_time", System.currentTimeMillis() + PushConfigUtils.getTrackerReportInterval());
            PushDbManager.getInstance().deletePoints(points);
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("post points Exception: " + e.getMessage()));
        }
    }

    private void postTracker(JSONObject jsonCommon, JSONObject jsonEvt) {
        if (jsonCommon == null || jsonEvt == null) {
            return;
        }
        try {
            JSONArray jsonArray = new JSONArray();
            jsonArray.put((Object)jsonEvt);
            jsonCommon.put("evt", (Object)jsonArray);
            String body = jsonCommon.toString();
            PushLogUtils.LOG.d((Object)("request body:" + body));
            String url = PushManager.getInstance().getTestEnv() ? "https://test-tracking.twibida.com/v1/sdk/point/report" : (PushManager.getInstance().getDebug() ? "https://mi-pre.shalltry.com/tcm/v1/sdk/point/report" : "https://tracking.twibida.com/v1/sdk/point/report");
            PushLogUtils.LOG.d((Object)("request url:" + url));
            AesCbcPKCS5RandomCrypter crypter = new AesCbcPKCS5RandomCrypter();
            RsaEcsPKCS1Encrypter rsaEcsPKCS1Encrypter = new RsaEcsPKCS1Encrypter("MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBAKEaYIhDF/GSQZagVqAOo7UU/GqDjQBU5muTCS6qPMfAdtKOzbhRpNCJA/ZmgBxPhc8RVLPO9yiJn5g+hy+tz3cCAwEAAQ==");
            PushRequest pushRequest = new PushRequest();
            String data64 = crypter.base64Encode(crypter.encrypt(body));
            String key64 = crypter.base64Encode(rsaEcsPKCS1Encrypter.encrypt(crypter.getPass()));
            pushRequest.data = data64;
            pushRequest.key = key64;
            byte[] uploadData = Tson.toJson((Object)pushRequest).getBytes();
            byte[] response = HttpUtils.makePostRequest(url, uploadData);
            if (response == null) {
                PushLogUtils.LOG.e((Object)"the response data is empty");
                PushDbManager.getInstance().insertMsg(jsonEvt.toString());
                return;
            }
            TrackerResponse trackerResponse = (TrackerResponse)Tson.fromJson((String)new String(response), TrackerResponse.class);
            if (trackerResponse == null) {
                PushLogUtils.LOG.e((Object)"parse post point BaseResponse failed");
                PushDbManager.getInstance().insertMsg(jsonEvt.toString());
                return;
            }
            PushLogUtils.LOG.d((Object)("post point response:" + trackerResponse));
            if (trackerResponse.status != 200) {
                PushLogUtils.LOG.e((Object)("post point response status error, status:" + trackerResponse.status + ", " + trackerResponse.message));
                PushDbManager.getInstance().insertMsg(jsonEvt.toString());
                return;
            }
            PushRepository.getInstance().putSpValue("is_immediately_tracker", trackerResponse.config.reportType == 0);
            PushRepository.getInstance().putSpValue("tracker_report_interval", trackerResponse.config.reportTime);
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("post point Exception: " + e.getMessage()));
            PushDbManager.getInstance().insertMsg(jsonEvt.toString());
        }
    }

    private JSONObject buildCommon() {
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject();
            jsonObject.put("app_id", (Object)PushUtils.getAppId());
            jsonObject.put("app_ver", (Object)AppUtil.getVersionName());
            jsonObject.put("app_ver_code", AppUtil.getVersionCode());
            jsonObject.put("gaid", (Object)DeviceInfo.getGAIdInThread());
            jsonObject.put("pkg_name", (Object)AppUtil.getPkgName());
            jsonObject.put("sdk_ver", (Object)"1.8.7.01");
            jsonObject.put("sdk_ver_code", 17004);
            jsonObject.put("tz", (Object)DeviceUtils.getCurrentTimeZone());
            jsonObject.put("country", (Object)Locale.getDefault().getCountry());
            jsonObject.put("brand", (Object)(TextUtils.isEmpty((CharSequence)Build.BRAND) ? Build.BRAND : Build.BRAND.toUpperCase().replace(" ", "")));
            jsonObject.put("mcc", DeviceUtils.getMCC());
            jsonObject.put("mnc", DeviceUtils.getMCC());
            jsonObject.put("device_type", (Object)(DeviceUtils.isPad(this.mContext) ? "pad" : "phone"));
            jsonObject.put("android_ver", (Object)Build.VERSION.RELEASE);
            jsonObject.put("os_ver", Build.VERSION.SDK_INT);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    private JSONObject buildEvt(Tracker.KEY key, Bundle bundle) {
        JSONObject jsonEvt = null;
        try {
            jsonEvt = new JSONObject();
            jsonEvt.put("name", (Object)key.event);
            jsonEvt.put("ts", System.currentTimeMillis());
            jsonEvt.put("network_type", (Object)NetUtils.getTrackerNetType());
            if (bundle == null || bundle.isEmpty()) {
                return jsonEvt;
            }
            JSONObject jsonExtra = new JSONObject();
            Set keySet = bundle.keySet();
            for (String k : keySet) {
                jsonExtra.put(k, bundle.get(k));
            }
            jsonEvt.put("extra", (Object)jsonExtra);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonEvt;
    }
}

