/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.RequiresApi;
import com.transsion.core.CoreUtil;
import com.transsion.core.utils.SharedPreferencesUtil;
import com.transsion.json.Tson;
import com.transsion.push.PushManager;
import com.transsion.push.bean.PushConfig;
import com.transsion.push.bean.PushMessage;
import com.transsion.push.config.PushRepository;
import com.transsion.push.tracker.Tracker;
import com.transsion.push.utils.NotificationAssistUtils;
import com.transsion.push.utils.NotificationHelper;
import com.transsion.push.utils.PushConfigUtils;
import com.transsion.push.utils.PushLogUtils;
import com.transsion.push.utils.ServiceUtils;
import com.transsion.push.utils.WhiteListUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public final class PushUtils {
    private static final List<ResolveInfo> mResolveInfos = new ArrayList<ResolveInfo>();
    private static AtomicBoolean isInitSuccess = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void updatePackageInfos() {
        PackageManager packageManager;
        try {
            packageManager = CoreUtil.getContext().getPackageManager();
        }
        catch (Exception e) {
            return;
        }
        if (packageManager == null) {
            return;
        }
        Intent intent = new Intent("android.intent.action.TPUSH");
        List resolveInfos = packageManager.queryIntentActivities(intent, 0);
        Intent intentOld = new Intent("android.intent.action.PUSH");
        List resolveInfosOld = packageManager.queryIntentActivities(intentOld, 0);
        Intent tpushIntent = new Intent("tpush.intent.action.TPUSH");
        List tpushResolveInfos = packageManager.queryIntentActivities(tpushIntent, 0);
        List<ResolveInfo> list = mResolveInfos;
        synchronized (list) {
            if (resolveInfos != null) {
                mResolveInfos.clear();
                mResolveInfos.addAll(resolveInfos);
                mResolveInfos.addAll(resolveInfosOld);
                mResolveInfos.addAll(tpushResolveInfos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized List<String> getSdkPkgs() {
        List<ResolveInfo> list = mResolveInfos;
        synchronized (list) {
            PushUtils.updatePackageInfos();
            ArrayList<String> pkgList = new ArrayList<String>();
            for (ResolveInfo resolveInfo : mResolveInfos) {
                if (resolveInfo == null || resolveInfo.activityInfo == null || TextUtils.isEmpty((CharSequence)resolveInfo.activityInfo.packageName)) continue;
                pkgList.add(resolveInfo.activityInfo.packageName);
            }
            return pkgList;
        }
    }

    public static boolean isAppForeground() {
        ActivityManager.RunningAppProcessInfo appProcessInfo = new ActivityManager.RunningAppProcessInfo();
        ActivityManager.getMyMemoryState((ActivityManager.RunningAppProcessInfo)appProcessInfo);
        return appProcessInfo.importance == 100 || appProcessInfo.importance == 200;
    }

    public static boolean checkUninstall(String pkg) {
        try {
            CoreUtil.getContext().getPackageManager().getApplicationInfo(pkg, 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            return true;
        }
        return false;
    }

    public static boolean isAppDisable(String packageName) {
        try {
            PackageManager pm = CoreUtil.getContext().getPackageManager();
            int enableStatus = pm.getApplicationEnabledSetting(packageName);
            if (enableStatus != 0 && enableStatus != 1) {
                PushLogUtils.LOG.w((Object)("channel message, " + packageName + " is disabled"));
                return true;
            }
        }
        catch (Exception e) {
            PushLogUtils.LOG.w((Object)("check enable setting fail, e:" + e.getMessage()));
        }
        return false;
    }

    public static boolean checkMessage(PushMessage message, int type) {
        if (message == null) {
            PushLogUtils.LOG.w((Object)"Transparent page, empty message");
            return false;
        }
        if (message.type != 1 && message.type != 5 && message.type != 2 && message.type != 6 && message.type != 7) {
            PushLogUtils.LOG.e((Object)"Message type is not supported");
            if (type == 0) {
                Tracker.getInstance().trackMessage(message.messageId, message.type, message.timeStamp, "fail", 4);
            } else {
                Tracker.getInstance().trackTarget(message.messageId, message.type, message.timeStamp, message.rpkg, "fail");
            }
            return false;
        }
        if (PushUtils.getIsMessageHandled(message.messageId)) {
            if (type == 1 && !TextUtils.isEmpty((CharSequence)message.packageName) && !message.packageName.equals(message.rpkg)) {
                Tracker.getInstance().trackTarget(message.messageId, message.type, message.timeStamp, message.rpkg, "handled");
            }
            PushLogUtils.LOG.d((Object)("The message has been handled, msgId:" + message.messageId + ", rpkg:" + message.rpkg));
            return false;
        }
        if (type == 1) {
            return true;
        }
        if (!WhiteListUtils.checkPkgInWhiteList(message.packageName)) {
            PushLogUtils.LOG.w((Object)"Package Name No longer appMap");
            Tracker.getInstance().trackMessage(message.messageId, message.type, message.timeStamp, "fail", 1);
            return false;
        }
        return true;
    }

    public static boolean retraceMessage(PushMessage message) {
        if (message.type == 7) {
            boolean isHandled = PushUtils.getIsMessageHandled(message.retraceMsgId);
            boolean isClick = PushUtils.getIsClickMessage(message.retraceMsgId);
            if (isHandled && !isClick) {
                NotificationHelper.cancelNotification(message.retraceMsgId);
                try {
                    Tracker.getInstance().trackShow(message.retraceMsgId, 7, String.valueOf(System.currentTimeMillis()), NotificationAssistUtils.isOpenNotification(CoreUtil.getContext()), 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            PushUtils.setRetraceMessage(message.retraceMsgId);
            return isHandled && !isClick;
        }
        if (message.type == 1) {
            boolean isRetrace = PushUtils.getIsRetraceMessage(message.messageId);
            if (isRetrace) {
                Tracker.getInstance().trackShow(message.messageId, 7, String.valueOf(System.currentTimeMillis()), NotificationAssistUtils.isOpenNotification(CoreUtil.getContext()), 0);
            }
            return isRetrace;
        }
        return false;
    }

    public static boolean getIsMessageHandled(long msgId) {
        String messageIds = "";
        try {
            messageIds = SharedPreferencesUtil.getInstance((String)"sp_push").getString("pushui_message_ids");
            if (TextUtils.isEmpty((CharSequence)messageIds)) {
                return false;
            }
            return messageIds.contains(String.valueOf(msgId));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void setMessageHandled(long msgId) {
        String messageIds = SharedPreferencesUtil.getInstance((String)"sp_push").getString("pushui_message_ids");
        if (messageIds.contains(String.valueOf(msgId))) {
            return;
        }
        if ((messageIds = messageIds + " " + msgId).length() > 1024) {
            messageIds = messageIds.substring(256);
        }
        try {
            SharedPreferencesUtil.getInstance((String)"sp_push").putString("pushui_message_ids", messageIds);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean getIsRetraceMessage(long msgId) {
        try {
            String messageIds = SharedPreferencesUtil.getInstance((String)"sp_push").getString("pushui_retrace_message_ids");
            if (TextUtils.isEmpty((CharSequence)messageIds)) {
                return false;
            }
            return messageIds.contains(String.valueOf(msgId));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void setRetraceMessage(long msgId) {
        String messageIds = SharedPreferencesUtil.getInstance((String)"sp_push").getString("pushui_retrace_message_ids");
        if (messageIds.contains(String.valueOf(msgId))) {
            return;
        }
        if ((messageIds = messageIds + " " + msgId).length() > 1024) {
            messageIds = messageIds.substring(256);
        }
        try {
            SharedPreferencesUtil.getInstance((String)"sp_push").putString("pushui_retrace_message_ids", messageIds);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean getIsClickMessage(long msgId) {
        try {
            String messageIds = SharedPreferencesUtil.getInstance((String)"sp_push").getString("pushui_click_message_ids");
            if (TextUtils.isEmpty((CharSequence)messageIds)) {
                return false;
            }
            return messageIds.contains(String.valueOf(msgId));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void setClickMessage(long msgId) {
        try {
            String messageIds = SharedPreferencesUtil.getInstance((String)"sp_push").getString("pushui_click_message_ids");
            if (messageIds.contains(String.valueOf(msgId))) {
                return;
            }
            if ((messageIds = messageIds + " " + msgId).length() > 1024) {
                messageIds = messageIds.substring(256);
            }
            SharedPreferencesUtil.getInstance((String)"sp_push").putString("pushui_click_message_ids", messageIds);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static PushMessage getIntentMessage(Intent intent) {
        if (intent == null) {
            return null;
        }
        String messageStr = intent.getStringExtra("message");
        PushMessage message = null;
        try {
            message = (PushMessage)Tson.fromJson((String)messageStr, PushMessage.class);
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)"Notification service message is empty");
        }
        return message;
    }

    public static Bitmap getApplicationIcon(Context context, String pkgName) {
        try {
            PackageManager manager = context.getPackageManager();
            if (manager != null) {
                return PushUtils.getAppIcon(manager, pkgName);
            }
        }
        catch (Exception e) {
            PushLogUtils.LOG.d((Object)("getApplicationIcon e" + e));
        }
        PushLogUtils.LOG.d((Object)"getApplicationIcon id error");
        return null;
    }

    public static Bitmap getAppIcon(PackageManager mPackageManager, String packageName) {
        if (Build.VERSION.SDK_INT >= 26) {
            return PushUtils.getAppIconV26(mPackageManager, packageName);
        }
        try {
            Drawable drawable2 = mPackageManager.getApplicationIcon(packageName);
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @RequiresApi(api=26)
    public static Bitmap getAppIconV26(PackageManager mPackageManager, String packageName) {
        try {
            Drawable drawable2 = mPackageManager.getApplicationIcon(packageName);
            if (drawable2 instanceof BitmapDrawable) {
                return ((BitmapDrawable)drawable2).getBitmap();
            }
            if (drawable2 instanceof AdaptiveIconDrawable) {
                Drawable backgroundDr = ((AdaptiveIconDrawable)drawable2).getBackground();
                Drawable foregroundDr = ((AdaptiveIconDrawable)drawable2).getForeground();
                Drawable[] drr = new Drawable[]{backgroundDr, foregroundDr};
                LayerDrawable layerDrawable = new LayerDrawable(drr);
                int width = layerDrawable.getIntrinsicWidth();
                int height = layerDrawable.getIntrinsicHeight();
                Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                layerDrawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                layerDrawable.draw(canvas);
                return bitmap;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void initMetaData() {
        String appId = "";
        String appKey = "";
        boolean isDebug = false;
        boolean isTestEnv = false;
        try {
            ApplicationInfo info = CoreUtil.getContext().getPackageManager().getApplicationInfo(CoreUtil.getContext().getPackageName(), 128);
            isDebug = info.metaData.getBoolean("tpush_open_debug");
            appId = info.metaData.getString("tpush_app_id");
            appKey = info.metaData.getString("tpush_app_key");
            isTestEnv = info.metaData.getBoolean("tpush_test_env");
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        PushRepository.getInstance().putSpValue("push_app_id", appId);
        PushRepository.getInstance().putSpValue("push_app_key", appKey);
        PushRepository.getInstance().putSpValue("push_is_debug", isDebug);
        PushRepository.getInstance().putSpValue("push_is_test_env", isTestEnv);
    }

    public static String getAppId() {
        String appId = PushRepository.getInstance().getSpValue("push_app_id", "");
        if (!TextUtils.isEmpty((CharSequence)appId)) {
            return appId;
        }
        try {
            ApplicationInfo info = CoreUtil.getContext().getPackageManager().getApplicationInfo(CoreUtil.getContext().getPackageName(), 128);
            appId = info.metaData.getString("tpush_app_id");
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        if (!TextUtils.isEmpty((CharSequence)appId)) {
            PushRepository.getInstance().putSpValue("push_app_id", appId);
        }
        return TextUtils.isEmpty((CharSequence)appId) ? "" : appId;
    }

    public static String getAppKey() {
        String appKey = PushRepository.getInstance().getSpValue("push_app_key", "");
        if (!TextUtils.isEmpty((CharSequence)appKey)) {
            return appKey;
        }
        try {
            ApplicationInfo info = CoreUtil.getContext().getPackageManager().getApplicationInfo(CoreUtil.getContext().getPackageName(), 128);
            appKey = info.metaData.getString("tpush_app_key");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!TextUtils.isEmpty((CharSequence)appKey)) {
            PushRepository.getInstance().putSpValue("push_app_key", appKey);
        }
        return TextUtils.isEmpty((CharSequence)appKey) ? "" : appKey;
    }

    public static boolean isDebug() {
        return PushRepository.getInstance().getSpValue("push_is_debug", false);
    }

    public static boolean isTestEnv() {
        return PushRepository.getInstance().getSpValue("push_is_test_env", false);
    }

    public static boolean isMainProcess(Context context) {
        try {
            int pid = Process.myPid();
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            List processes = null;
            if (activityManager != null) {
                processes = activityManager.getRunningAppProcesses();
            }
            if (processes == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo appProcess : processes) {
                if (pid != appProcess.pid) continue;
                return true;
            }
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("Judge process exception, e:" + e.getMessage()));
        }
        return false;
    }

    public static boolean isForceUpdate() {
        String clientId = PushRepository.getInstance().getSpValue("push_client_id", "");
        boolean isReported = PushRepository.getInstance().isReported();
        return TextUtils.isEmpty((CharSequence)clientId) || !isReported;
    }

    public static boolean isSyncActive() {
        long reportTime = PushRepository.getInstance().getReportTime();
        long diff = System.currentTimeMillis() - reportTime;
        long modifyTimeDiff = System.currentTimeMillis() - (reportTime - PushConfigUtils.getReportActiveInterval());
        return diff > 0L || modifyTimeDiff < 0L;
    }

    public static boolean isSyncTpmsActive() {
        long reportTime = PushRepository.getInstance().getLastTpmsReportTime();
        long diff = System.currentTimeMillis() - reportTime;
        return diff > 0L;
    }

    public static long syncTpmsDiff() {
        long reportTime = PushRepository.getInstance().getLastTpmsReportTime();
        long diff = reportTime - System.currentTimeMillis();
        return diff / 1000L;
    }

    public static long syncDiff() {
        long reportTime = PushRepository.getInstance().getReportTime();
        long diff = reportTime - System.currentTimeMillis();
        return diff / 1000L;
    }

    public static boolean isTrackerReport() {
        long trackerReportTime = PushRepository.getInstance().getSpValue("tracker_report_time", -1L);
        long diff = System.currentTimeMillis() - trackerReportTime;
        long modifyTimeDiff = System.currentTimeMillis() - (trackerReportTime - PushConfigUtils.getTrackerReportInterval());
        return diff > 0L || modifyTimeDiff < 0L;
    }

    public static void savePushConfig(PushConfig config) {
        PushRepository.getInstance().putSpValue("app_close_job_service", config.isCloseJobService());
        PushRepository.getInstance().putSpValue("app_check_interval", Math.min(Math.max(config.getCheckInterval(), 900), 43200));
        PushRepository.getInstance().putSpValue("app_m_upload_interval", Math.min(Math.max(config.getMobileUploadInterval(), 7200), 43200));
        PushRepository.getInstance().putSpValue("app_upload_interval", Math.min(Math.max(config.getUploadInterval(), 7200), 43200));
        PushRepository.getInstance().putSpValue("push_group_id", config.getGroupId());
        PushRepository.getInstance().putSpValue("push_max_notification_count", Math.min(config.getMaxNotificationCount(), 60));
    }

    public static String getDisplayAppName(Context context, PushMessage message) {
        if (!TextUtils.isEmpty((CharSequence)message.appName)) {
            return message.appName;
        }
        String appName = "";
        try {
            PackageManager manager = context.getPackageManager();
            if (manager != null) {
                PackageInfo packageInfo = manager.getPackageInfo(message.packageName, 0);
                appName = packageInfo.applicationInfo.loadLabel(manager).toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return appName;
    }

    public static void updateToken(String token) {
        try {
            Bundle bundle = new Bundle();
            bundle.putString("service_type", "token");
            bundle.putString("TOKEN", token);
            Tracker.getInstance().trackTokenUpdateInit();
            ServiceUtils.startJobThread(CoreUtil.getContext(), bundle);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isUIProcess() {
        ActivityManager am = (ActivityManager)CoreUtil.getContext().getSystemService("activity");
        List processInfos = am.getRunningAppProcesses();
        String mainProcessName = CoreUtil.getContext().getPackageName();
        int myPid = Process.myPid();
        for (ActivityManager.RunningAppProcessInfo info : processInfos) {
            if (info.pid != myPid || !mainProcessName.equals(info.processName)) continue;
            return true;
        }
        return false;
    }

    public static void sendCompleteBroadcast() {
        try {
            String clientId = PushRepository.getInstance().getSpValue("push_client_id", "");
            String token = PushRepository.getInstance().getSpValue("push_token", "");
            if (TextUtils.isEmpty((CharSequence)clientId) || TextUtils.isEmpty((CharSequence)token)) {
                return;
            }
            if (isInitSuccess.get()) {
                return;
            }
            if (PushManager.getInstance().getPushListener() != null) {
                PushManager.getInstance().getPushListener().onSdkInitSuccess(clientId, token);
                isInitSuccess.set(true);
            } else {
                Log.e((String)"PUSH_", (String)"tpush listener is not registered");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sendMessageToTarget(PushMessage message) {
    }
}

