/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.utils;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.transsion.push.bean.PushMessage;
import com.transsion.push.utils.ImageUtils;
import com.transsion.push.utils.PushLogUtils;
import java.util.ArrayList;
import java.util.HashMap;

public class BitmapDownloadUtils {
    public static boolean checkIsDownloadBitmap(PushMessage message) {
        return !TextUtils.isEmpty((CharSequence)message.notiIcon) && URLUtil.isValidUrl((String)message.notiIcon) || !TextUtils.isEmpty((CharSequence)message.notiSmallIcon) && URLUtil.isValidUrl((String)message.notiSmallIcon) || !TextUtils.isEmpty((CharSequence)message.notiImgEx) && URLUtil.isValidUrl((String)message.notiImgEx);
    }

    public static void downloadBitmap(final PushMessage message, final BitmapDownloadListener listener) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                ArrayList<String> imagesUrl = new ArrayList<String>();
                if (!TextUtils.isEmpty((CharSequence)message.notiIcon)) {
                    imagesUrl.add(message.notiIcon);
                }
                if (!TextUtils.isEmpty((CharSequence)message.notiImgEx)) {
                    imagesUrl.add(message.notiImgEx);
                }
                if (!TextUtils.isEmpty((CharSequence)message.notiSmallIcon)) {
                    imagesUrl.add(message.notiSmallIcon);
                }
                if (!TextUtils.isEmpty((CharSequence)message.notiOptionalIcon)) {
                    imagesUrl.add(message.notiOptionalIcon);
                }
                if (imagesUrl.size() <= 0) {
                    if (listener != null) {
                        listener.downloadComplete(message, null);
                    }
                    return;
                }
                ImageUtils.loadImages(message.notiType, imagesUrl, new ImageUtils.ImagesCallback(){

                    @Override
                    public void onComplete(HashMap<String, Bitmap> images) {
                        PushLogUtils.LOG.d((Object)"images download complete");
                        if (listener != null) {
                            listener.downloadComplete(message, images);
                        }
                    }
                });
            }
        });
    }

    public static interface BitmapDownloadListener {
        public void downloadComplete(PushMessage var1, HashMap<String, Bitmap> var2);
    }
}

