/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.utils;

import android.os.Handler;
import android.os.HandlerThread;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadManager {
    static final String TAG = "ThreadManager";

    private ThreadManager() {
    }

    private static ExecutorService getExecutor() {
        return ExecutorHolder.mExecutor;
    }

    private static ExecutorService getSingleExecutor() {
        return SingleExecutorHolder.mSingleExecutor;
    }

    private static ScheduledExecutorService getScheduledExecutor() {
        return ScheduledExecutorHolder.mScheduledExecutor;
    }

    public static final void execute(Runnable task) {
        ThreadManager.getExecutor().execute(task);
    }

    public static final <T> Future<T> submit(Runnable task, T result) {
        return ThreadManager.getExecutor().submit(task, result);
    }

    public static final Future<?> submit(Runnable task) {
        return ThreadManager.getExecutor().submit(task);
    }

    public static final <T> Future<T> submit(Callable<T> task) {
        return ThreadManager.getExecutor().submit(task);
    }

    public static final ScheduledFuture<?> schedule(Runnable task, long delay) {
        return ThreadManager.getScheduledExecutor().schedule(task, delay, TimeUnit.MILLISECONDS);
    }

    public static final <T> ScheduledFuture<T> schedule(Callable<T> task, long delay) {
        return ThreadManager.getScheduledExecutor().schedule(task, delay, TimeUnit.MILLISECONDS);
    }

    public static final ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long initialDelay, long period) {
        return ThreadManager.getScheduledExecutor().scheduleAtFixedRate(task, initialDelay, period, TimeUnit.MILLISECONDS);
    }

    public static ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long initialDelay, long delay) {
        return ThreadManager.getScheduledExecutor().scheduleWithFixedDelay(task, initialDelay, delay, TimeUnit.MILLISECONDS);
    }

    public static void executeInSingle(Runnable task) {
        ThreadManager.getSingleExecutor().execute(task);
    }

    public static <T> Future<T> submitInSingle(Runnable task, T result) {
        return ThreadManager.getSingleExecutor().submit(task, result);
    }

    public static Future<?> submitInSingle(Runnable task) {
        return ThreadManager.getSingleExecutor().submit(task);
    }

    public static <T> Future<T> submitInSingle(Callable<T> task) {
        return ThreadManager.getSingleExecutor().submit(task);
    }

    public static Executor newSerialExecutor() {
        return new SerialExecutor();
    }

    public static void executeInBackground(Runnable task) {
        ThreadManager.execute(task);
    }

    public static void executeInDbWriteThread(Runnable task) {
        ThreadManager.executeInSingle(task);
    }

    private static Handler getTimerThreadHandler() {
        return TimerHandlerThreadHolder.mHandler;
    }

    public static void postDelayed(Runnable r, long delayMillis) {
        ThreadManager.getTimerThreadHandler().postDelayed(r, delayMillis);
    }

    public static void postDelayedAndRemoveBefore(Runnable r, long delayMillis) {
        ThreadManager.getTimerThreadHandler().removeCallbacks(r);
        ThreadManager.getTimerThreadHandler().postDelayed(r, delayMillis);
    }

    public static void postAtTime(Runnable r, long uptimeMillis) {
        ThreadManager.getTimerThreadHandler().postAtTime(r, uptimeMillis);
    }

    private static Handler getEventThreadHandler() {
        return EventHandlerThreadHolder.mHandler;
    }

    public static void runInEventThread(Runnable r) {
        ThreadManager.getEventThreadHandler().post(r);
    }

    private static class ExecutorHolder {
        private static ExecutorService mExecutor = new ThreadPoolExecutor(2, 20, 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new TPushThreadFactory(), new ThreadPoolExecutor.DiscardPolicy());

        private ExecutorHolder() {
        }
    }

    private static class SingleExecutorHolder {
        private static ExecutorService mSingleExecutor = Executors.newSingleThreadExecutor();

        private SingleExecutorHolder() {
        }
    }

    private static class ScheduledExecutorHolder {
        private static ScheduledExecutorService mScheduledExecutor = Executors.newSingleThreadScheduledExecutor();

        private ScheduledExecutorHolder() {
        }
    }

    private static class SerialExecutor
    implements Executor {
        final Queue<Runnable> mTasks = new LinkedList<Runnable>();
        Runnable mActive;

        private SerialExecutor() {
        }

        @Override
        public synchronized void execute(final Runnable r) {
            this.mTasks.offer(new Runnable(){

                @Override
                public void run() {
                    try {
                        r.run();
                    }
                    finally {
                        this.scheduleNext();
                    }
                }
            });
            if (this.mActive == null) {
                this.scheduleNext();
            }
        }

        protected synchronized void scheduleNext() {
            this.mActive = this.mTasks.poll();
            if (this.mActive != null) {
                ThreadManager.getExecutor().execute(this.mActive);
            }
        }
    }

    private static class TimerHandlerThreadHolder {
        private static HandlerThread mHandlerThread = new HandlerThread("globle_timer");
        private static Handler mHandler;

        private TimerHandlerThreadHolder() {
        }

        static {
            mHandlerThread.start();
            mHandler = new Handler(mHandlerThread.getLooper());
        }
    }

    private static class EventHandlerThreadHolder {
        private static HandlerThread mHandlerThread = new HandlerThread("event-thread");
        private static Handler mHandler;

        private EventHandlerThreadHolder() {
        }

        static {
            mHandlerThread.start();
            mHandler = new Handler(mHandlerThread.getLooper());
        }
    }

    private static class TPushThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        TPushThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "tpush-pool-" + poolNumber.getAndIncrement();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

