/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.os.Build;
import com.transsion.push.R;

public class BitmapUtils {
    private static Bitmap mSmallIcon;

    public static Bitmap getLargeCornerBitmap(Context context, int bitmapResId) {
        Bitmap bitmap = BitmapUtils.getBitmapFromRes(context, bitmapResId);
        return BitmapUtils.getRoundBitmap(bitmap, BitmapUtils.getScaleCorner(context.getResources().getDimensionPixelSize(R.dimen.tpush_notification_icon_corner_large), context.getResources().getDimensionPixelSize(R.dimen.tpush_notification_large_icon_size), bitmap.getWidth()));
    }

    public static Bitmap getSmallCornerBitmap(Context context, int bitmapResId) {
        Bitmap bitmap = BitmapUtils.getBitmapFromRes(context, bitmapResId);
        return BitmapUtils.getRoundBitmap(bitmap, BitmapUtils.getScaleCorner(context.getResources().getDimensionPixelSize(R.dimen.tpush_notification_icon_corner_small), context.getResources().getDimensionPixelSize(R.dimen.tpush_notification_small_icon_size), bitmap.getWidth()));
    }

    public static Bitmap getLargeCornerBitmap(Context context, Bitmap bitmap) {
        return BitmapUtils.getRoundBitmap(bitmap, BitmapUtils.getScaleCorner(context.getResources().getDimensionPixelSize(R.dimen.tpush_notification_icon_corner_large), context.getResources().getDimensionPixelSize(R.dimen.tpush_notification_large_icon_size), bitmap.getWidth()));
    }

    public static Bitmap getSmallCornerBitmap(Context context, Bitmap bitmap) {
        if (mSmallIcon != null) {
            return mSmallIcon;
        }
        mSmallIcon = BitmapUtils.getRoundBitmap(bitmap, BitmapUtils.getScaleCorner(context.getResources().getDimensionPixelSize(R.dimen.tpush_notification_icon_corner_small), context.getResources().getDimensionPixelSize(R.dimen.tpush_notification_small_icon_size), bitmap.getWidth()));
        return mSmallIcon;
    }

    public static Bitmap getRoundBitmap(Context context, int bitmapResId, int cornerPixels) {
        Bitmap bitmap = BitmapUtils.getBitmapFromRes(context, bitmapResId);
        return BitmapUtils.getRoundBitmap(bitmap, cornerPixels);
    }

    private static Bitmap getRoundBitmap(Bitmap bitmap, int cornerPixels) {
        Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        RectF rectF = new RectF(rect);
        float roundPx = cornerPixels;
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-1);
        canvas.drawRoundRect(rectF, roundPx, roundPx, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        bitmap.recycle();
        return output;
    }

    private static Bitmap getBitmapFromRes(Context context, int bitmapResId) {
        Bitmap bitmap;
        if (Build.VERSION.SDK_INT > 21) {
            Drawable vectorDrawable = context.getDrawable(bitmapResId);
            bitmap = Bitmap.createBitmap((int)vectorDrawable.getIntrinsicWidth(), (int)vectorDrawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            vectorDrawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            vectorDrawable.draw(canvas);
        } else {
            bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)bitmapResId);
        }
        return bitmap;
    }

    private static int getScaleCorner(int originCorner, int widgetSize, int imageSize) {
        if (widgetSize != imageSize) {
            int size = originCorner * imageSize / widgetSize;
            return size;
        }
        return originCorner;
    }
}

