/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.utils;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import com.transsion.core.CoreUtil;
import com.transsion.json.Tson;
import com.transsion.push.PushManager;
import com.transsion.push.bean.PushExtButtonList;
import com.transsion.push.bean.PushExtensionBtn;
import com.transsion.push.bean.PushMessage;
import com.transsion.push.broadcast.HandlerBroadcastReceiver;
import com.transsion.push.tracker.Tracker;
import com.transsion.push.utils.PushIml;
import com.transsion.push.utils.PushLogUtils;
import com.transsion.push.utils.PushUtils;
import java.util.List;
import java.util.UUID;

public final class NotificationHelper {
    private static final String DEEPLINK_FLAG = "://";

    public static Notification.Builder getNotificationBuilder(Context context, PushMessage message) {
        List<PushExtensionBtn> extButtonList;
        if (message == null) {
            PushLogUtils.LOG.e((Object)"Get the notification object, the message is empty");
            return null;
        }
        if (message.notiType != 1 && message.notiType != 3) {
            PushLogUtils.LOG.e((Object)("Notification type is not supported\uff0cnotiType:" + message.notiType));
            return null;
        }
        if (message.notiExType != 1 && message.notiExType != 2 && message.notiExType != 3) {
            PushLogUtils.LOG.e((Object)("Notification expansion type is not supported\uff0cnotiExType:" + message.notiExType));
            return null;
        }
        Notification.Builder builder = Build.VERSION.SDK_INT >= 26 ? new Notification.Builder(context, TextUtils.isEmpty((CharSequence)message.channelId) ? "twibida" : message.channelId) : new Notification.Builder(context);
        builder.setWhen(System.currentTimeMillis()).setShowWhen(true).setAutoCancel(true).setDefaults(2).setDefaults(1).setContentIntent(PushIml.getPendingIntent(context, message));
        if ("1".equals(message.floatNotice)) {
            PushLogUtils.LOG.d((Object)"head up");
            builder.setPriority(2);
        } else {
            PushLogUtils.LOG.d((Object)"no head up");
            builder.setPriority(0);
        }
        if (Build.VERSION.SDK_INT >= 20 && (extButtonList = NotificationHelper.getExtensionButtonList(message)) != null && extButtonList.size() > 0) {
            for (PushExtensionBtn btn : extButtonList) {
                PushMessage pushMessage = NotificationHelper.copyPushMessage(message, btn.type, btn.content);
                builder.addAction(new Notification.Action(0, (CharSequence)btn.txt, PushIml.getPendingIntent(context, pushMessage)));
            }
        }
        if (Build.VERSION.SDK_INT >= 26) {
            builder.setChannelId(TextUtils.isEmpty((CharSequence)message.channelId) ? "twibida" : message.channelId);
            if ("1".equals(message.floatNotice)) {
                builder.setChannelId("headup");
            }
        }
        if (Build.VERSION.SDK_INT >= 20) {
            Bundle bundle = new Bundle();
            bundle.putBoolean("extra_from_tpush_noti", true);
            builder.addExtras(bundle);
        }
        return builder;
    }

    private static PushMessage copyPushMessage(PushMessage message, int openType, String openContent) {
        PushMessage pushMessage = new PushMessage();
        pushMessage.setMessageId(message.messageId);
        pushMessage.setChannelName(message.channelName);
        pushMessage.setNotiOpenType(openType);
        pushMessage.setNotiOpenContent(openContent);
        pushMessage.setPackageName(message.packageName);
        return pushMessage;
    }

    private static List<PushExtensionBtn> getExtensionButtonList(PushMessage message) {
        if (TextUtils.isEmpty((CharSequence)message.notiExtensionBtn)) {
            return null;
        }
        try {
            PushExtButtonList extensionBtns = (PushExtButtonList)Tson.fromJson((String)message.notiExtensionBtn, PushExtButtonList.class);
            if (extensionBtns.list.size() == 0) {
                return null;
            }
            return extensionBtns.list;
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)e);
            return null;
        }
    }

    private static PendingIntent getPendingIntent(Context context, PushMessage message) {
        Intent intent = new Intent(context, HandlerBroadcastReceiver.class);
        intent.setAction(context.getPackageName() + ".push.action");
        intent.setPackage(context.getPackageName());
        intent.putExtra("message", Tson.toJson((Object)message));
        PendingIntent pt = Build.VERSION.SDK_INT >= 23 ? PendingIntent.getBroadcast((Context)context, (int)UUID.randomUUID().hashCode(), (Intent)intent, (int)0x4000000) : PendingIntent.getBroadcast((Context)context, (int)UUID.randomUUID().hashCode(), (Intent)intent, (int)0x40000000);
        return pt;
    }

    public static void cancelNotification(long messageId) {
        try {
            NotificationManager notificationManager = (NotificationManager)CoreUtil.getContext().getSystemService("notification");
            if (notificationManager == null) {
                return;
            }
            notificationManager.cancel((int)messageId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void handlerClick(Context context, Intent intent) {
        PushMessage message;
        block10: {
            message = NotificationHelper.getIntentMessage(intent);
            if (message == null) {
                PushLogUtils.LOG.e((Object)"handler notification messages, message empty");
                return;
            }
            if (1 == message.notiOpenType) {
                try {
                    Intent it = new Intent();
                    if (!TextUtils.isEmpty((CharSequence)message.notiOpenContent) && message.notiOpenContent.contains(DEEPLINK_FLAG)) {
                        Uri uri = Uri.parse((String)message.notiOpenContent);
                        it.setData(uri);
                    } else {
                        it.setClassName(message.packageName, message.notiOpenContent);
                    }
                    it.setFlags(0x10800000);
                    context.startActivity(it);
                }
                catch (Exception e) {
                    PushLogUtils.LOG.w((Object)("e:" + e.getMessage()));
                    NotificationHelper.startDefaultActivity(context, message);
                    if (PushManager.getInstance().getPushListener() != null) {
                        PushManager.getInstance().getPushListener().onClickException(message.messageId, e.getMessage());
                    }
                    break block10;
                }
            }
            if (2 == message.notiOpenType) {
                try {
                    Uri uri = Uri.parse((String)message.notiOpenContent);
                    Intent it = new Intent("android.intent.action.VIEW", uri);
                    it.setFlags(0x10000000);
                    context.startActivity(it);
                }
                catch (Exception e) {
                    PushLogUtils.LOG.w((Object)("e:" + e.getMessage()));
                    NotificationHelper.startDefaultActivity(context, message);
                    if (PushManager.getInstance().getPushListener() == null) break block10;
                    PushManager.getInstance().getPushListener().onClickException(message.messageId, e.getMessage());
                }
            }
        }
        NotificationHelper.cancelNotification(message.messageId);
        PushUtils.setClickMessage(message.messageId);
        Tracker.getInstance().trackClick(message.messageId, message);
    }

    private static void startDefaultActivity(Context context, PushMessage message) {
        PackageManager packageManager = context.getPackageManager();
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.LAUNCHER");
        intent.setPackage(message.packageName);
        List resolveInfos = packageManager.queryIntentActivities(intent, 0);
        if (resolveInfos != null && resolveInfos.size() > 0) {
            if (((ResolveInfo)resolveInfos.get((int)0)).activityInfo == null) {
                return;
            }
            try {
                Intent targetIntent = new Intent();
                targetIntent.setFlags(343932928);
                targetIntent.setClassName(((ResolveInfo)resolveInfos.get((int)0)).activityInfo.packageName, ((ResolveInfo)resolveInfos.get((int)0)).activityInfo.name);
                context.startActivity(targetIntent);
            }
            catch (Exception e) {
                e.printStackTrace();
                PushLogUtils.LOG.e((Object)("e:" + e.getMessage()));
            }
        }
    }

    private static PushMessage getIntentMessage(Intent intent) {
        if (intent == null) {
            return null;
        }
        String messageStr = intent.getStringExtra("message");
        PushMessage message = null;
        try {
            message = (PushMessage)Tson.fromJson((String)messageStr, PushMessage.class);
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)"Notification service message is empty");
        }
        return message;
    }
}

