/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.pushui.activity;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.transsion.core.CoreUtil;
import com.transsion.json.Tson;
import com.transsion.push.bean.PushMessage;
import com.transsion.push.tracker.Tracker;
import com.transsion.push.utils.NotificationHelper;
import com.transsion.push.utils.PushLogUtils;
import com.transsion.push.utils.ServiceUtils;
import com.transsion.push.utils.StatusBarUtils;

public class TransparentActivity
extends Activity {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            CoreUtil.init((Context)this.getApplicationContext());
            Tracker.getInstance().init();
            StatusBarUtils.setStatusBarColor(this, 17170445);
            StatusBarUtils.setStatusBarLightMode(this.getWindow(), true);
            StatusBarUtils.setNavigationBarColor(this, 17170445);
            StatusBarUtils.setNavigationBarLightMode(this, true);
            boolean isNotiClick = this.getIntent().getBooleanExtra("extra_noti_click", false);
            if (isNotiClick) {
                NotificationHelper.handlerClick(this.getApplicationContext(), this.getIntent());
                return;
            }
            String messageStr = this.getIntent().getStringExtra("message");
            if (TextUtils.isEmpty((CharSequence)messageStr)) {
                return;
            }
            PushMessage message = (PushMessage)Tson.fromJson((String)messageStr, PushMessage.class);
            Bundle bundle = new Bundle();
            bundle.putString("message", Tson.toJson((Object)message));
            bundle.putString("service_type", "message");
            ServiceUtils.startTargetIntentService(CoreUtil.getContext(), bundle);
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("Transparent page exception\uff0ce:" + e.getMessage()));
        }
        finally {
            this.finish();
        }
    }
}

