/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.text.TextUtils;
import android.widget.RemoteViews;
import com.transsion.push.R;
import com.transsion.push.bean.PushMessage;
import com.transsion.push.bean.PushNotification;
import com.transsion.push.utils.BitmapUtils;
import com.transsion.push.utils.PushLogUtils;
import com.transsion.push.utils.PushUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

public final class CustomNotificationUtils {
    private static HashMap<String, PushNotification> mCustomNotification = new HashMap();

    public static void addCustomNotification(PushNotification notification) {
        if (notification == null) {
            return;
        }
        mCustomNotification.put(CustomNotificationUtils.getCustomNotificationKey(notification.getType(), notification.getStyleId()), notification);
    }

    public static PushNotification getCustomNotificationLayout(int messageType, int styleId) {
        return mCustomNotification.get(CustomNotificationUtils.getCustomNotificationKey(messageType, styleId));
    }

    public static String getCustomNotificationKey(int type, int styleId) {
        return type + "#" + styleId;
    }

    public static boolean isExtensibleNotification(int extTpye) {
        return extTpye == 3 || extTpye == 2;
    }

    public static RemoteViews getCustomRemoteViews(Context context, PushMessage message, HashMap<String, Bitmap> images, boolean isBigView) {
        if (message.notiType != 3) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 31) {
            RemoteViews customViews = new RemoteViews(context.getPackageName(), R.layout.tpush_notification_31);
            customViews.setTextViewText(R.id.tpush_titleTv, (CharSequence)message.notiTitle);
            customViews.setTextViewText(R.id.tpush_descriptionTv, (CharSequence)message.notiDes);
            if (!TextUtils.isEmpty((CharSequence)message.notiBtn)) {
                customViews.setTextViewText(R.id.tpush_actionBtn, (CharSequence)message.notiBtn);
                customViews.setViewVisibility(R.id.tpush_actionBtn, 0);
            } else {
                customViews.setViewVisibility(R.id.tpush_actionBtn, 8);
            }
            return customViews;
        }
        RemoteViews customViews = new RemoteViews(context.getPackageName(), R.layout.tpush_custom_button_style);
        String pkgName = TextUtils.isEmpty((CharSequence)message.rpkg) ? context.getPackageName() : message.rpkg;
        try {
            customViews.setImageViewBitmap(R.id.tpush_smallIconImg, BitmapUtils.getSmallCornerBitmap(context, PushUtils.getApplicationIcon(context, pkgName)));
        }
        catch (Exception e) {
            PushLogUtils.LOG.d((Object)("set imageview Exception" + e));
        }
        String appName = PushUtils.getDisplayAppName(context, message);
        StringBuilder sb = new StringBuilder();
        if (!TextUtils.isEmpty((CharSequence)appName)) {
            sb.append(appName);
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat("h:mm a", Locale.getDefault());
            String time = df.format(new Date());
            sb.append(" \u00b7 ").append(time);
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)e);
        }
        customViews.setTextViewText(R.id.tpush_smallTitleTv, (CharSequence)sb.toString());
        if (images != null && images.get(message.notiIcon) != null && !CustomNotificationUtils.isTarget31()) {
            customViews.setImageViewBitmap(R.id.tpush_largeIconImg, images.get(message.notiIcon));
            customViews.setViewVisibility(R.id.tpush_largeIconImg, 0);
        } else {
            customViews.setViewVisibility(R.id.tpush_largeIconImg, 8);
        }
        customViews.setTextViewText(R.id.tpush_titleTv, (CharSequence)message.notiTitle);
        customViews.setTextViewText(R.id.tpush_descriptionTv, (CharSequence)message.notiDes);
        if (!TextUtils.isEmpty((CharSequence)message.notiBtn)) {
            customViews.setTextViewText(R.id.tpush_actionBtn, (CharSequence)message.notiBtn);
            customViews.setViewVisibility(R.id.tpush_actionBtn, 0);
        } else {
            customViews.setViewVisibility(R.id.tpush_actionBtn, 8);
        }
        return customViews;
    }

    public static RemoteViews getBigView(Context context, PushMessage message, HashMap<String, Bitmap> images, boolean isBigView) {
        if (message.notiType != 3) {
            return null;
        }
        RemoteViews customViews = new RemoteViews(context.getPackageName(), R.layout.tpush_notification_expand_31);
        if (images != null && images.get(message.notiIcon) != null) {
            customViews.setImageViewBitmap(R.id.tpush_largeIconImg, images.get(message.notiIcon));
            customViews.setViewVisibility(R.id.tpush_largeIconImg, 0);
        } else {
            customViews.setViewVisibility(R.id.tpush_largeIconImg, 0);
            if (Build.VERSION.SDK_INT >= 31) {
                customViews.setViewLayoutWidth(R.id.tpush_largeIconImg, 1.0f, 1);
            }
        }
        customViews.setTextViewText(R.id.tpush_titleTv, (CharSequence)message.notiTitle);
        customViews.setTextViewText(R.id.tpush_descriptionTv, (CharSequence)message.notiDes);
        if (!TextUtils.isEmpty((CharSequence)message.notiBtn)) {
            customViews.setTextViewText(R.id.tpush_actionBtn, (CharSequence)message.notiBtn);
            customViews.setViewVisibility(R.id.tpush_actionBtn, 0);
        } else {
            customViews.setViewVisibility(R.id.tpush_actionBtn, 8);
        }
        return customViews;
    }

    public static boolean isTarget31() {
        boolean isTarget31 = false;
        try {
            isTarget31 = Build.VERSION.SDK_INT >= 31;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isTarget31;
    }
}

