/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.utils;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Icon;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.widget.RemoteViews;
import com.transsion.core.CoreUtil;
import com.transsion.gslb.GslbSdk;
import com.transsion.json.Tson;
import com.transsion.push.PushManager;
import com.transsion.push.R;
import com.transsion.push.bean.PushMessage;
import com.transsion.push.bean.PushNotification;
import com.transsion.push.bean.PushRequest;
import com.transsion.push.service.PushServiceHelper;
import com.transsion.push.tracker.Tracker;
import com.transsion.push.utils.CustomNotificationUtils;
import com.transsion.push.utils.NotificationAssistUtils;
import com.transsion.push.utils.NotificationHelper;
import com.transsion.push.utils.PushLogUtils;
import com.transsion.push.utils.PushUtils;
import com.transsion.push.utils.WhiteListUtils;
import com.transsion.pushui.activity.TransparentActivity;
import java.util.HashMap;
import java.util.UUID;

public class PushIml {
    public static void sendNotification(PushMessage message, HashMap<String, Bitmap> images) {
        Context context = null;
        try {
            context = CoreUtil.getContext();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (context == null) {
            Tracker.getInstance().trackShow(message.messageId, message.type, message.timeStamp, true, 2, message);
            return;
        }
        boolean enabled = NotificationAssistUtils.isOpenNotification(context);
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (notificationManager == null) {
            Tracker.getInstance().trackShow(message.messageId, message.type, message.timeStamp, enabled, 3, message);
            return;
        }
        PushIml.checkChannelId(message);
        Notification.Builder builder = NotificationHelper.getNotificationBuilder(context, message);
        if (builder == null) {
            Tracker.getInstance().trackShow(message.messageId, message.type, message.timeStamp, enabled, 4, message);
            return;
        }
        Notification notification = PushIml.setNotificationView(context, message, images, builder);
        if (notification == null) {
            Tracker.getInstance().trackShow(message.messageId, message.type, message.timeStamp, enabled, 5, message);
            return;
        }
        try {
            String defaultChannelName;
            String defaultChannelId = TextUtils.isEmpty((CharSequence)message.channelId) ? "twibida" : message.channelId;
            String string = defaultChannelName = TextUtils.isEmpty((CharSequence)message.channelName) ? "cloud messaging" : message.channelName;
            if (Build.VERSION.SDK_INT >= 26) {
                boolean isFloatNotice = false;
                if (!TextUtils.isEmpty((CharSequence)message.floatNotice) && message.floatNotice.equals("1")) {
                    isFloatNotice = true;
                    defaultChannelId = "headup";
                    defaultChannelName = "head up messaging";
                    PushLogUtils.LOG.d((Object)"float notice");
                }
                NotificationChannel notificationChannel = new NotificationChannel(defaultChannelId, (CharSequence)defaultChannelName, isFloatNotice ? 4 : 3);
                if (isFloatNotice) {
                    notificationChannel.setShowBadge(true);
                    notificationChannel.setLockscreenVisibility(1);
                    if (Build.VERSION.SDK_INT >= 36 && !TextUtils.isEmpty((CharSequence)message.floatNotice) && message.floatNotice.equals("1")) {
                        builder.setGroup("float_" + message.messageId);
                    }
                }
                PushLogUtils.LOG.d((Object)("message.channelId" + message.channelId + message.channelName));
                notificationManager.createNotificationChannel(notificationChannel);
            }
            PushServiceHelper.handleMaxLimitMessage(message, notificationManager);
            notificationManager.notify((int)message.messageId, notification);
            Tracker.getInstance().trackShow(message.messageId, message.type, message.timeStamp, enabled, enabled ? 0 : 6, message);
            if (PushManager.getInstance().getPushListener() != null) {
                PushManager.getInstance().getPushListener().onNotificationShow(message.messageId, message.notiOpenContent);
            }
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)e);
            Tracker.getInstance().trackShow(message.messageId, message.type, message.timeStamp, enabled, 7, message);
        }
    }

    public static Notification setNotificationView(Context context, PushMessage message, HashMap<String, Bitmap> images, Notification.Builder builder) {
        Icon icon;
        if (message == null || builder == null) {
            return null;
        }
        PushNotification pn = CustomNotificationUtils.getCustomNotificationLayout(message.notiType, message.layoutStyleId);
        if (images != null && images.get(message.notiSmallIcon) != null && Build.VERSION.SDK_INT >= 23) {
            icon = Icon.createWithBitmap((Bitmap)images.get(message.notiSmallIcon));
            builder.setSmallIcon(icon);
        } else if (pn != null && pn.getSmallIcon() > 0) {
            builder.setSmallIcon(pn.getSmallIcon());
        } else {
            builder.setSmallIcon(R.drawable.tpush_notify_icon);
        }
        if (images != null && images.get(message.notiOptionalIcon) != null && Build.VERSION.SDK_INT >= 23) {
            icon = Icon.createWithBitmap((Bitmap)images.get(message.notiOptionalIcon));
            builder.setLargeIcon(icon);
        }
        PushIml.setIconColor(builder, message);
        if (message.notiType == 1) {
            builder.setContentTitle((CharSequence)message.notiTitle).setContentText((CharSequence)message.notiDes);
            if (message.notiExType == 2) {
                builder.setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)message.notiTxtEx));
            } else if (message.notiExType == 3 && images != null && images.get(message.notiImgEx) != null) {
                builder.setLargeIcon(images.get(message.notiImgEx));
                builder.setStyle((Notification.Style)new Notification.BigPictureStyle().bigPicture(images.get(message.notiImgEx)).bigLargeIcon((Bitmap)null));
            }
            builder.setContentIntent(PushIml.getPendingIntent(CoreUtil.getContext(), message));
            return builder.build();
        }
        RemoteViews remoteViews = CustomNotificationUtils.getCustomRemoteViews(context, message, images, false);
        if (remoteViews == null) {
            return builder.build();
        }
        builder.setContentTitle((CharSequence)message.notiTitle);
        builder.setContentText((CharSequence)message.notiDes);
        if (Build.VERSION.SDK_INT >= 24) {
            builder.setCustomContentView(remoteViews);
        } else {
            builder.setContent(remoteViews);
        }
        if (Build.VERSION.SDK_INT >= 31) {
            builder.setStyle((Notification.Style)new Notification.DecoratedCustomViewStyle());
            RemoteViews bigView = CustomNotificationUtils.getBigView(context, message, images, false);
            builder.setCustomBigContentView(bigView);
        }
        return builder.build();
    }

    public static void registerReceiver(BroadcastReceiver receiver, IntentFilter intentFilter) {
    }

    public static void onHandleChannelMessage(Intent intent) {
        if (intent == null) {
            return;
        }
        final PushMessage message = PushUtils.getIntentMessage(intent);
        if (message == null) {
            PushLogUtils.LOG.w((Object)"message is null");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)message.packageName)) {
            message.packageName = WhiteListUtils.idToPackageName(message.pkgId);
        }
        PushLogUtils.LOG.d((Object)("message target packageName:" + message.packageName));
        if (TextUtils.isEmpty((CharSequence)message.packageName)) {
            PushLogUtils.LOG.d((Object)" packageName is null ignore");
            Tracker.getInstance().trackMessage(message.messageId, message.type, message.timeStamp, "fail", 5);
            return;
        }
        message.pkgId = message.packageName;
        try {
            if (CoreUtil.getContext().getPackageName().equals(message.packageName)) {
                Tracker.getInstance().trackMessage(message.messageId, message.type, message.timeStamp, "success", 0);
                PushUtils.sendMessageToTarget(message);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (PushUtils.checkUninstall(message.packageName)) {
            Tracker.getInstance().trackUninstall(message.messageId, message.packageName);
            Tracker.getInstance().trackMessage(message.messageId, message.type, message.timeStamp, "fail", 3);
            return;
        }
        if (!PushUtils.checkMessage(message, 0)) {
            return;
        }
        PushUtils.setMessageHandled(message.messageId);
        if (Build.VERSION.SDK_INT > 28 && PushUtils.isAppForeground()) {
            return;
        }
        if (PushUtils.isAppDisable(message.packageName)) {
            return;
        }
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

            @Override
            public void run() {
                try {
                    Intent targetIntent = new Intent();
                    targetIntent.putExtra("message", Tson.toJson((Object)message));
                    targetIntent.setClassName(message.packageName, TransparentActivity.class.getName());
                    targetIntent.setFlags(0x10000000);
                    CoreUtil.getContext().startActivity(targetIntent);
                    Tracker.getInstance().trackMessage(message.messageId, message.type, message.timeStamp, "success", 0);
                }
                catch (Exception e) {
                    PushLogUtils.LOG.e((Object)e);
                }
            }
        }, (long)(Math.random() * 1500.0 + 500.0));
    }

    public static void checkChannelId(PushMessage message) {
        if (message == null) {
            return;
        }
        PushNotification pn = CustomNotificationUtils.getCustomNotificationLayout(message.notiType, message.layoutStyleId);
        String channelId = message.channelId;
        try {
            if (TextUtils.isEmpty((CharSequence)channelId)) {
                channelId = pn.getChannelId();
            }
            if (TextUtils.isEmpty((CharSequence)channelId)) {
                channelId = "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        message.channelId = channelId;
    }

    private static void setIconColor(Notification.Builder builder, PushMessage message) {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        try {
            if (!TextUtils.isEmpty((CharSequence)message.iconColor)) {
                int color = Color.parseColor((String)message.iconColor);
                builder.setColor(color);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PushNotification pn = CustomNotificationUtils.getCustomNotificationLayout(message.notiType, message.layoutStyleId);
        try {
            if (!TextUtils.isEmpty((CharSequence)pn.getIconColor())) {
                int color = Color.parseColor((String)pn.getIconColor());
                builder.setColor(color);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static PendingIntent getPendingIntent(Context context, PushMessage message) {
        Intent intent = new Intent(context, TransparentActivity.class);
        intent.setPackage(context.getPackageName());
        intent.putExtra("message", Tson.toJson((Object)message));
        intent.putExtra("extra_noti_click", true);
        PendingIntent pt = Build.VERSION.SDK_INT >= 23 ? PendingIntent.getActivity((Context)context, (int)UUID.randomUUID().hashCode(), (Intent)intent, (int)0x4000000) : PendingIntent.getActivity((Context)context, (int)UUID.randomUUID().hashCode(), (Intent)intent, (int)0x8000000);
        return pt;
    }

    public static int getPlatformSdkVersion() {
        return 0;
    }

    public static void setAppsContent(PushRequest.ReportContentData dataContent) {
    }

    public static void saveDestroyConfig(String[] destroyApps, int syncInfoInterval) {
    }

    public static String getReportUrl() {
        if (PushManager.getInstance().getTestEnv()) {
            return "https://test-api.twibida.com/tcm/v2/instance/";
        }
        if (PushManager.getInstance().getDebug()) {
            return "https://devtest-api.twibida.com/tcm/v2/instance/";
        }
        try {
            String domainUrl = GslbSdk.getDomain((String)"https://api.twibida.com/tcm/v2/instance/", (boolean)false);
            if (!TextUtils.isEmpty((CharSequence)domainUrl)) {
                PushLogUtils.LOG.d((Object)("gslb domain is" + domainUrl));
                return domainUrl;
            }
            PushLogUtils.LOG.d((Object)"gslb domain is empty");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static boolean isSystemChannel() {
        return false;
    }
}

