/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.utils;

import android.app.AppOpsManager;
import android.app.NotificationManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class NotificationAssistUtils {
    public static boolean isOpenNotification(Context context) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 24) {
            return notificationManager == null || notificationManager.areNotificationsEnabled();
        }
        if (Build.VERSION.SDK_INT < 19) {
            return true;
        }
        return NotificationAssistUtils.isNotificationEnabled(context);
    }

    private static boolean isNotificationEnabled(Context context) {
        String CHECK_OP_NO_THROW = "checkOpNoThrow";
        String OP_POST_NOTIFICATION = "OP_POST_NOTIFICATION";
        if (!NotificationAssistUtils.checkAppOpsManager()) {
            return true;
        }
        try {
            AppOpsManager mAppOps = (AppOpsManager)context.getSystemService("appops");
            ApplicationInfo appInfo = context.getApplicationInfo();
            String pkg = context.getApplicationContext().getPackageName();
            int uid = appInfo.uid;
            Class<?> appOpsClass = null;
            appOpsClass = Class.forName(AppOpsManager.class.getName());
            Method checkOpNoThrowMethod = appOpsClass.getMethod(CHECK_OP_NO_THROW, Integer.TYPE, Integer.TYPE, String.class);
            Field opPostNotificationValue = appOpsClass.getDeclaredField(OP_POST_NOTIFICATION);
            int value = (Integer)opPostNotificationValue.get(Integer.class);
            return (Integer)checkOpNoThrowMethod.invoke((Object)mAppOps, value, uid, pkg) == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean checkAppOpsManager() {
        try {
            Class.forName("android.app.AppOpsManager");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

