/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.transsion.push.bean.PushPointInfo;
import com.transsion.push.db.PushDbHelper;
import com.transsion.push.utils.PushLogUtils;
import java.util.ArrayList;
import java.util.List;

public class PushDbManager {
    private PushDbHelper mPushDbHelper;
    private SQLiteDatabase mDatabase;

    public static PushDbManager getInstance() {
        return Holder.INSTANCE;
    }

    public void init(Context context) {
        this.mPushDbHelper = new PushDbHelper(context);
    }

    public void insertMsg(String evt) {
        try {
            this.mDatabase = this.mPushDbHelper.getWritableDatabase();
            ContentValues values = new ContentValues();
            values.put("evt", evt);
            values.put("time", Long.valueOf(System.currentTimeMillis()));
            long rowId = this.mDatabase.insert("report", null, values);
            PushLogUtils.LOG.d((Object)("insert report record success, rowId:" + rowId));
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("insert report record fail, e:" + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PushPointInfo> queryPoints() {
        Cursor cursor;
        ArrayList<PushPointInfo> points;
        block6: {
            points = new ArrayList<PushPointInfo>();
            cursor = null;
            this.mDatabase = this.mPushDbHelper.getReadableDatabase();
            String sql = "select * from report order by time desc  limit 100";
            cursor = this.mDatabase.rawQuery(sql, null);
            if (cursor != null) break block6;
            ArrayList<PushPointInfo> arrayList = points;
            this.releaseCursor(cursor);
            return arrayList;
        }
        try {
            while (cursor.moveToNext()) {
                int id2 = cursor.getInt(cursor.getColumnIndex("id"));
                String evt = cursor.getString(cursor.getColumnIndex("evt"));
                PushPointInfo point = new PushPointInfo(id2, evt);
                points.add(point);
            }
            PushLogUtils.LOG.d((Object)("queryPoints points:" + points));
            this.releaseCursor(cursor);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                this.releaseCursor(cursor);
            }
            catch (Throwable throwable) {
                this.releaseCursor(cursor);
                throw throwable;
            }
        }
        return points;
    }

    public void deletePoints(List<PushPointInfo> points) {
        if (points == null || points.size() <= 0) {
            return;
        }
        try {
            this.mDatabase = this.mPushDbHelper.getWritableDatabase();
            StringBuilder whereIn = new StringBuilder("( ");
            int N = points.size();
            for (int i = 0; i < N; ++i) {
                if (i == N - 1) {
                    whereIn.append(points.get((int)i).id).append(" )");
                    continue;
                }
                whereIn.append(points.get((int)i).id).append(", ");
            }
            this.mDatabase.execSQL("delete from report where id in " + whereIn);
            PushLogUtils.LOG.d((Object)("deletePoints N:" + N));
        }
        catch (Exception e) {
            PushLogUtils.LOG.d((Object)("delete msg fail, e:" + e.getMessage()));
        }
    }

    private void releaseCursor(Cursor cursor) {
        try {
            if (cursor != null) {
                cursor.close();
            }
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("close db fail, e:" + e.getMessage()));
        }
    }

    private static final class Holder {
        private static final PushDbManager INSTANCE = new PushDbManager();

        private Holder() {
        }
    }
}

