/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.tracker;

import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.transsion.core.utils.AppUtil;
import com.transsion.push.bean.PushMessage;
import com.transsion.push.config.PushRepository;
import com.transsion.push.tracker.AthenaTracker;
import com.transsion.push.tracker.FirebaseTracker;
import com.transsion.push.tracker.InfoeyeTracker;
import com.transsion.push.tracker.PushTracker;
import com.transsion.push.utils.PushUtils;
import java.util.HashMap;

public final class Tracker {
    private static Tracker instance = null;
    private static HashMap<String, Integer> messageMap = new HashMap();
    private static HashMap<String, Integer> targetMap = new HashMap();
    private String packageName;
    private String verName;

    private Tracker() {
        try {
            this.packageName = AppUtil.getPkgName();
            this.verName = AppUtil.getVersionName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        messageMap.put("all", 0);
        messageMap.put("success", 1);
        messageMap.put("fail", 2);
        targetMap.put("success", 3);
        targetMap.put("handled", 4);
    }

    public static Tracker getInstance() {
        if (instance == null) {
            instance = new Tracker();
        }
        return instance;
    }

    public void init() {
        AthenaTracker.getInstance().init();
        InfoeyeTracker.getInstance().init();
    }

    public void trackInit() {
        if (!PushRepository.getInstance().getSpValue("init", false).booleanValue()) {
            Bundle bundle = this.getCommonTracker();
            AthenaTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_INIT, bundle);
            FirebaseTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_INIT, bundle);
            PushRepository.getInstance().putSpValue("init", true);
        }
    }

    public void trackToken(String token) {
        int maxLength = 8;
        String tempToken = "";
        tempToken = TextUtils.isEmpty((CharSequence)token) ? "" : (token.length() <= maxLength ? token : token.substring(0, maxLength));
        Bundle bundle = this.getCommonTracker();
        bundle.putString("token", tempToken);
        AthenaTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_TOKEN, bundle);
        FirebaseTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_TOKEN, bundle);
    }

    public void trackTrigger(int reason) {
        Bundle bundle = this.getCommonTracker();
        bundle.putInt("reason", reason);
        AthenaTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_TRIG, bundle);
        FirebaseTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_TRIG, bundle);
    }

    public void trackReport() {
        Bundle bundle = this.getCommonTracker();
        bundle.putString("pkg", this.packageName);
        bundle.putString("ver", this.verName);
        bundle.putString("sdk", "1.8.8.06");
        AthenaTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_REPORT, bundle);
        FirebaseTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_REPORT, bundle);
        try {
            PushTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_REPORT, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trackConfig(int cfgv, int cfgt) {
        Bundle bundle = this.getCommonTracker();
        bundle.putInt("cfgv", cfgv);
        bundle.putInt("cfgt", cfgt);
        AthenaTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_CFG, bundle);
        FirebaseTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_CFG, bundle);
    }

    public void trackBroadcastInfoeye() {
        try {
            Bundle bundle = this.getCommonTracker();
            InfoeyeTracker.getInstance().track(KEY.INFOEYE_FOR_BROADCAST, bundle);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void trackBroadcastGcmInfoeye() {
        try {
            Bundle bundle = this.getCommonTracker();
            InfoeyeTracker.getInstance().track(KEY.INFOEYE_FOR_BROADCAST_GCM, bundle);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void trackHandleMsgErrorInfoeye(long messageId, String errorContent) {
        try {
            Bundle bundle = this.getCommonTracker();
            bundle.putLong("id", messageId);
            bundle.putString("result", errorContent);
            InfoeyeTracker.getInstance().track(KEY.INFOEYE_FOR_REACH_ERROR, bundle);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void trackTokenUpdateInit() {
        try {
            Bundle bundle = this.getCommonTracker();
            InfoeyeTracker.getInstance().track(KEY.INFOEYE_FOR_TOKEN_INIT, bundle);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void trackTokenUpdateProcess(String result) {
        try {
            Bundle bundle = this.getCommonTracker();
            bundle.putString("result", result);
            InfoeyeTracker.getInstance().track(KEY.INFOEYE_FOR_TOKEN_PROCESS, bundle);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void trackActiveSyncInit() {
        try {
            Bundle bundle = this.getCommonTracker();
            InfoeyeTracker.getInstance().track(KEY.INFOEYE_FOR_SYNC_INIT, bundle);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void trackActiveSyncProcess() {
        try {
            Bundle bundle = this.getCommonTracker();
            InfoeyeTracker.getInstance().track(KEY.INFOEYE_FOR_SYNC_PROCESS, bundle);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void trackMessage(long messageId, int type, String timeStamp, String result, int reason) {
        Bundle bundle = this.getCommonTracker();
        bundle.putLong("id", messageId);
        bundle.putLong("type", (long)type);
        bundle.putLong("do", (long)reason);
        bundle.putString("pts", timeStamp);
        bundle.putString("result", result);
        AthenaTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_MSG, bundle);
        InfoeyeTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_MSG, bundle);
        FirebaseTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_MSG, bundle);
    }

    public void trackTarget(long messageId, int type, String timeStamp, String rpkg, String result) {
        Bundle bundle = this.getCommonTracker();
        bundle.putLong("id", messageId);
        bundle.putLong("type", (long)type);
        bundle.putString("pts", timeStamp);
        bundle.putString("rpkg", rpkg);
        bundle.putString("result", result);
        AthenaTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_TARGET, bundle);
        InfoeyeTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_TARGET, bundle);
        FirebaseTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_TARGET, bundle);
    }

    public void trackTarget(long messageId, int type, String timeStamp, String rpkg, String result, PushMessage pushMessage) {
        Bundle bundle = this.getCommonTracker();
        bundle.putLong("id", messageId);
        bundle.putLong("type", (long)type);
        bundle.putString("pts", timeStamp);
        bundle.putString("rpkg", rpkg);
        bundle.putString("result", result);
        this.buildExtraTrackData(bundle, pushMessage);
        Log.d((String)"PUSH_", (String)("trackTarget, message is :  " + pushMessage));
        AthenaTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_TARGET, bundle);
        InfoeyeTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_TARGET, bundle);
        FirebaseTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_TARGET, bundle);
    }

    public void trackShow(long messageId, int type, String timeStamp, boolean enable, int status) {
        this.trackShow(messageId, type, timeStamp, enable, status, PushUtils.getMessage(messageId));
    }

    public void trackShow(long messageId, int type, String timeStamp, boolean enable, int status, PushMessage pushMessage) {
        Bundle bundle = this.getCommonTracker();
        bundle.putLong("id", messageId);
        bundle.putInt("type", type);
        bundle.putBoolean("able", enable);
        bundle.putString("pts", timeStamp);
        bundle.putInt("status", status);
        bundle.putInt("show_status", status);
        this.buildExtraTrackData(bundle, pushMessage);
        Log.d((String)"PUSH_", (String)("trackShow, message is :  " + pushMessage));
        AthenaTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_SHOW, bundle);
        InfoeyeTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_SHOW, bundle);
    }

    private boolean isFloatNotice(PushMessage pushMessage) {
        if (null == pushMessage) {
            return false;
        }
        boolean isFloatNotice = false;
        if (!TextUtils.isEmpty((CharSequence)pushMessage.floatNotice) && pushMessage.floatNotice.equals("1")) {
            isFloatNotice = true;
        }
        return isFloatNotice;
    }

    public void trackClick(long messageId) {
        PushMessage pushMessage = PushUtils.getMessage(messageId);
        this.trackClick(messageId, pushMessage);
        PushUtils.clearMessage(messageId);
    }

    public void trackClick(long messageId, PushMessage pushMessage) {
        Bundle bundle = this.getCommonTracker();
        bundle.putLong("id", messageId);
        this.buildExtraTrackData(bundle, pushMessage);
        Log.d((String)"PUSH_", (String)("trackClick, message is :  " + pushMessage));
        AthenaTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_CLICK, bundle);
        InfoeyeTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_CLICK, bundle);
    }

    private void buildExtraTrackData(Bundle bundle, PushMessage pushMessage) {
        if (null != pushMessage) {
            bundle.putInt("head_up", this.isFloatNotice(pushMessage) ? 1 : 0);
            bundle.putString("material_id", pushMessage.materialId);
            bundle.putString("seq", pushMessage.seq);
            bundle.putString("sourceType", pushMessage.sourceType);
            bundle.putString("scheduleDate", pushMessage.scheduleDate);
            bundle.putString("tag", pushMessage.tag);
        }
    }

    public void trackImg(String url, int result) {
        Bundle bundle = this.getCommonTracker();
        bundle.putString("url", url);
        bundle.putInt("result", result);
        AthenaTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_IMG_DOWNLOAD, bundle);
        FirebaseTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_IMG_DOWNLOAD, bundle);
    }

    public void trackTrace(int type, String data) {
        Bundle bundle = this.getCommonTracker();
        bundle.putInt("type", type);
        bundle.putInt("osV", Build.VERSION.SDK_INT);
        bundle.putString("data", data);
        AthenaTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_TRACE, bundle);
        FirebaseTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_TRACE, bundle);
    }

    public void trackUninstall(long messageId, String tpkg) {
        Bundle bundle = this.getCommonTracker();
        bundle.putLong("id", messageId);
        bundle.putString("tpkg", tpkg);
        AthenaTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_UNINSTALL, bundle);
        FirebaseTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_UNINSTALL, bundle);
    }

    public void trackConversion(long messageId) {
        Bundle bundle = this.getCommonTracker();
        bundle.putLong("id", messageId);
        AthenaTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_CONVERSION, bundle);
        FirebaseTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_CONVERSION, bundle);
    }

    public void trackInstall() {
        boolean isTrackInstall = PushRepository.getInstance().getSpValue("is_track_install", false);
        if (!isTrackInstall) {
            PushRepository.getInstance().putSpValue("is_track_install", true);
            PushTracker.getInstance().track(KEY.ATHENA_TID_FOR_APP_INSTALL, null);
        }
    }

    public void tracks() {
        PushTracker.getInstance().tracks();
    }

    private Bundle getCommonTracker() {
        Bundle bundle = new Bundle();
        bundle.putString("pkg", this.packageName);
        bundle.putString("ver", this.verName);
        bundle.putString("sdk", "1.8.8.06");
        bundle.putString("appid", PushUtils.getAppId());
        return bundle;
    }

    public static enum KEY {
        INFOEYE_FOR_BROADCAST(0, "infoeye", "hipush_broadcast"),
        INFOEYE_FOR_BROADCAST_GCM(0, "infoeye", "hipush_broadcast_gcm"),
        INFOEYE_FOR_REACH_ERROR(0, "infoeye", "hipush_reach_error"),
        INFOEYE_FOR_TOKEN_INIT(0, "infoeye", "hipush_token_init"),
        INFOEYE_FOR_TOKEN_PROCESS(0, "infoeye", "hipush_token_process"),
        INFOEYE_FOR_SYNC_INIT(0, "infoeye", "hipush_sync_init"),
        INFOEYE_FOR_SYNC_PROCESS(0, "infoeye", "hipush_sync_process"),
        ATHENA_TID_FOR_APP_INIT(10410001, "init"),
        ATHENA_TID_FOR_APP_TOKEN(10410002, "token"),
        ATHENA_TID_FOR_APP_TRIG(10410003, "trig"),
        ATHENA_TID_FOR_APP_REPORT(10410004, "report"),
        ATHENA_TID_FOR_APP_CFG(10410005, "cfg"),
        ATHENA_TID_FOR_APP_MSG(10410006, "msg", "hipush_reach_init"),
        ATHENA_TID_FOR_APP_TARGET(10410007, "arrive", "hipush_reach_process"),
        ATHENA_TID_FOR_APP_SHOW(10410008, "show", "hipush_show"),
        ATHENA_TID_FOR_APP_CLICK(10410009, "click", "hipush_click"),
        ATHENA_TID_FOR_APP_IMG_DOWNLOAD(10410010, "img"),
        ATHENA_TID_FOR_APP_TRACE(10410011, "trace"),
        ATHENA_TID_FOR_APP_UNINSTALL(10410012, "uninstall"),
        ATHENA_TID_FOR_APP_CONVERSION(10410013, "conversion"),
        ATHENA_TID_FOR_APP_INSTALL(10410014, "install");

        public String event;
        public int tid;
        public String infoeyeEvent;

        private KEY(int tid, String event) {
            this.event = event;
            this.tid = tid;
        }

        private KEY(int tid, String event, String infoeyeEvent) {
            this.event = event;
            this.tid = tid;
            this.infoeyeEvent = infoeyeEvent;
        }
    }
}

