/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import com.transsion.core.CoreUtil;
import com.transsion.core.utils.SharedPreferencesUtil;
import com.transsion.crypto.TCrypterSdk;
import com.transsion.gslb.GslbSdk;
import com.transsion.push.IClientIdListener;
import com.transsion.push.ITopicListener;
import com.transsion.push.TPushListener;
import com.transsion.push.bean.PushConfig;
import com.transsion.push.bean.PushNotification;
import com.transsion.push.broadcast.PushBroadcastReceiver;
import com.transsion.push.config.PushRepository;
import com.transsion.push.tracker.Tracker;
import com.transsion.push.utils.CustomNotificationUtils;
import com.transsion.push.utils.FirebaseUtils;
import com.transsion.push.utils.NotificationAssistUtils;
import com.transsion.push.utils.PushLogUtils;
import com.transsion.push.utils.PushUtils;
import com.transsion.push.utils.ServiceUtils;
import com.transsion.push.utils.ThreadManager;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public final class PushManager {
    private PushBroadcastReceiver mPushBroadcastReceiver;
    private static AtomicBoolean sInit = new AtomicBoolean(false);
    private static boolean sSdkInitFinished;
    private TPushListener mListener;
    public static final int SHOW_STATUS_SUCCESS = 0;
    public static final int SHOW_STATUS_FAIL_PRIORITY = 12;
    public static final int SHOW_STATUS_FAIL_REPEAT = 11;
    public static final int SHOW_STATUS_FAIL_NOTI_CLOSE = 6;

    private PushManager() {
    }

    public static PushManager getInstance() {
        return Holder.INSTANCE;
    }

    public void init(final Context context, final String appId, final String appKey, final boolean isTest) {
        if (!this.checkVersion()) {
            return;
        }
        try {
            CoreUtil.init((Context)context.getApplicationContext());
            if (sInit.get()) {
                return;
            }
            String[] domains = new String[]{"https://api.twibida.com/tcm/v2/instance/"};
            GslbSdk.init((Context)context, (String[])domains, (GslbSdk.InitListener)new GslbSdk.InitListener(){

                public void onInitSuccess(Map<String, String> domainMap) {
                    PushLogUtils.LOG.d((Object)"gslb sdk init success");
                    Bundle bundle = new Bundle();
                    bundle.putString("service_type", "force_update");
                    ServiceUtils.startJobThread(context.getApplicationContext(), bundle);
                    PushLogUtils.LOG.d((Object)"gslb success, force update info to server");
                }

                public void onInitFail() {
                    PushLogUtils.LOG.d((Object)"gslb sdk init fail");
                }
            });
            sInit.set(true);
            long startTime = System.currentTimeMillis();
            TCrypterSdk.init((Context)context.getApplicationContext());
            ThreadManager.executeInBackground(new Runnable(){

                @Override
                public void run() {
                    Tracker.getInstance().init();
                    PushRepository.getInstance().putSpValue("push_app_id", appId);
                    PushRepository.getInstance().putSpValue("push_app_key", appKey);
                    PushRepository.getInstance().putSpValue("push_is_test_env", isTest);
                    CoreUtil.setDebug((boolean)PushUtils.isDebug());
                    Tracker.getInstance().trackInit();
                    PushLogUtils.LOG.e((Object)"start update token: ");
                    FirebaseUtils.updateToken();
                }
            });
            this.registerReceiver();
            sSdkInitFinished = true;
            PushLogUtils.LOG.e((Object)("sdk init time: " + (System.currentTimeMillis() - startTime)));
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("init fail, e:" + e.getMessage()));
            sSdkInitFinished = false;
        }
    }

    public void init(final Context context) {
        if (!this.checkVersion()) {
            return;
        }
        try {
            long startTime = System.currentTimeMillis();
            CoreUtil.init((Context)context.getApplicationContext());
            if (sInit.get()) {
                return;
            }
            String[] domains = new String[]{"https://api.twibida.com/tcm/v2/instance/"};
            GslbSdk.init((Context)context, (String[])domains, (GslbSdk.InitListener)new GslbSdk.InitListener(){

                public void onInitSuccess(Map<String, String> domainMap) {
                    PushLogUtils.LOG.d((Object)"gslb sdk init success");
                    Bundle bundle = new Bundle();
                    bundle.putString("service_type", "force_update");
                    ServiceUtils.startJobThread(context.getApplicationContext(), bundle);
                    PushLogUtils.LOG.d((Object)"gslb success, force update info to server");
                }

                public void onInitFail() {
                    PushLogUtils.LOG.d((Object)"gslb sdk init fail");
                }
            });
            sInit.set(true);
            TCrypterSdk.init((Context)context.getApplicationContext());
            ThreadManager.executeInBackground(new Runnable(){

                @Override
                public void run() {
                    Tracker.getInstance().init();
                    PushUtils.initMetaData();
                    CoreUtil.setDebug((boolean)PushUtils.isDebug());
                    Tracker.getInstance().trackInit();
                    PushLogUtils.LOG.d((Object)"start update token 2: ");
                    FirebaseUtils.updateToken();
                }
            });
            this.registerReceiver();
            sSdkInitFinished = true;
            PushLogUtils.LOG.e((Object)("sdk init time: " + (System.currentTimeMillis() - startTime)));
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("init fail, e:" + e.getMessage()));
            sSdkInitFinished = false;
        }
    }

    public boolean getIsSdkInitFinished() {
        return sSdkInitFinished;
    }

    public void updateToken(String token) {
        if (!this.checkVersion()) {
            return;
        }
        PushUtils.updateToken(token);
    }

    public void trackShow(long msgId, int showStatus) {
        if (!this.checkVersion()) {
            return;
        }
        try {
            Tracker.getInstance().trackShow(msgId, 2, String.valueOf(System.currentTimeMillis()), NotificationAssistUtils.isOpenNotification(CoreUtil.getContext()), showStatus);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void trackClick(long msgId) {
        if (!this.checkVersion()) {
            return;
        }
        Tracker.getInstance().trackClick(msgId);
    }

    public void trackConversion(long msgId) {
        if (!this.checkVersion()) {
            return;
        }
        try {
            Tracker.getInstance().trackConversion(msgId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void trackArrive(long msgId) {
        if (!this.checkVersion()) {
            return;
        }
        try {
            Tracker.getInstance().trackTarget(msgId, 2, "", "", "success");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addCustomNotification(PushNotification notification) {
        if (!this.checkVersion()) {
            return;
        }
        CustomNotificationUtils.addCustomNotification(notification);
    }

    public void setPushConfig(final PushConfig config) {
        if (!this.checkVersion()) {
            return;
        }
        ThreadManager.executeInBackground(new Runnable(){

            @Override
            public void run() {
                PushUtils.savePushConfig(config);
            }
        });
    }

    public void setNotificationSwitch(boolean isOpen) {
        if (!this.checkVersion()) {
            return;
        }
        try {
            SharedPreferencesUtil.getInstance((String)"sp_push").putBoolean("sp_key_push_switch", isOpen);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean getNotificationSwitch() {
        if (!this.checkVersion()) {
            return false;
        }
        try {
            return SharedPreferencesUtil.getInstance((String)"sp_push").getBoolean("sp_key_push_switch", true);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setAppInfo(String appId, String appkey) {
        if (!this.checkVersion()) {
            return;
        }
        String oldAppid = PushUtils.getAppId();
        String oldAppkey = PushUtils.getAppKey();
        try {
            if (oldAppid.equalsIgnoreCase(appId) && oldAppkey.equalsIgnoreCase(appkey)) {
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)appId)) {
                PushRepository.getInstance().putSpValue("push_app_id", appId);
            }
            if (!TextUtils.isEmpty((CharSequence)appkey)) {
                PushRepository.getInstance().putSpValue("push_app_key", appkey);
            }
            ThreadManager.executeInBackground(new Runnable(){

                @Override
                public void run() {
                    PushRepository.getInstance().syncActive();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void registerPushListener(TPushListener listener) {
        this.mListener = listener;
    }

    public TPushListener getPushListener() {
        return this.mListener;
    }

    @Deprecated
    public void registerReceiver(Context context, BroadcastReceiver broadcastReceiver) {
        if (!this.checkVersion()) {
            return;
        }
        try {
            PushLogUtils.LOG.d((Object)"registerReceiver --> ");
            IntentFilter filter = new IntentFilter();
            filter.addAction("tpush.intent.action.TPUSH_RECEIVER");
            filter.addAction("tpush.intent.action.INIT_COMPLETE");
            context.getApplicationContext().registerReceiver(broadcastReceiver, filter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unregisterReceiver(Context context, BroadcastReceiver broadcastReceiver) {
        if (!this.checkVersion()) {
            return;
        }
        try {
            context.getApplicationContext().unregisterReceiver(broadcastReceiver);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void subscribeToTopic(String topic, ITopicListener listener) {
        if (!this.checkVersion()) {
            return;
        }
        PushRepository.getInstance().subscribeToTopic(topic, listener);
    }

    public void unsubscribeFromTopic(String topic, ITopicListener listener) {
        if (!this.checkVersion()) {
            return;
        }
        PushRepository.getInstance().unsubscribeFromTopic(topic, listener);
    }

    public boolean getDebug() {
        if (!this.checkVersion()) {
            return false;
        }
        return PushUtils.isDebug();
    }

    public boolean getTestEnv() {
        if (!this.checkVersion()) {
            return false;
        }
        return PushUtils.isTestEnv();
    }

    public String getToken(Context context) {
        if (!this.checkVersion()) {
            return null;
        }
        return PushRepository.getInstance().getSpValue("push_token", "");
    }

    public void getClientId(IClientIdListener listener) {
        if (!this.checkVersion()) {
            return;
        }
        PushRepository.getInstance().getClientId(listener);
    }

    private void registerReceiver() {
        if (!this.checkVersion()) {
            return;
        }
        IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        if (this.mPushBroadcastReceiver == null) {
            this.mPushBroadcastReceiver = new PushBroadcastReceiver();
        }
        try {
            CoreUtil.getContext().registerReceiver((BroadcastReceiver)this.mPushBroadcastReceiver, filter);
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("registerReceiver fail, e:" + e.getMessage()));
        }
    }

    private boolean checkVersion() {
        return Build.VERSION.SDK_INT >= 19;
    }

    private static final class Holder {
        private static final PushManager INSTANCE = new PushManager();

        private Holder() {
        }
    }
}

