/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.config;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Base64;
import com.transsion.core.CoreUtil;
import com.transsion.core.log.ObjectLogUtils;
import com.transsion.crypto.TCrypterSdk;
import com.transsion.json.Tson;
import com.transsion.push.bean.ConfigInfo;
import com.transsion.push.bean.SelfDestroyInfo;
import com.transsion.push.config.IDataSource;
import com.transsion.push.config.a;
import com.transsion.push.config.b;
import com.transsion.push.config.c;
import com.transsion.push.config.f;
import com.transsion.push.tracker.Tracker;
import com.transsion.push.utils.PushLogUtils;
import com.transsion.push.utils.m;
import com.transsion.push.utils.o;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class PushRepository
implements IDataSource {
    private static PushRepository a;
    private SharedPreferences b = CoreUtil.getContext().getSharedPreferences("sp_push", 0);
    private f c = new f();
    private ConfigInfo.Config d;
    private ConfigInfo.Whitelist e;

    private PushRepository() {
    }

    public static synchronized PushRepository getInstance() {
        if (a == null) {
            a = new PushRepository();
        }
        return a;
    }

    private void a() {
        int n2 = this.getSpValue("retry_count", 0);
        int n3 = m.d();
        PushLogUtils.LOG.d((Object)("Reporting Failure, Retry Reporting,retryCount\uff1a" + n2 + ", max retryCount\uff1a" + n3));
        if (n2 >= n3) {
            PushRepository pushRepository = this;
            PushLogUtils.LOG.d((Object)"More than the maximum number of retries");
            pushRepository.saveReportTime(System.currentTimeMillis() + m.c());
            pushRepository.putSpValue("retry_count", 0);
            Tracker.getInstance().trackReport();
            return;
        }
        PushRepository pushRepository = this;
        pushRepository.putSpValue("retry_count", n2 + 1);
        pushRepository.saveReportTime(System.currentTimeMillis() + m.e());
    }

    static /* synthetic */ void a(PushRepository pushRepository) {
        pushRepository.a();
    }

    @Override
    public long getReportTime() {
        long l2 = System.currentTimeMillis() - 1L;
        long l3 = this.b.getLong("report_active_time", 0L);
        if (l3 <= 0L) {
            this.b.edit().putLong("report_active_time", l2).apply();
            l3 = l2;
        }
        return l3;
    }

    @Override
    public void saveReportTime(long l2) {
        PushLogUtils.LOG.d((Object)("Update reporting time\uff0creportTime:" + l2));
        this.b.edit().putLong("report_active_time", l2).apply();
    }

    @Override
    public ConfigInfo.Config getConfig() {
        StringBuilder stringBuilder;
        ObjectLogUtils objectLogUtils;
        Object object;
        ConfigInfo.Config config = ((PushRepository)object2).d;
        if (config != null) {
            return config;
        }
        Object object2 = ((PushRepository)object2).b.getString("push_config", null);
        if (TextUtils.isEmpty((CharSequence)object2)) {
            return null;
        }
        try {
            object = object2 = (ConfigInfo.Config)Tson.fromJson((String)new String(Base64.decode((String)object2, (int)0)), ConfigInfo.Config.class);
            objectLogUtils = PushLogUtils.LOG;
            stringBuilder = new StringBuilder();
        }
        catch (Exception exception) {
            PushLogUtils.LOG.e((Object)("get config fail, e:" + exception.getMessage()));
            return null;
        }
        objectLogUtils.d((Object)stringBuilder.append("getConfig ").append(object2).toString());
        return object;
    }

    @Override
    public void saveConfig(ConfigInfo.Config config) {
        String string;
        if (config == null) {
            return;
        }
        this.d = config;
        SharedPreferences.Editor editor = this.b.edit();
        String string2 = string;
        String string3 = string;
        byte[] byArray = Tson.toJson((Object)config).getBytes();
        try {
            string2(Base64.encode((byte[])byArray, (int)0));
            editor.putString("push_config", string3).apply();
        }
        catch (Exception exception) {
            PushLogUtils.LOG.e((Object)("save config fail, e:" + exception.getMessage()));
        }
    }

    @Override
    public ConfigInfo.Whitelist getWhiteList() {
        ConfigInfo.Whitelist whitelist = this.e;
        if (whitelist != null) {
            return whitelist;
        }
        try {
            this.e = (ConfigInfo.Whitelist)Tson.fromJson((String)TCrypterSdk.getSafeString((Context)CoreUtil.getContext(), (String)"push_white_list"), ConfigInfo.Whitelist.class);
            return this.e;
        }
        catch (Exception exception) {
            PushLogUtils.LOG.e((Object)("get white list fail, e:" + exception.getMessage()));
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void saveWhiteList(ConfigInfo.Whitelist whitelist) {
        if (whitelist == null) return;
        List<ConfigInfo.Apps> list = whitelist.apps;
        if (list == null) return;
        if (list.size() == 0) {
            return;
        }
        try {
            if (((PushRepository)((Object)whitelist3)).e != null && ((PushRepository)((Object)whitelist3)).e.apps != null && ((PushRepository)((Object)whitelist3)).e.apps.size() != 0) {
                list = ((PushRepository)((Object)whitelist3)).e.apps;
                Iterator<ConfigInfo.Apps> iterator = whitelist.apps.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        ConfigInfo.Whitelist whitelist2;
                        PushRepository pushRepository = whitelist3;
                        ConfigInfo.Whitelist whitelist3 = whitelist2;
                        whitelist3();
                        whitelist2.version = whitelist.version;
                        whitelist2.apps = new ArrayList<ConfigInfo.Apps>(list);
                        pushRepository.e = whitelist2;
                        TCrypterSdk.saveSafeString((Context)CoreUtil.getContext(), (String)"push_white_list", (String)Tson.toJson((Object)whitelist3));
                        return;
                    }
                    ConfigInfo.Apps apps = iterator.next();
                    if (list.contains(apps)) continue;
                    list.add(apps);
                }
            }
            ((PushRepository)((Object)whitelist3)).e = whitelist;
            TCrypterSdk.saveSafeString((Context)CoreUtil.getContext(), (String)"push_white_list", (String)Tson.toJson((Object)whitelist));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T getSpValue(String string, T t) {
        try {
            if (t instanceof String) {
                return (T)this.b.getString(string, (String)t);
            }
            if (t instanceof Boolean) {
                return (T)Boolean.valueOf(this.b.getBoolean(string, ((Boolean)t).booleanValue()));
            }
            if (t instanceof Integer) {
                return (T)Integer.valueOf(this.b.getInt(string, ((Integer)t).intValue()));
            }
            if (t instanceof Long) {
                return (T)Long.valueOf(this.b.getLong(string, ((Long)t).longValue()));
            }
            if (t instanceof Float) {
                return (T)Float.valueOf(this.b.getFloat(string, ((Float)t).floatValue()));
            }
            PushLogUtils.LOG.e((Object)("Type of " + t.getClass().getSimpleName() + " is not supported."));
            return t;
        }
        catch (ClassCastException classCastException) {
            PushLogUtils.LOG.e((Object)("Type of default value is not match with value stored." + System.lineSeparator() + classCastException.getMessage()));
            return t;
        }
    }

    @Override
    public void putSpValue(String string, Object object) {
        if (object instanceof String) {
            this.b.edit().putString(string, (String)object).apply();
        } else if (object instanceof Boolean) {
            this.b.edit().putBoolean(string, ((Boolean)object).booleanValue()).apply();
        } else if (object instanceof Integer) {
            this.b.edit().putInt(string, ((Integer)object).intValue()).apply();
        } else if (object instanceof Long) {
            this.b.edit().putLong(string, ((Long)object).longValue()).apply();
        } else if (object instanceof Float) {
            this.b.edit().putFloat(string, ((Float)object).floatValue()).apply();
        } else {
            PushLogUtils.LOG.e((Object)("Value: " + object + " is not supported."));
        }
    }

    @Override
    public void updateNewToken(String string) {
        PushRepository pushRepository = this;
        pushRepository.putSpValue("push_token", string);
        pushRepository.putSpValue("push_is_report_detail", true);
        o.b(CoreUtil.getContext(), string);
        pushRepository.syncActive();
    }

    @Override
    public void syncActive() {
        this.syncActive(null);
    }

    @Override
    public void syncActive(a<ConfigInfo> a2) {
        if (TextUtils.isEmpty((CharSequence)this.getSpValue("push_token", ""))) {
            PushLogUtils.LOG.w((Object)"Token is empty");
            return;
        }
        if (m.g()) {
            PushLogUtils.LOG.w((Object)"push self-destroying");
            return;
        }
        this.c.b(new b(this, a2));
    }

    @Override
    public void syncSelfDestroying(a<SelfDestroyInfo> a2) {
        this.c.a(new c(this, a2));
    }
}

