/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.broadcast;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.transsion.core.CoreUtil;
import com.transsion.json.Tson;
import com.transsion.push.PushManager;
import com.transsion.push.bean.PushMessage;
import com.transsion.push.tracker.Tracker;
import com.transsion.push.utils.PushLogUtils;
import com.transsion.push.utils.ServiceUtils;
import com.transsion.push.utils.StringUtils;

public class FCMMessageReceiver
extends BroadcastReceiver {
    private static final String GCM_RECEIVE_ACTION = "com.google.android.c2dm.intent.RECEIVE";
    private static final String GCM_REGISTRATION_ACTION = "com.google.android.c2dm.intent.REGISTRATION";

    public void onReceive(Context context, Intent intent) {
        CoreUtil.init((Context)context.getApplicationContext());
        this.onMessageReceived(context, intent);
    }

    private void onMessageReceived(Context context, Intent intent) {
        PushManager.getInstance().init(context.getApplicationContext());
        Tracker.getInstance().trackBroadcastInfoeye();
        if (intent == null || intent.getExtras() == null) {
            return;
        }
        if (!FCMMessageReceiver.isGcmMessage(intent)) {
            return;
        }
        Tracker.getInstance().trackBroadcastGcmInfoeye();
        PushMessage message = this.dataToMessage(intent.getExtras());
        PushLogUtils.LOG.d((Object)("Receiving FCM messages packageName:" + context.getPackageName() + "  " + message));
        if (!this.checkPushMessage(message)) {
            if (this.isOrderedBroadcast()) {
                this.setResultCode(-1);
            }
            return;
        }
        if (this.isOrderedBroadcast()) {
            this.abortBroadcast();
            this.setResultCode(-1);
        }
        Tracker.getInstance().trackMessage(message.messageId, message.type, message.timeStamp, "all", 0);
        String messageContent = null;
        try {
            messageContent = Tson.toJson((Object)message);
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("Receiving FCM messages to messageContent fail, e:" + e.getMessage()));
        }
        if (TextUtils.isEmpty((CharSequence)messageContent)) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("message", messageContent);
        bundle.putString("service_type", "message");
        ServiceUtils.startTargetIntentService(context.getApplicationContext(), bundle);
    }

    private PushMessage dataToMessage(Bundle bundle) {
        PushMessage pushMessage = new PushMessage();
        pushMessage.messageId = StringUtils.stringToLong(bundle.getString("tcm_msg_id"));
        pushMessage.type = StringUtils.stringToInt(bundle.getString("tcm_msg_type"));
        pushMessage.pkgId = bundle.getString("tcm_msg_pkg");
        pushMessage.packageName = bundle.getString("tcm_msg_pkgname");
        try {
            pushMessage.rpkg = CoreUtil.getContext().getPackageName();
        }
        catch (Exception e) {
            pushMessage.rpkg = "";
        }
        pushMessage.notiType = StringUtils.stringToInt(bundle.getString("noti_type"));
        pushMessage.notiExType = StringUtils.getNotiExType(bundle.getString("noti_ex_type"));
        pushMessage.msgTtl = StringUtils.stringToInt(bundle.getString("tcm_msg_ttl"));
        pushMessage.ignoreExpire = StringUtils.stringToInt(bundle.getString("noti_ignore_expire"));
        pushMessage.groupId = bundle.getString("noti_group_id");
        pushMessage.groupMaxCount = bundle.getString("noti_group_max_count");
        pushMessage.notiTitle = bundle.getString("noti_title");
        pushMessage.notiDes = bundle.getString("noti_desc");
        pushMessage.notiImg = bundle.getString("noti_img");
        pushMessage.notiIcon = bundle.getString("noti_icon");
        pushMessage.notiBtn = bundle.getString("noti_btn");
        pushMessage.notiImgEx = bundle.getString("noti_img_ex");
        pushMessage.notiTitleEx = bundle.getString("noti_title_ex");
        pushMessage.notiTxtEx = bundle.getString("noti_txt_ex");
        pushMessage.notiOpenType = StringUtils.stringToInt(bundle.getString("noti_open_type"));
        pushMessage.notiOpenContent = bundle.getString("noti_open_content");
        pushMessage.transData = StringUtils.getBase64Data(bundle.getString("trans_data"));
        pushMessage.timeStamp = bundle.getString("tcm_msg_timestamp");
        pushMessage.notiSmallIcon = bundle.getString("noti_small_icon");
        pushMessage.displayPolicy = StringUtils.stringToInt(bundle.getString("display_policy"));
        pushMessage.appName = bundle.getString("app_name");
        pushMessage.layoutStyleId = StringUtils.stringToInt(bundle.getString("noti_layout_id"));
        pushMessage.channelId = bundle.getString("noti_channel_id");
        pushMessage.channelName = bundle.getString("noti_channel_name");
        pushMessage.iconColor = bundle.getString("noti_small_icon_color");
        pushMessage.impUrlList = bundle.getString("noti_imp_urls");
        pushMessage.clickUrlList = bundle.getString("noti_click_urls");
        pushMessage.isHeadsUp = StringUtils.stringToInt(bundle.getString("noti_is_headsup"));
        pushMessage.retraceMsgId = StringUtils.stringToLong(bundle.getString("tcm_target_msg_id"));
        pushMessage.notiExtensionBtn = bundle.getString("noti_btn_ex");
        pushMessage.notiBtnBgColor = bundle.getString("noti_btn_background_color");
        pushMessage.notiBtnTxtColor = bundle.getString("noti_btn_word_color");
        pushMessage.notiOptionalIcon = bundle.getString("noti_optional_icon");
        pushMessage.priority = StringUtils.stringToInt(bundle.getString("tcm_msg_priority"));
        pushMessage.sdkShow = StringUtils.stringToInt(bundle.getString("tcm_msg_sdkshow"));
        pushMessage.floatNotice = bundle.getString("noti_float");
        pushMessage.materialId = bundle.getString("tcm_material_id");
        pushMessage.seq = bundle.getString("tcm_seq");
        pushMessage.sourceType = bundle.getString("tcm_source_type");
        pushMessage.scheduleDate = bundle.getString("tcm_schedule_date");
        pushMessage.tag = bundle.getString("tcm_tag");
        return pushMessage;
    }

    private boolean checkPushMessage(PushMessage message) {
        return message.messageId > 0L && message.type > 0 && !TextUtils.isEmpty((CharSequence)message.pkgId);
    }

    private static boolean isGcmMessage(Intent intent) {
        return GCM_RECEIVE_ACTION.equals(intent.getAction()) || GCM_REGISTRATION_ACTION.equals(intent.getAction());
    }
}

