/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.broadcast;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.transsion.push.utils.PushLogUtils;

public abstract class IPushBroadcastReceiver
extends BroadcastReceiver {
    private static boolean sInit;

    public void onReceive(Context context, Intent intent) {
        try {
            PushLogUtils.LOG.d((Object)(context.getPackageName() + " push receiver action:" + intent.getAction()));
            if ("tpush.intent.action.TPUSH_RECEIVER".equals(intent.getAction())) {
                long msgId = intent.getLongExtra("message_id", -1L);
                String transData = intent.getStringExtra("trans_data");
                if (msgId < 0L || TextUtils.isEmpty((CharSequence)transData)) {
                    PushLogUtils.LOG.w((Object)"msgId is -1 or transData is null");
                    return;
                }
                this.onMessageReceive(context, msgId, transData);
            } else if ("tpush.intent.action.INIT_COMPLETE".equals(intent.getAction()) && !sInit) {
                sInit = true;
                PushLogUtils.LOG.d((Object)(context.getPackageName() + " init complete"));
                String clientId = intent.getStringExtra("extra_key_clientid");
                String token = intent.getStringExtra("extra_key_token");
                this.onSdkInitSuccess(context, clientId, token);
            }
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("onReceive fail, e:" + e.getMessage()));
        }
    }

    public abstract void onMessageReceive(Context var1, long var2, String var4);

    public abstract void onSdkInitSuccess(Context var1, String var2, String var3);
}

