/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.config;

import android.content.Context;
import android.text.TextUtils;
import android.util.Base64;
import com.transsion.core.CoreUtil;
import com.transsion.core.utils.SharedPreferencesUtil;
import com.transsion.crypto.TCrypterSdk;
import com.transsion.gslb.GslbSdk;
import com.transsion.json.Tson;
import com.transsion.push.IClientIdListener;
import com.transsion.push.ITopicListener;
import com.transsion.push.PushManager;
import com.transsion.push.bean.ConfigInfo;
import com.transsion.push.bean.SelfDestroyInfo;
import com.transsion.push.config.IDataSource;
import com.transsion.push.config.RemoteDataSource;
import com.transsion.push.tracker.Tracker;
import com.transsion.push.utils.FirebaseUtils;
import com.transsion.push.utils.PushConfigUtils;
import com.transsion.push.utils.PushIml;
import com.transsion.push.utils.PushLogUtils;
import com.transsion.push.utils.PushUtils;
import com.transsion.push.utils.ThreadManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class PushRepository
implements IDataSource {
    private static PushRepository INSTANCE;
    private static long sLocalReportTime;
    private static long sLocalTpmsReportTime;
    private SharedPreferencesUtil mSharedPreferences;
    private RemoteDataSource mRemoteDataSource;
    private ConfigInfo.Config mConfig;
    private String mWhiteStr;

    private PushRepository() {
        try {
            this.mSharedPreferences = SharedPreferencesUtil.getInstance((String)"sp_push");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mRemoteDataSource = new RemoteDataSource();
    }

    public static synchronized PushRepository getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PushRepository();
        }
        return INSTANCE;
    }

    @Override
    public long getReportTime() {
        long currentTime = System.currentTimeMillis() - 1L;
        if (sLocalReportTime > 0L) {
            return sLocalReportTime;
        }
        if (this.mSharedPreferences == null) {
            return currentTime;
        }
        sLocalReportTime = this.mSharedPreferences.getLong("report_active_time", 0L);
        if (sLocalReportTime <= 0L) {
            this.mSharedPreferences.putLong("report_active_time", currentTime);
            sLocalReportTime = currentTime;
        }
        return sLocalReportTime;
    }

    public long getLastTpmsReportTime() {
        long currentTime = System.currentTimeMillis() - 1L;
        if (sLocalTpmsReportTime > 0L) {
            return sLocalTpmsReportTime;
        }
        if (this.mSharedPreferences == null) {
            return currentTime;
        }
        sLocalTpmsReportTime = this.mSharedPreferences.getLong("report_tpms_active_time", 0L);
        PushLogUtils.LOG.d((Object)("sLocalTpmsReportTime" + sLocalTpmsReportTime));
        if (sLocalTpmsReportTime <= 0L) {
            this.mSharedPreferences.putLong("report_tpms_active_time", currentTime);
            sLocalTpmsReportTime = currentTime;
        }
        return sLocalTpmsReportTime;
    }

    public void saveTpmsReportTime(long reportTime) {
        if (this.mSharedPreferences == null) {
            return;
        }
        PushLogUtils.LOG.d((Object)("Update reporting time\uff0creportTime:" + reportTime));
        sLocalTpmsReportTime = reportTime;
        this.mSharedPreferences.putLong("report_tpms_active_time", reportTime);
    }

    @Override
    public boolean isReported() {
        if (this.mSharedPreferences == null) {
            return false;
        }
        try {
            return this.mSharedPreferences.getBoolean("report_active_success");
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void saveReportTime(long reportTime) {
        if (this.mSharedPreferences == null) {
            return;
        }
        PushLogUtils.LOG.d((Object)("Update reporting time\uff0creportTime:" + reportTime));
        sLocalReportTime = reportTime;
        this.mSharedPreferences.putLong("report_active_time", reportTime);
    }

    @Override
    public ConfigInfo.Config getConfig() {
        if (this.mConfig != null) {
            return this.mConfig;
        }
        if (this.mSharedPreferences == null) {
            return null;
        }
        String localConfig = this.mSharedPreferences.getString("push_config", null);
        if (TextUtils.isEmpty((CharSequence)localConfig)) {
            return null;
        }
        try {
            ConfigInfo.Config config = (ConfigInfo.Config)Tson.fromJson((String)new String(Base64.decode((String)localConfig, (int)0)), ConfigInfo.Config.class);
            return config;
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("get config fail, e:" + e.getMessage()));
            return null;
        }
    }

    @Override
    public void saveConfig(ConfigInfo.Config config) {
        if (config == null || this.mSharedPreferences == null) {
            return;
        }
        try {
            this.mConfig = config;
            this.mSharedPreferences.putString("push_config", new String(Base64.encode((byte[])Tson.toJson((Object)config).getBytes(), (int)0)));
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("save config fail, e:" + e.getMessage()));
        }
    }

    @Override
    public ConfigInfo.Whitelist getWhiteList() {
        if (!TextUtils.isEmpty((CharSequence)this.mWhiteStr)) {
            try {
                return (ConfigInfo.Whitelist)Tson.fromJson((String)this.mWhiteStr, ConfigInfo.Whitelist.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            String whiteString = TCrypterSdk.getSafeString((Context)CoreUtil.getContext(), (String)"push_white_list");
            if (TextUtils.isEmpty((CharSequence)whiteString)) {
                return null;
            }
            this.mWhiteStr = whiteString;
            return (ConfigInfo.Whitelist)Tson.fromJson((String)whiteString, ConfigInfo.Whitelist.class);
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("get white list fail, e:" + e.getMessage()));
            return null;
        }
    }

    @Override
    public void saveWhiteList(ConfigInfo.Whitelist whiteList) {
        if (whiteList == null || whiteList.apps == null || whiteList.apps.size() == 0) {
            return;
        }
        try {
            if (TextUtils.isEmpty((CharSequence)this.mWhiteStr)) {
                this.mWhiteStr = Tson.toJson((Object)whiteList);
                TCrypterSdk.saveSafeString((Context)CoreUtil.getContext(), (String)"push_white_list", (String)this.mWhiteStr);
                return;
            }
            List<ConfigInfo.Apps> tempList = ((ConfigInfo.Whitelist)Tson.fromJson((String)this.mWhiteStr, ConfigInfo.Whitelist.class)).apps;
            for (ConfigInfo.Apps newAppId : whiteList.apps) {
                if (tempList.contains(newAppId)) continue;
                tempList.add(newAppId);
            }
            ConfigInfo.Whitelist newWhiteList = new ConfigInfo.Whitelist();
            newWhiteList.version = whiteList.version;
            newWhiteList.apps = new ArrayList<ConfigInfo.Apps>(tempList);
            this.mWhiteStr = Tson.toJson((Object)newWhiteList);
            TCrypterSdk.saveSafeString((Context)CoreUtil.getContext(), (String)"push_white_list", (String)this.mWhiteStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public <T> T getSpValue(String key, T defValue) {
        if (this.mSharedPreferences == null) {
            return defValue;
        }
        try {
            if (defValue instanceof String) {
                return (T)this.mSharedPreferences.getString(key, (String)defValue);
            }
            if (defValue instanceof Boolean) {
                return (T)Boolean.valueOf(this.mSharedPreferences.getBoolean(key, ((Boolean)defValue).booleanValue()));
            }
            if (defValue instanceof Integer) {
                return (T)Integer.valueOf(this.mSharedPreferences.getInt(key, ((Integer)defValue).intValue()));
            }
            if (defValue instanceof Long) {
                return (T)Long.valueOf(this.mSharedPreferences.getLong(key, ((Long)defValue).longValue()));
            }
            if (defValue instanceof Float) {
                return (T)Float.valueOf(this.mSharedPreferences.getFloat(key, ((Float)defValue).floatValue()));
            }
            if (defValue instanceof Set) {
                return (T)this.mSharedPreferences.getStringSet(key, new HashSet());
            }
            PushLogUtils.LOG.e((Object)("Type of " + defValue.getClass().getSimpleName() + " is not supported."));
            return defValue;
        }
        catch (ClassCastException e) {
            PushLogUtils.LOG.e((Object)("Type of default value is not match with value stored." + System.lineSeparator() + e.getMessage()));
            return defValue;
        }
    }

    @Override
    public void removeSpValue(String key) {
        try {
            if (this.mSharedPreferences != null) {
                this.mSharedPreferences.remove(key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void putSpValue(String key, Object value) {
        if (this.mSharedPreferences == null) {
            return;
        }
        try {
            if (value instanceof String) {
                this.mSharedPreferences.putString(key, (String)value);
            } else if (value instanceof Boolean) {
                this.mSharedPreferences.putBoolean(key, ((Boolean)value).booleanValue());
            } else if (value instanceof Integer) {
                this.mSharedPreferences.putInt(key, ((Integer)value).intValue());
            } else if (value instanceof Long) {
                this.mSharedPreferences.putLong(key, ((Long)value).longValue());
            } else if (value instanceof Float) {
                this.mSharedPreferences.putFloat(key, ((Float)value).floatValue());
            } else if (value instanceof Set) {
                this.mSharedPreferences.putStringSet(key, (Set)value);
            }
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("put sp, Type of default value is not match with value stored." + System.lineSeparator() + e.getMessage()));
        }
    }

    @Override
    public void updateNewToken(String token) {
        this.putSpValue("push_token", token);
        this.putSpValue("push_is_report_detail", true);
        this.putSpValue("report_active_success", false);
    }

    @Override
    public void subscribeToTopic(final String topic, final ITopicListener listener) {
        if (TextUtils.isEmpty((CharSequence)topic)) {
            if (listener != null) {
                listener.onFail("subscribe topic is empty");
                PushLogUtils.LOG.e((Object)"subscribe topic is empty");
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)PushRepository.getInstance().getSpValue("push_client_id", ""))) {
            if (listener != null) {
                listener.onFail("subscribe clientId is empty");
                PushLogUtils.LOG.e((Object)"subscribe clientId is empty");
            }
            return;
        }
        ThreadManager.executeInBackground(new Runnable(){

            @Override
            public void run() {
                final HashSet set = PushRepository.this.getSpValue("topics", new HashSet());
                if (set.contains(topic)) {
                    PushLogUtils.LOG.d((Object)("subscribe topic, " + topic + " has been subscribed"));
                    if (listener != null) {
                        listener.onSuccess();
                    }
                    return;
                }
                PushRepository.this.mRemoteDataSource.updateTopic(topic, "subscribe", new ITopicListener(){

                    @Override
                    public void onFail(String msg) {
                        if (listener != null) {
                            listener.onFail(msg);
                        }
                    }

                    @Override
                    public void onSuccess() {
                        set.add(topic);
                        PushRepository.getInstance().putSpValue("topics", set);
                        if (listener != null) {
                            listener.onSuccess();
                        }
                    }
                });
            }
        });
    }

    @Override
    public void unsubscribeFromTopic(final String topic, final ITopicListener listener) {
        if (TextUtils.isEmpty((CharSequence)topic)) {
            if (listener != null) {
                listener.onFail("unsubscribe topic is empty");
                PushLogUtils.LOG.e((Object)"unsubscribe topic is empty");
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)PushRepository.getInstance().getSpValue("push_client_id", ""))) {
            if (listener != null) {
                listener.onFail("unsubscribe clientId is empty");
                PushLogUtils.LOG.e((Object)"unsubscribe clientId is empty");
            }
            return;
        }
        ThreadManager.executeInBackground(new Runnable(){

            @Override
            public void run() {
                PushRepository.this.mRemoteDataSource.updateTopic(topic, "unsubscribe", new ITopicListener(){

                    @Override
                    public void onFail(String msg) {
                        if (listener != null) {
                            listener.onFail(msg);
                        }
                    }

                    @Override
                    public void onSuccess() {
                        HashSet set = PushRepository.this.getSpValue("topics", new HashSet());
                        set.remove(topic);
                        PushRepository.this.putSpValue("topics", set);
                        if (listener != null) {
                            listener.onSuccess();
                        }
                    }
                });
            }
        });
    }

    @Override
    public void syncActive() {
        ConfigInfo configInfo;
        if (TextUtils.isEmpty((CharSequence)this.getSpValue("push_token", ""))) {
            PushLogUtils.LOG.w((Object)"Token is empty");
            return;
        }
        if (this.mRemoteDataSource == null) {
            PushLogUtils.LOG.w((Object)"mRemoteDataSource is null");
            return;
        }
        if (!(PushManager.getInstance().getDebug() || PushManager.getInstance().getTestEnv() || GslbSdk.isInitSuccess((String)"https://api.twibida.com/tcm/v2/instance/"))) {
            GslbSdk.getDomain((String)"https://api.twibida.com/tcm/v2/instance/", (boolean)true);
        }
        if ((configInfo = this.mRemoteDataSource.syncActive()) == null) {
            PushLogUtils.LOG.d((Object)"syncActive onFail");
            if (!TextUtils.isEmpty((CharSequence)this.getSpValue("push_client_id", ""))) {
                this.retrySyncActive();
            }
            return;
        }
        this.putSpValue("retry_count", 0);
        PushLogUtils.LOG.d((Object)("get config response data: " + configInfo.toString()));
        this.putSpValue("push_is_next_with_app", configInfo.nextWithApp);
        this.putSpValue("push_is_report_detail", configInfo.nextWithDetail);
        this.putSpValue("push_client_id", configInfo.clientId);
        this.putSpValue("push_start_point_report", configInfo.startPointReport);
        PushIml.saveDestroyConfig(configInfo.destroyAppIds, configInfo.syncInfoInterval);
        PushUtils.sendCompleteBroadcast();
        if (configInfo.configRefresh && configInfo.config != null && configInfo.config.version > 0) {
            this.saveConfig(configInfo.config);
            this.putSpValue("push_self_destroying", configInfo.config.destroy);
        }
        if (configInfo.whitelistRefresh && configInfo.whitelist != null && configInfo.whitelist.version > 0) {
            this.saveWhiteList(configInfo.whitelist);
        }
        this.saveReportTime(System.currentTimeMillis() + PushConfigUtils.getReportActiveInterval());
        this.putSpValue("report_active_success", true);
    }

    @Override
    public void syncSelfDestroying() {
        if (this.mRemoteDataSource == null) {
            PushLogUtils.LOG.w((Object)"mRemoteDataSource is null");
            return;
        }
        if (!(PushManager.getInstance().getDebug() || PushManager.getInstance().getTestEnv() || GslbSdk.isInitSuccess((String)"https://api.twibida.com/tcm/v2/instance/"))) {
            PushLogUtils.LOG.w((Object)"gslb not inited");
            return;
        }
        Tracker.getInstance().trackReport();
        SelfDestroyInfo info = this.mRemoteDataSource.selfDestroy();
        if (info == null) {
            PushLogUtils.LOG.e((Object)"sync self-destroying fail");
            this.putSpValue("push_self_destroying_time", System.currentTimeMillis() + PushConfigUtils.getSelfDestroyingInterval());
            return;
        }
        PushLogUtils.LOG.d((Object)("get self-destroying response data: " + info.toString()));
        this.putSpValue("push_self_destroying", info.destroy);
        this.putSpValue("push_self_destroying_interval", info.interval);
        this.putSpValue("push_self_destroying_time", System.currentTimeMillis() + PushConfigUtils.getSelfDestroyingInterval());
    }

    @Override
    public void getClientId(final IClientIdListener listener) {
        PushLogUtils.LOG.d((Object)"get client id");
        String clientId = this.getSpValue("push_client_id", "");
        if (!TextUtils.isEmpty((CharSequence)clientId) && listener != null) {
            listener.onSuccess(clientId);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.getSpValue("push_token", ""))) {
            FirebaseUtils.updateToken(new FirebaseUtils.IFirebaseTokenListener(){

                @Override
                public void onSuccess() {
                    PushRepository.this.syncActiveForClientId(listener);
                }

                @Override
                public void onFail() {
                    if (listener != null) {
                        listener.onFail("get token fail");
                    }
                }
            });
        } else {
            this.syncActiveForClientId(listener);
        }
    }

    private void syncActiveForClientId(final IClientIdListener listener) {
        if (this.mRemoteDataSource == null) {
            if (listener != null) {
                listener.onFail("mRemoteDataSource is null");
            }
            PushLogUtils.LOG.w((Object)"mRemoteDataSource is null");
            return;
        }
        ThreadManager.executeInBackground(new Runnable(){

            @Override
            public void run() {
                ConfigInfo configInfo = PushRepository.this.mRemoteDataSource.syncActive();
                if (configInfo == null) {
                    if (listener != null) {
                        listener.onFail("get client id fail");
                    }
                    PushLogUtils.LOG.d((Object)"get client id fail");
                    return;
                }
                PushLogUtils.LOG.d((Object)("get config response data: " + configInfo.toString()));
                PushRepository.this.putSpValue("push_is_next_with_app", configInfo.nextWithApp);
                PushRepository.this.putSpValue("push_is_report_detail", configInfo.nextWithDetail);
                PushRepository.this.putSpValue("push_client_id", configInfo.clientId);
                PushIml.saveDestroyConfig(configInfo.destroyAppIds, configInfo.syncInfoInterval);
                if (configInfo.configRefresh && configInfo.config != null && configInfo.config.version > 0) {
                    PushRepository.this.saveConfig(configInfo.config);
                    PushRepository.this.putSpValue("push_self_destroying", configInfo.config.destroy);
                }
                if (configInfo.whitelistRefresh && configInfo.whitelist != null && configInfo.whitelist.version > 0) {
                    PushRepository.this.saveWhiteList(configInfo.whitelist);
                }
                if (listener != null) {
                    listener.onSuccess(configInfo.clientId);
                }
            }
        });
    }

    private void retrySyncActive() {
        int retryCount = this.getSpValue("retry_count", 0);
        int maxRetryCount = PushConfigUtils.getRetryCount();
        PushLogUtils.LOG.d((Object)("Reporting Failure, Retry Reporting,retryCount\uff1a" + retryCount + ", max retryCount\uff1a" + maxRetryCount));
        if (retryCount >= maxRetryCount) {
            PushLogUtils.LOG.d((Object)"More than the maximum number of retries");
            this.saveReportTime(System.currentTimeMillis() + PushConfigUtils.getReportActiveInterval());
            this.putSpValue("retry_count", 0);
            return;
        }
        this.putSpValue("retry_count", retryCount + 1);
        this.saveReportTime(System.currentTimeMillis() + PushConfigUtils.getRetryInterval());
    }

    static {
        sLocalReportTime = -1L;
        sLocalTpmsReportTime = -1L;
    }
}

