/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.utils;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import com.transsion.core.CoreUtil;
import com.transsion.core.deviceinfo.DeviceInfo;
import com.transsion.push.utils.PushLogUtils;
import java.util.TimeZone;

public final class DeviceUtils {
    public static int getMCC() {
        int mcc = 0;
        String imsi = DeviceInfo.getSimOperator();
        if (!TextUtils.isEmpty((CharSequence)imsi) && imsi.length() >= 3) {
            String mccStr = imsi.substring(0, 3);
            try {
                mcc = Integer.parseInt(mccStr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return mcc;
    }

    public static int getMNC() {
        int mnc = 0;
        String imsi = DeviceInfo.getSimOperator();
        if (!TextUtils.isEmpty((CharSequence)imsi) && imsi.length() >= 4) {
            String mncStr = imsi.substring(3);
            try {
                mnc = Integer.parseInt(mncStr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return mnc;
    }

    public static String getPackageName() {
        try {
            return CoreUtil.getContext().getPackageName();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getVersionName(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static float getScreenWidth(Context context) {
        WindowManager windowManager = (WindowManager)context.getApplicationContext().getSystemService("window");
        if (windowManager != null) {
            DisplayMetrics dm = new DisplayMetrics();
            windowManager.getDefaultDisplay().getMetrics(dm);
            return dm.widthPixels;
        }
        return 0.0f;
    }

    public static float dpToPx(Context context, float dp) {
        return dp * ((float)context.getResources().getDisplayMetrics().densityDpi / 160.0f);
    }

    public static String getCurrentTimeZone() {
        String timeZone = "";
        try {
            TimeZone tz = TimeZone.getDefault();
            return DeviceUtils.createGmtOffsetString(true, true, tz.getRawOffset());
        }
        catch (Throwable e) {
            PushLogUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
            return timeZone;
        }
    }

    private static String createGmtOffsetString(boolean includeGmt, boolean includeMinuteSeparator, int offsetMillis) {
        int offsetMinutes = offsetMillis / 60000;
        char sign = '+';
        if (offsetMinutes < 0) {
            sign = '-';
            offsetMinutes = -offsetMinutes;
        }
        StringBuilder builder = new StringBuilder(9);
        if (includeGmt) {
            builder.append("GMT");
        }
        builder.append(sign);
        DeviceUtils.appendNumber(builder, 2, offsetMinutes / 60);
        if (includeMinuteSeparator) {
            builder.append(':');
        }
        DeviceUtils.appendNumber(builder, 2, offsetMinutes % 60);
        return builder.toString();
    }

    private static void appendNumber(StringBuilder builder, int count, int value) {
        String string = Integer.toString(value);
        for (int i = 0; i < count - string.length(); ++i) {
            builder.append('0');
        }
        builder.append(string);
    }

    public static boolean isPad(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public static boolean checkDeviceDebuggable() {
        String buildTags = Build.TAGS;
        if (buildTags != null && buildTags.contains("test-keys")) {
            PushLogUtils.LOG.d((Object)("buildTags=" + buildTags));
            return true;
        }
        return false;
    }
}

