/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.utils;

import com.transsion.core.utils.NetUtil;

public final class NetUtils {
    private static final String NET_TYPE_UNKNOWN = "";
    private static final String NET_TYPE_WIFI = "wifi";
    private static final String NET_TYPE_2G = "2G";
    private static final String NET_TYPE_3G = "3G";
    private static final String NET_TYPE_4G = "4G";

    public static String getCurrentNetworkType() {
        int networkClass = NetUtil.getNetworkType();
        String type = NET_TYPE_UNKNOWN;
        switch (networkClass) {
            case -1: {
                type = NET_TYPE_UNKNOWN;
                break;
            }
            case -101: {
                type = NET_TYPE_WIFI;
                break;
            }
            case 1: {
                type = NET_TYPE_2G;
                break;
            }
            case 2: {
                type = NET_TYPE_3G;
                break;
            }
            case 3: {
                type = NET_TYPE_4G;
                break;
            }
            case 0: {
                type = NET_TYPE_UNKNOWN;
            }
        }
        return type;
    }

    public static boolean isWifi() {
        return NET_TYPE_WIFI.equals(NetUtils.getCurrentNetworkType());
    }

    public static String getTrackerNetType() {
        String type = NetUtils.getCurrentNetworkType();
        if (NET_TYPE_WIFI.equals(type)) {
            return NET_TYPE_WIFI;
        }
        if (NET_TYPE_UNKNOWN.equals(type)) {
            return "no_network";
        }
        return "mobile";
    }
}

