/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.utils;

import android.app.ActivityManager;
import android.app.INotificationManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Icon;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Process;
import android.os.ServiceManager;
import android.text.TextUtils;
import android.widget.RemoteViews;
import androidx.annotation.RequiresApi;
import com.transsion.core.CoreUtil;
import com.transsion.core.utils.AppUtil;
import com.transsion.gslb.GslbSdk;
import com.transsion.json.Tson;
import com.transsion.os.Build;
import com.transsion.push.PushManager;
import com.transsion.push.R;
import com.transsion.push.bean.PushAppInfo;
import com.transsion.push.bean.PushMessage;
import com.transsion.push.bean.PushRequest;
import com.transsion.push.broadcast.HandlerBroadcastReceiver;
import com.transsion.push.config.PushRepository;
import com.transsion.push.provider.ProviderDbManager;
import com.transsion.push.tracker.Tracker;
import com.transsion.push.utils.BitmapDownloadUtils;
import com.transsion.push.utils.CustomNotificationUtils;
import com.transsion.push.utils.NotificationAssistUtils;
import com.transsion.push.utils.NotificationHelper;
import com.transsion.push.utils.PushLogUtils;
import com.transsion.push.utils.PushUtils;
import com.transsion.push.utils.ServiceUtils;
import com.transsion.push.utils.WhiteListUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;

public class PushIml {
    private static final String EXTRA_SUBSTITUTE_APP_NAME = "android.substName";
    private static final int PLATFORM_SDK_VERSION_29250 = 29250;
    private static final int FLAG_TRAN_FAKE = 0x8000000;

    public static boolean sendNotification(PushMessage message, HashMap<String, Bitmap> images) {
        int platformSdkVersion = PushIml.getPlatformSdkVersion();
        PushLogUtils.LOG.d((Object)("sendNotification platformSdkVersion:" + platformSdkVersion));
        if (TextUtils.isEmpty((CharSequence)message.packageName) || PushUtils.checkUninstall(message.packageName)) {
            Tracker.getInstance().trackShow(message.messageId, message.type, message.timeStamp, NotificationAssistUtils.isOpenNotification(CoreUtil.getContext()), 9);
            return false;
        }
        if (platformSdkVersion >= 29250) {
            PushLogUtils.LOG.d((Object)(" platformSdkVersion:" + platformSdkVersion + "ok, show notification"));
            return PushIml.sendNotificationByTarget(message, images);
        }
        PushLogUtils.LOG.d((Object)(" platformSdkVersion:" + platformSdkVersion + "is smaller than requirement, do not show notification"));
        Tracker.getInstance().trackShow(message.messageId, message.type, message.timeStamp, NotificationAssistUtils.isOpenNotification(CoreUtil.getContext()), 10);
        return false;
    }

    private static boolean sendNotificationByTarget(PushMessage message, HashMap<String, Bitmap> images) {
        if (Build.VERSION.SDK_INT < 26) {
            PushLogUtils.LOG.w((Object)("sendNotification Minimum 26, not support sdk_int:" + Build.VERSION.SDK_INT));
            return false;
        }
        try {
            NotificationManager notificationManager = (NotificationManager)CoreUtil.getContext().getSystemService("notification");
            Notification.Builder builder = NotificationHelper.getNotificationBuilder(CoreUtil.getContext(), message);
            Notification notification = PushIml.setNotificationView(CoreUtil.getContext(), message, images, builder);
            if (notificationManager != null && notification != null) {
                PushIml.createNotificationChannel(message);
                notification.flags |= 0x8000000;
                PackageManager pm = CoreUtil.getContext().getPackageManager();
                int callingUid = pm.getPackageUid(message.packageName, 0);
                int callingPid = Process.myPid();
                if (PushManager.getInstance().getNotiListener() != null) {
                    PushManager.getInstance().getNotiListener().onNotificationRequest(message, notification, callingUid, callingPid);
                }
                return true;
            }
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("show failure, e:" + e.toString()));
        }
        return false;
    }

    public static int getPlatformSdkVersion() {
        int platformSdkVersion = 0;
        try {
            Class.forName("com.transsion.os.Build");
        }
        catch (ClassNotFoundException e) {
            return platformSdkVersion;
        }
        try {
            String platformSdkVersionStr = "";
            String[] sdkStrs = Build.PLATFORM_SDK_VERSION.split("\\.");
            for (int i = 0; i < sdkStrs.length; ++i) {
                platformSdkVersionStr = platformSdkVersionStr + Integer.parseInt(sdkStrs[i]);
            }
            platformSdkVersion = Integer.parseInt(platformSdkVersionStr);
            return platformSdkVersion;
        }
        catch (Exception e) {
            e.printStackTrace();
            return platformSdkVersion;
        }
    }

    @RequiresApi(api=26)
    private static void createNotificationChannel(PushMessage message) {
        ApplicationInfo applicationInfo = null;
        int uid = 0;
        String name = null;
        try {
            PackageManager pm = CoreUtil.getContext().getPackageManager();
            applicationInfo = pm.getApplicationInfo(message.packageName, 8192);
            uid = applicationInfo.uid;
            name = applicationInfo.loadLabel(pm).toString();
        }
        catch (Exception e) {
            PushLogUtils.LOG.d((Object)("createNotificationChannel get applicationInfo fail, e = " + e));
        }
        NotificationChannel channel = new NotificationChannel(TextUtils.isEmpty((CharSequence)message.channelId) ? "twibida" : message.channelId, (CharSequence)(TextUtils.isEmpty((CharSequence)message.channelName) ? "cloud messaging" : message.channelName), 3);
        try {
            INotificationManager service = INotificationManager.Stub.asInterface((IBinder)ServiceManager.getService((String)"notification"));
            service.createNotificationChannelsForPackage(message.packageName, uid, new ParceledListSlice(Arrays.asList(channel)));
        }
        catch (Exception e) {
            PushLogUtils.LOG.w((Object)("createNotificationChannel: e = " + e));
        }
    }

    private static int getPidByProcessName(Context context, String packageName) {
        ActivityManager mActivityManager = (ActivityManager)context.getSystemService("activity");
        List appProcessList = mActivityManager.getRunningAppProcesses();
        if (appProcessList != null) {
            for (ActivityManager.RunningAppProcessInfo appProcess : appProcessList) {
                if (!packageName.equals(appProcess.processName)) continue;
                return appProcess.pid;
            }
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Notification setNotificationView(Context context, PushMessage message, HashMap<String, Bitmap> images, Notification.Builder builder) {
        if (message == null) return null;
        if (builder == null) {
            return null;
        }
        if (images != null && images.get(message.notiSmallIcon) != null && Build.VERSION.SDK_INT >= 23) {
            Icon icon = Icon.createWithBitmap((Bitmap)images.get(message.notiSmallIcon));
            builder.setSmallIcon(icon);
        } else {
            builder.setSmallIcon(R.drawable.tpush_notify_icon);
        }
        PushIml.setIconColor(builder, message);
        if (message.notiType == 1) {
            builder.setContentTitle((CharSequence)message.notiTitle).setContentText((CharSequence)message.notiDes);
            if (message.notiExType == 2) {
                builder.setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)message.notiTxtEx));
            } else if (message.notiExType == 3 && images != null && images.get(message.notiImgEx) != null) {
                builder.setLargeIcon(images.get(message.notiImgEx));
                builder.setStyle((Notification.Style)new Notification.BigPictureStyle().bigPicture(images.get(message.notiImgEx)).bigLargeIcon((Bitmap)null));
            }
            builder.setContentIntent(PushIml.getPendingIntent(CoreUtil.getContext(), message));
            return builder.build();
        }
        RemoteViews remoteViews = CustomNotificationUtils.getCustomRemoteViews(context, message, images, false);
        if (remoteViews == null) {
            return builder.build();
        }
        if (CustomNotificationUtils.isExtensibleNotification(message.notiExType)) {
            RemoteViews bigRemoteViews = CustomNotificationUtils.getCustomRemoteViews(context, message, images, true);
            if (Build.VERSION.SDK_INT >= 24) {
                builder.setCustomContentView(remoteViews);
                builder.setCustomBigContentView(bigRemoteViews);
                return builder.build();
            }
            Notification notification = builder.build();
            notification.contentView = remoteViews;
            notification.bigContentView = bigRemoteViews;
            return notification;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            builder.setCustomContentView(remoteViews);
        } else {
            builder.setContent(remoteViews);
        }
        if (!CustomNotificationUtils.isTarget31()) return builder.build();
        builder.setStyle((Notification.Style)new Notification.DecoratedCustomViewStyle());
        RemoteViews bigView = CustomNotificationUtils.getBigView(context, message, images, false);
        builder.setCustomBigContentView(bigView);
        return builder.build();
    }

    public static void onHandleChannelMessage(Intent intent) {
        String appId;
        if (intent == null) {
            return;
        }
        PushMessage message = PushUtils.getIntentMessage(intent);
        if (message == null) {
            PushLogUtils.LOG.w((Object)"message is null");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)message.packageName)) {
            message.packageName = WhiteListUtils.idToPackageName(message.pkgId);
        }
        if ((message.type == 1 || message.type == 2 || message.type == 7) && (appId = PushRepository.getInstance().getSpValue("push_app_id", "")).equals(message.pkgId)) {
            if (TextUtils.isEmpty((CharSequence)message.packageName)) {
                message.packageName = AppUtil.getPkgName();
            }
            PushLogUtils.LOG.d((Object)("message target packageName:" + message.packageName));
            PushUtils.sendMessageToTarget(message);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)message.packageName)) {
            PushLogUtils.LOG.d((Object)"message target packageName NULL");
            Tracker.getInstance().trackMessage(message.messageId, message.type, message.timeStamp, "fail", 5);
            return;
        }
        message.pkgId = message.packageName;
        PushLogUtils.LOG.d((Object)("message target packageName:" + message.packageName));
        if (message.type != 6 && PushUtils.checkUninstall(message.packageName)) {
            PushLogUtils.LOG.e((Object)"uninstall");
            Tracker.getInstance().trackMessage(message.messageId, message.type, message.timeStamp, "fail", 3);
            return;
        }
        if (PushUtils.isAppDisable(message.packageName)) {
            return;
        }
        try {
            switch (message.displayPolicy) {
                case 1: {
                    PushIml.showNotification(message);
                    break;
                }
                case 3: {
                    PushIml.targetBroadcast(message);
                    break;
                }
                case 2: {
                    PushIml.targetTransmit(message);
                    break;
                }
                default: {
                    PushLogUtils.LOG.e((Object)("display policy does not support., displayPolicy:" + message.displayPolicy));
                    break;
                }
            }
        }
        catch (Exception e) {
            Tracker.getInstance().trackMessage(message.messageId, message.type, message.timeStamp, "fail", 2);
            PushLogUtils.LOG.e((Object)("Notification or transmission exception,e:" + e.getMessage()));
        }
    }

    private static void targetBroadcast(PushMessage message) {
        if (PushUtils.checkUninstall(message.packageName)) {
            Tracker.getInstance().trackMessage(message.messageId, message.type, message.timeStamp, "fail", 3);
            return;
        }
        if (PushUtils.getIsMessageHandled(message.messageId)) {
            return;
        }
        PushUtils.setMessageHandled(message.messageId);
        try {
            Intent intent = new Intent("tpush.intent.action.TPUSH_MSG_RECEIVER");
            intent.setFlags(32);
            intent.setPackage(message.packageName);
            intent.putExtra("message", Tson.toJson((Object)message));
            CoreUtil.getContext().sendBroadcast(intent);
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)e);
        }
    }

    private static void showNotification(PushMessage message) {
        if (PushUtils.getIsMessageHandled(message.messageId)) {
            return;
        }
        if (PushUtils.retraceMessage(message)) {
            return;
        }
        PushUtils.setMessageHandled(message.messageId);
        if (BitmapDownloadUtils.checkIsDownloadBitmap(message)) {
            BitmapDownloadUtils.downloadBitmap(message, new BitmapDownloadUtils.BitmapDownloadListener(){

                @Override
                public void downloadComplete(PushMessage message, HashMap<String, Bitmap> images) {
                    PushIml.showNoti(message, images);
                }
            });
        } else {
            PushIml.showNoti(message, null);
        }
    }

    private static void showNoti(PushMessage message, HashMap<String, Bitmap> images) {
        try {
            if (PushIml.sendNotification(message, images)) {
                Tracker.getInstance().trackTarget(message.messageId, message.type, message.timeStamp, message.rpkg, "success");
                PushIml.repotImp(message);
            }
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("Notification show exception:" + e.getMessage()));
        }
    }

    private static void repotImp(PushMessage message) {
        try {
            if (!TextUtils.isEmpty((CharSequence)message.impUrlList)) {
                Bundle bundle = new Bundle();
                bundle.putString("service_type", "report_imp");
                bundle.putString("extra_imp_urls", message.impUrlList);
                ServiceUtils.startJobThread(CoreUtil.getContext().getApplicationContext(), bundle);
            }
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("repotImp exception:" + e.getMessage()));
        }
    }

    private static void targetTransmit(final PushMessage message) {
        if (PushUtils.checkUninstall(message.packageName)) {
            Tracker.getInstance().trackUninstall(message.messageId, message.packageName);
            Tracker.getInstance().trackMessage(message.messageId, message.type, message.timeStamp, "fail", 3);
            return;
        }
        if (!PushUtils.checkMessage(message, 0)) {
            return;
        }
        PushUtils.setMessageHandled(message.messageId);
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

            @Override
            public void run() {
                try {
                    Intent targetIntent = new Intent();
                    targetIntent.putExtra("message", Tson.toJson((Object)message));
                    targetIntent.setClassName(message.packageName, "com.transsion.pushui.activity.TransparentActivity");
                    targetIntent.setFlags(0x10000000);
                    CoreUtil.getContext().startActivity(targetIntent);
                    Tracker.getInstance().trackMessage(message.messageId, message.type, message.timeStamp, "success", 0);
                }
                catch (Exception e) {
                    PushLogUtils.LOG.e((Object)("start activity fail:" + e.getMessage()));
                }
            }
        }, (long)(Math.random() * 1500.0 + 500.0));
    }

    public static void checkChannelId(PushMessage message) {
    }

    private static void setIconColor(Notification.Builder builder, PushMessage message) {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        try {
            if (!TextUtils.isEmpty((CharSequence)message.iconColor)) {
                int color = Color.parseColor((String)message.iconColor);
                builder.setColor(color);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static PendingIntent getPendingIntent(Context context, PushMessage message) {
        Intent intent = new Intent(context, HandlerBroadcastReceiver.class);
        intent.setAction(context.getPackageName() + ".push.action");
        intent.setPackage(context.getPackageName());
        intent.putExtra("message", Tson.toJson((Object)message));
        PendingIntent pt = Build.VERSION.SDK_INT >= 23 ? PendingIntent.getBroadcast((Context)context, (int)UUID.randomUUID().hashCode(), (Intent)intent, (int)0x4000000) : PendingIntent.getBroadcast((Context)context, (int)UUID.randomUUID().hashCode(), (Intent)intent, (int)0x8000000);
        return pt;
    }

    public static void setAppsContent(PushRequest.ReportContentData dataContent) {
        ArrayList<PushAppInfo> appInfoList = ProviderDbManager.getInstance().queryActives();
        ProviderDbManager.getInstance().checkAppInfos(CoreUtil.getContext(), appInfoList);
        if (appInfoList != null && appInfoList.size() > 0) {
            PushAppInfo[] appInfos = new PushAppInfo[appInfoList.size()];
            dataContent.appInfos = appInfoList.toArray(appInfos);
        }
        if (PushUtils.getSdkPkgs().size() > 0) {
            List<String> pkgList = PushUtils.getSdkPkgs();
            dataContent.apps = new String[pkgList.size()];
            for (int i = 0; i < pkgList.size(); ++i) {
                dataContent.apps[i] = pkgList.get(i);
            }
        }
    }

    public static void saveDestroyConfig(String[] destroyApps, int syncInfoInterval) {
        PushRepository.getInstance().removeSpValue("destroy_app_ids");
        if (destroyApps != null && destroyApps.length > 0) {
            HashSet<String> set = new HashSet<String>(Arrays.asList(destroyApps));
            PushRepository.getInstance().putSpValue("destroy_app_ids", set);
        }
        PushRepository.getInstance().putSpValue("sync_interval", syncInfoInterval > 0 ? syncInfoInterval : 86400);
    }

    public static String getReportUrl() {
        if (PushManager.getInstance().getTestEnv()) {
            return "https://test-api.twibida.com/tcm/v2/instance/";
        }
        if (PushManager.getInstance().getDebug()) {
            return "https://devtest-api.twibida.com/tcm/v2/instance/";
        }
        try {
            String domainUrl = GslbSdk.getDomain((String)"https://api.twibida.com/tcm/v2/instance/", (boolean)false);
            if (!TextUtils.isEmpty((CharSequence)domainUrl)) {
                PushLogUtils.LOG.d((Object)("gslb domain is" + domainUrl));
                return domainUrl;
            }
            PushLogUtils.LOG.d((Object)"gslb domain is empty");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean isSystemChannel() {
        return true;
    }
}

