/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.utils;

import android.app.Activity;
import android.os.Build;
import android.view.View;
import android.view.Window;
import com.transsion.push.utils.PushLogUtils;
import java.lang.reflect.Field;

public class StatusBarUtils {
    public static void setStatusBarLightMode(Window window, boolean isLightMode) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        View decorView = window.getDecorView();
        if (decorView == null) {
            return;
        }
        int vis = decorView.getSystemUiVisibility();
        if (isLightMode) {
            window.addFlags(Integer.MIN_VALUE);
            vis |= 0x2000;
        } else {
            vis &= 0xFFFFDFFF;
        }
        decorView.setSystemUiVisibility(vis);
    }

    public static void setStatusBarColor(Activity activity, int res) {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        Window window = activity.getWindow();
        if (Build.VERSION.SDK_INT >= 23) {
            window.setStatusBarColor(activity.getResources().getColor(res, activity.getTheme()));
        } else {
            window.setStatusBarColor(activity.getResources().getColor(res));
        }
        activity.setImmersive(true);
    }

    public static void setNavigationBarColor(Activity activity, int res) {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        Window window = activity.getWindow();
        if (Build.VERSION.SDK_INT >= 23) {
            window.setNavigationBarColor(activity.getResources().getColor(res, activity.getTheme()));
        } else {
            window.setNavigationBarColor(activity.getResources().getColor(res));
        }
        activity.setImmersive(true);
    }

    public static void setNavigationBarLightMode(Activity activity, boolean isLightMode) {
        try {
            int darkModeFlag = 0;
            Field filed = View.class.getField("SYSTEM_UI_FLAG_LIGHT_NAVIGATION_BAR");
            darkModeFlag = filed.getInt(View.class);
            if (darkModeFlag > 0) {
                View decorView = activity.getWindow().getDecorView();
                if (!isLightMode) {
                    decorView.setSystemUiVisibility(decorView.getSystemUiVisibility() | darkModeFlag);
                } else {
                    decorView.setSystemUiVisibility(decorView.getSystemUiVisibility() & ~darkModeFlag);
                }
            }
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)"not surport NavigationbarDarkMode");
        }
    }
}

