/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.utils;

import android.text.TextUtils;
import com.transsion.push.bean.ConfigInfo;
import com.transsion.push.config.PushRepository;

public class WhiteListUtils {
    public static int getWhiteListVersion() {
        ConfigInfo.Whitelist whiteList = PushRepository.getInstance().getWhiteList();
        if (whiteList != null && whiteList.version > 0) {
            return whiteList.version;
        }
        return 0;
    }

    public static boolean checkPkgInWhiteList(String pkg) {
        if (TextUtils.isEmpty((CharSequence)pkg)) {
            return false;
        }
        ConfigInfo.Whitelist whiteList = PushRepository.getInstance().getWhiteList();
        if (whiteList != null && whiteList.apps != null) {
            for (ConfigInfo.Apps appPkgId : whiteList.apps) {
                if (appPkgId == null || !pkg.equals(appPkgId.pkg)) continue;
                return true;
            }
        }
        return false;
    }

    public static String idToPackageName(String id2) {
        if (TextUtils.isEmpty((CharSequence)id2)) {
            return null;
        }
        ConfigInfo.Whitelist whitelist = PushRepository.getInstance().getWhiteList();
        if (whitelist == null || whitelist.apps == null) {
            return null;
        }
        for (ConfigInfo.Apps appPkgId : whitelist.apps) {
            if (appPkgId != null && id2.equals(appPkgId.id)) {
                return appPkgId.pkg;
            }
            if (appPkgId == null || !id2.equals(appPkgId.pkg)) continue;
            return appPkgId.pkg;
        }
        return null;
    }
}

