/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import com.transsion.core.CoreUtil;
import com.transsion.http.HttpClient;
import com.transsion.http.builder.ImageRequestBuilder;
import com.transsion.http.impl.BitmapCallback;
import com.transsion.http.impl.IHttpCallback;
import com.transsion.push.utils.BitmapUtils;
import com.transsion.push.utils.PushLogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public final class ImageUtils {
    public static void loadImages(int notiType, List<String> urls, final ImagesCallback callback) {
        final HashMap images = new HashMap();
        final AtomicInteger atomicCount = new AtomicInteger(urls.size());
        for (String url : urls) {
            if (TextUtils.isEmpty((CharSequence)url)) continue;
            ImageUtils.loadImage(notiType, url, new ImageCallback(){

                @Override
                public void onComplete(String url, Bitmap bitmap) {
                    images.put(url, bitmap);
                    int count = atomicCount.decrementAndGet();
                    if (count == 0) {
                        callback.onComplete(images);
                    }
                }
            });
        }
    }

    private static void loadImage(final int notiType, final String url, final ImageCallback callback) {
        Context context = null;
        try {
            context = CoreUtil.getContext();
        }
        catch (Exception e) {
            if (callback != null) {
                callback.onComplete(url, null);
            }
            return;
        }
        ((ImageRequestBuilder)((ImageRequestBuilder)((ImageRequestBuilder)((ImageRequestBuilder)HttpClient.image((Context)context).cache(true).log(CoreUtil.isDebug())).connectTimeout(10000)).readTimeout(10000)).url(url)).build().execute((IHttpCallback)new BitmapCallback(){

            public void onFailure(int statusCode, Bitmap responseString, Throwable throwable) {
                PushLogUtils.LOG.e((Object)("image download fail, url:" + url));
                if (callback != null) {
                    callback.onComplete(url, null);
                }
            }

            public void onSuccess(int statusCode, Bitmap responseFile) {
                PushLogUtils.LOG.d((Object)("image download complete, url:" + url));
                if (callback != null) {
                    if (notiType == 3) {
                        try {
                            Context context1 = CoreUtil.getContext();
                            callback.onComplete(url, BitmapUtils.getLargeCornerBitmap(context1, responseFile));
                        }
                        catch (Exception e) {
                            callback.onComplete(url, null);
                        }
                    } else {
                        callback.onComplete(url, responseFile);
                    }
                }
            }
        });
    }

    static interface ImagesCallback {
        public void onComplete(HashMap<String, Bitmap> var1);
    }

    static interface ImageCallback {
        public void onComplete(String var1, Bitmap var2);
    }
}

