/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Bundle;
import android.text.TextUtils;
import com.transsion.core.CoreUtil;
import com.transsion.crypto.TCrypterSdk;
import com.transsion.gslb.GslbSdk;
import com.transsion.push.IClientIdListener;
import com.transsion.push.ITopicListener;
import com.transsion.push.NotificationListener;
import com.transsion.push.TPushListener;
import com.transsion.push.bean.PushConfig;
import com.transsion.push.bean.PushMessage;
import com.transsion.push.bean.PushNotification;
import com.transsion.push.broadcast.PushBroadcastReceiver;
import com.transsion.push.config.PushRepository;
import com.transsion.push.tracker.Tracker;
import com.transsion.push.utils.FirebaseUtils;
import com.transsion.push.utils.PushLogUtils;
import com.transsion.push.utils.PushUtils;
import com.transsion.push.utils.ServiceUtils;
import com.transsion.push.utils.ThreadManager;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public final class PushManager {
    private PushBroadcastReceiver mPushBroadcastReceiver;
    private static AtomicBoolean sInit = new AtomicBoolean(false);
    private static boolean sSdkInitFinished;
    private TPushListener mListener;
    private NotificationListener mNotiListener;

    private PushManager() {
    }

    public static PushManager getInstance() {
        return Holder.INSTANCE;
    }

    public void trackShow(PushMessage message, boolean isShow) {
        Tracker.getInstance().trackShow(message.messageId, message.type, message.timeStamp, true, isShow ? 0 : 8);
    }

    public void registerNotificationListener(NotificationListener listener) {
        this.mNotiListener = listener;
    }

    public NotificationListener getNotiListener() {
        return this.mNotiListener;
    }

    public void registerPushListener(TPushListener listener) {
        this.mListener = listener;
    }

    public TPushListener getPushListener() {
        return this.mListener;
    }

    public void init(final Context context, final String appId, final String appKey, final boolean isTest) {
        try {
            CoreUtil.init((Context)context.getApplicationContext());
            if (sInit.get()) {
                return;
            }
            String[] domains = new String[]{"https://api.twibida.com/tcm/v2/instance/"};
            GslbSdk.init((Context)context, (String[])domains, (GslbSdk.InitListener)new GslbSdk.InitListener(){

                public void onInitSuccess(Map<String, String> domainMap) {
                    PushLogUtils.LOG.d((Object)"gslb sdk init success");
                    if (PushUtils.isSyncActive()) {
                        Bundle bundle = new Bundle();
                        bundle.putString("service_type", "force_update");
                        ServiceUtils.startJobThread(context.getApplicationContext(), bundle);
                        PushLogUtils.LOG.d((Object)"gslb success, force update info to server");
                    }
                }

                public void onInitFail() {
                    PushLogUtils.LOG.d((Object)"gslb sdk init fail");
                }
            });
            sInit.set(true);
            long startTime = System.currentTimeMillis();
            TCrypterSdk.init((Context)context.getApplicationContext());
            Tracker.getInstance().init();
            ThreadManager.executeInBackground(new Runnable(){

                @Override
                public void run() {
                    PushRepository.getInstance().putSpValue("push_app_id", appId);
                    PushRepository.getInstance().putSpValue("push_app_key", appKey);
                    PushRepository.getInstance().putSpValue("push_is_test_env", isTest);
                    CoreUtil.setDebug((boolean)PushUtils.isDebug());
                    Tracker.getInstance().trackInit();
                    FirebaseUtils.updateToken();
                }
            });
            this.registerReceiver();
            sSdkInitFinished = true;
            PushLogUtils.LOG.e((Object)("sdk init time: " + (System.currentTimeMillis() - startTime)));
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("init fail, e:" + e.getMessage()));
            sSdkInitFinished = false;
        }
    }

    public void init(final Context context) {
        try {
            CoreUtil.init((Context)context.getApplicationContext());
            if (sInit.get()) {
                return;
            }
            sInit.set(true);
            long startTime = System.currentTimeMillis();
            String[] domains = new String[]{"https://api.twibida.com/tcm/v2/instance/"};
            GslbSdk.init((Context)context, (String[])domains, (GslbSdk.InitListener)new GslbSdk.InitListener(){

                public void onInitSuccess(Map<String, String> domainMap) {
                    PushLogUtils.LOG.d((Object)"gslb sdk init success");
                    if (PushUtils.isSyncActive()) {
                        Bundle bundle = new Bundle();
                        bundle.putString("service_type", "force_update");
                        ServiceUtils.startJobThread(context.getApplicationContext(), bundle);
                        PushLogUtils.LOG.d((Object)"gslb success, force update info to server");
                    }
                }

                public void onInitFail() {
                    PushLogUtils.LOG.d((Object)"gslb sdk init fail");
                }
            });
            TCrypterSdk.init((Context)context.getApplicationContext());
            ThreadManager.executeInBackground(new Runnable(){

                @Override
                public void run() {
                    Tracker.getInstance().init();
                    PushUtils.initMetaData();
                    CoreUtil.setDebug((boolean)PushUtils.isDebug());
                    Tracker.getInstance().trackInit();
                    FirebaseUtils.updateToken();
                }
            });
            this.registerReceiver();
            sSdkInitFinished = true;
            PushLogUtils.LOG.e((Object)("sdk init time: " + (System.currentTimeMillis() - startTime)));
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("init fail, e:" + e.getMessage()));
            sSdkInitFinished = false;
        }
    }

    public void setAppInfo(String appId, String appkey) {
        if (this.getIsSdkInitFinished()) {
            return;
        }
        String oldAppid = PushRepository.getInstance().getSpValue("push_app_id", appId);
        String oldAppkey = PushRepository.getInstance().getSpValue("push_app_key", appId);
        try {
            if (oldAppid.equalsIgnoreCase(appId) && oldAppkey.equalsIgnoreCase(appkey)) {
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)appId)) {
                PushRepository.getInstance().putSpValue("push_app_id", appId);
            }
            if (!TextUtils.isEmpty((CharSequence)appkey)) {
                PushRepository.getInstance().putSpValue("push_app_key", appkey);
            }
            ThreadManager.executeInBackground(new Runnable(){

                @Override
                public void run() {
                    PushRepository.getInstance().syncActive();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean getIsSdkInitFinished() {
        return sSdkInitFinished;
    }

    public boolean getDebug() {
        return PushUtils.isDebug();
    }

    @Deprecated
    public void registerReceiver(Context context, BroadcastReceiver broadcastReceiver) {
        try {
            PushLogUtils.LOG.d((Object)"registerReceiver --> ");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unregisterReceiver(Context context, BroadcastReceiver broadcastReceiver) {
        CoreUtil.getContext().unregisterReceiver(broadcastReceiver);
    }

    private void registerReceiver() {
        IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        if (this.mPushBroadcastReceiver == null) {
            this.mPushBroadcastReceiver = new PushBroadcastReceiver();
        }
        try {
            CoreUtil.getContext().registerReceiver((BroadcastReceiver)this.mPushBroadcastReceiver, filter);
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("registerReceiver fail, e:" + e.getMessage()));
        }
    }

    public void setPushConfig(PushConfig config) {
    }

    public void subscribeToTopic(String topic, ITopicListener listener) {
    }

    public void unsubscribeFromTopic(String topic, ITopicListener listener) {
    }

    public void getClientId(IClientIdListener listener) {
        PushRepository.getInstance().getClientId(listener);
    }

    public void addCustomNotification(PushNotification notification) {
    }

    public void trackShow(long msgId, boolean isSuccesss, int failReason) {
    }

    public void trackClick(long msgId) {
    }

    public void trackConversion(long msgId) {
    }

    public void trackArrive(long msgId) {
    }

    public boolean getTestEnv() {
        return PushUtils.isTestEnv();
    }

    public void setNotificationSwitch(boolean isOpen) {
    }

    public boolean getNotificationSwitch() {
        return true;
    }

    private static final class Holder {
        private static final PushManager INSTANCE = new PushManager();

        private Holder() {
        }
    }
}

