/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.config;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.transsion.core.CoreUtil;
import com.transsion.core.deviceinfo.DeviceInfo;
import com.transsion.core.utils.AppUtil;
import com.transsion.crypto.crypter.AesCbcPKCS5RandomCrypter;
import com.transsion.crypto.crypter.RsaEcsPKCS1Encrypter;
import com.transsion.ga.AthenaAnalytics;
import com.transsion.json.Tson;
import com.transsion.push.ITopicListener;
import com.transsion.push.bean.ConfigInfo;
import com.transsion.push.bean.PushRequest;
import com.transsion.push.bean.PushResponse;
import com.transsion.push.bean.SelfDestroyInfo;
import com.transsion.push.config.PushRepository;
import com.transsion.push.utils.DeviceUtils;
import com.transsion.push.utils.HttpUtils;
import com.transsion.push.utils.NetUtils;
import com.transsion.push.utils.NotificationAssistUtils;
import com.transsion.push.utils.PushConfigUtils;
import com.transsion.push.utils.PushIml;
import com.transsion.push.utils.PushLogUtils;
import com.transsion.push.utils.PushUtils;
import com.transsion.push.utils.StringUtils;
import com.transsion.push.utils.WhiteListUtils;
import java.util.ArrayList;
import java.util.Locale;

public final class RemoteDataSource {
    ConfigInfo syncActive() {
        try {
            PushRequest.ReportContentData dataContent = this.generateReportInstance();
            PushLogUtils.LOG.d((Object)("get config request data: " + dataContent.toString()));
            AesCbcPKCS5RandomCrypter crypter = new AesCbcPKCS5RandomCrypter();
            RsaEcsPKCS1Encrypter rsaEcsPKCS1Encrypter = new RsaEcsPKCS1Encrypter("MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBAKEaYIhDF/GSQZagVqAOo7UU/GqDjQBU5muTCS6qPMfAdtKOzbhRpNCJA/ZmgBxPhc8RVLPO9yiJn5g+hy+tz3cCAwEAAQ==");
            PushRequest pushRequest = new PushRequest();
            String data64 = crypter.base64Encode(crypter.encrypt(Tson.toJson((Object)dataContent)));
            String key64 = crypter.base64Encode(rsaEcsPKCS1Encrypter.encrypt(crypter.getPass()));
            pushRequest.data = data64;
            pushRequest.key = key64;
            byte[] uploadData = Tson.toJson((Object)pushRequest).getBytes();
            String url = PushIml.getReportUrl();
            if (TextUtils.isEmpty((CharSequence)url)) {
                return null;
            }
            url = PushIml.isSystemChannel() ? url + "tpms" : url + PushUtils.getAppId() + "/report";
            PushLogUtils.LOG.d((Object)("request url:" + url));
            byte[] response = HttpUtils.makePostRequest(url, uploadData);
            if (response == null) {
                PushLogUtils.LOG.e((Object)"the response data is empty");
                return null;
            }
            PushResponse pushResponse = (PushResponse)Tson.fromJson((String)new String(response), PushResponse.class);
            if (pushResponse == null) {
                PushLogUtils.LOG.e((Object)"parse syncActive BaseResponse failed");
                return null;
            }
            if (pushResponse.status != 200) {
                PushLogUtils.LOG.e((Object)("syncActive BaseResponse status error, status:" + pushResponse.status + ", " + pushResponse.message));
                return null;
            }
            PushResponse.SignedEncryptedData dataResponseContent = pushResponse.data;
            if (dataResponseContent == null) {
                PushLogUtils.LOG.e((Object)"parse syncActive signedResponse failed");
                return null;
            }
            boolean isSignVerified = rsaEcsPKCS1Encrypter.verify(StringUtils.encodeBySHA256(crypter.base64Decode(dataResponseContent.data)), crypter.base64Decode(dataResponseContent.sign));
            if (!isSignVerified) {
                PushLogUtils.LOG.e((Object)"syncActive verify signature failed");
                return null;
            }
            String content = new String(crypter.decrypt(crypter.base64Decode(dataResponseContent.data)));
            ConfigInfo configInfo = (ConfigInfo)Tson.fromJson((String)content, ConfigInfo.class);
            if (configInfo == null) {
                PushLogUtils.LOG.e((Object)"parse syncActive reportResponse failed");
                return null;
            }
            return configInfo;
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("syncActive Exception: " + e.getMessage()));
            return null;
        }
    }

    SelfDestroyInfo selfDestroy() {
        try {
            PushRequest.SelfDestroyContentData dataContent = this.generateSelfDestroyInstance();
            PushLogUtils.LOG.d((Object)("get self-destroying request data: " + dataContent.toString()));
            AesCbcPKCS5RandomCrypter crypter = new AesCbcPKCS5RandomCrypter();
            RsaEcsPKCS1Encrypter rsaEcsPKCS1Encrypter = new RsaEcsPKCS1Encrypter("MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBAKEaYIhDF/GSQZagVqAOo7UU/GqDjQBU5muTCS6qPMfAdtKOzbhRpNCJA/ZmgBxPhc8RVLPO9yiJn5g+hy+tz3cCAwEAAQ==");
            PushRequest request = new PushRequest();
            String data64 = crypter.base64Encode(crypter.encrypt(Tson.toJson((Object)dataContent)));
            String key64 = crypter.base64Encode(rsaEcsPKCS1Encrypter.encrypt(crypter.getPass()));
            request.data = data64;
            request.key = key64;
            byte[] uploadData = Tson.toJson((Object)request).getBytes();
            String url = PushIml.getReportUrl();
            if (TextUtils.isEmpty((CharSequence)url)) {
                return null;
            }
            url = url + PushUtils.getAppId() + "/config";
            PushLogUtils.LOG.d((Object)("self-destroying request url:" + url));
            byte[] response = HttpUtils.makePostRequest(url, uploadData);
            if (response == null) {
                PushLogUtils.LOG.e((Object)"the response data is empty");
                return null;
            }
            PushResponse pushResponse = (PushResponse)Tson.fromJson((String)new String(response), PushResponse.class);
            if (pushResponse == null) {
                PushLogUtils.LOG.e((Object)"parse self-destroying BaseResponse failed");
                return null;
            }
            if (pushResponse.status != 200) {
                PushLogUtils.LOG.e((Object)("self-destroying BaseResponse status error, status:" + pushResponse.status + ", " + pushResponse.message));
                return null;
            }
            PushResponse.SignedEncryptedData dataResponseContent = pushResponse.data;
            if (dataResponseContent == null) {
                PushLogUtils.LOG.e((Object)"parse self-destroying signedResponse failed");
                return null;
            }
            boolean isSignVerified = rsaEcsPKCS1Encrypter.verify(StringUtils.encodeBySHA256(crypter.base64Decode(dataResponseContent.data)), crypter.base64Decode(dataResponseContent.sign));
            if (!isSignVerified) {
                PushLogUtils.LOG.e((Object)"self-destroying verify signature failed");
                return null;
            }
            String content = new String(crypter.decrypt(crypter.base64Decode(dataResponseContent.data)));
            SelfDestroyInfo configInfo = (SelfDestroyInfo)Tson.fromJson((String)content, SelfDestroyInfo.class);
            if (configInfo == null) {
                PushLogUtils.LOG.e((Object)"parse self-destroying info failed");
                return null;
            }
            return configInfo;
        }
        catch (Exception e) {
            PushLogUtils.LOG.w((Object)("self-destroying Exception: " + e.getMessage()));
            return null;
        }
    }

    void updateTopic(String topic, String action, ITopicListener listener) {
        PushRequest.TopicContentData dataContent = this.generateTopicInstance(topic, action);
        PushLogUtils.LOG.d((Object)("topics request data: " + dataContent.toString()));
        AesCbcPKCS5RandomCrypter crypter = new AesCbcPKCS5RandomCrypter();
        RsaEcsPKCS1Encrypter rsaEcsPKCS1Encrypter = new RsaEcsPKCS1Encrypter("MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBAKEaYIhDF/GSQZagVqAOo7UU/GqDjQBU5muTCS6qPMfAdtKOzbhRpNCJA/ZmgBxPhc8RVLPO9yiJn5g+hy+tz3cCAwEAAQ==");
        PushRequest request = new PushRequest();
        try {
            String data64 = crypter.base64Encode(crypter.encrypt(Tson.toJson((Object)dataContent)));
            String key64 = crypter.base64Encode(rsaEcsPKCS1Encrypter.encrypt(crypter.getPass()));
            request.data = data64;
            request.key = key64;
            byte[] uploadData = Tson.toJson((Object)request).getBytes();
            String url = PushIml.getReportUrl();
            if (TextUtils.isEmpty((CharSequence)url)) {
                return;
            }
            url = url + PushUtils.getAppId() + "/topics";
            PushLogUtils.LOG.d((Object)("topics request url:" + url));
            byte[] response = HttpUtils.makePostRequest(url, uploadData);
            if (response == null) {
                PushLogUtils.LOG.e((Object)"the response data is empty");
                this.onUpdateTopicFail(listener, "the response data is empty");
                return;
            }
            PushResponse pushResponse = (PushResponse)Tson.fromJson((String)new String(response), PushResponse.class);
            if (pushResponse == null) {
                PushLogUtils.LOG.e((Object)"parse topics BaseResponse failed");
                this.onUpdateTopicFail(listener, "parse topics BaseResponse failed");
                return;
            }
            if (pushResponse.status != 200) {
                PushLogUtils.LOG.e((Object)("topics BaseResponse status error, status:" + pushResponse.status + ", " + pushResponse.message));
                this.onUpdateTopicFail(listener, "topics BaseResponse status error, status:" + pushResponse.status + ", " + pushResponse.message);
                return;
            }
            if (listener != null) {
                listener.onSuccess();
            }
        }
        catch (Exception e) {
            PushLogUtils.LOG.w((Object)("topics Exception: " + e.getMessage()));
            this.onUpdateTopicFail(listener, "topics Exception: " + e.getMessage());
        }
    }

    private <T> void onUpdateTopicFail(ITopicListener listener, String msg) {
        if (listener != null) {
            listener.onFail(msg);
        }
    }

    private PushRequest.ReportContentData generateReportInstance() {
        PushRequest.ReportContentData dataContent = new PushRequest.ReportContentData();
        Locale locale = Locale.getDefault();
        dataContent.vaid = AthenaAnalytics.getAppVAID((Context)CoreUtil.getContext(), (boolean)true);
        dataContent.gaid = DeviceInfo.getGAIdInThread();
        dataContent.sdkVersion = "1.8.8.07";
        dataContent.sdkVersionCode = 17004;
        dataContent.pkg = DeviceUtils.getPackageName();
        dataContent.confVersion = PushConfigUtils.getConfigVersion();
        dataContent.whitelistVersion = WhiteListUtils.getWhiteListVersion();
        if (PushIml.isSystemChannel()) {
            dataContent.platVer = PushIml.getPlatformSdkVersion();
        }
        boolean isWithDetail = PushRepository.getInstance().getSpValue("push_is_report_detail", true);
        if (TextUtils.isEmpty((CharSequence)dataContent.clientId)) {
            isWithDetail = true;
        }
        dataContent.withDetail = isWithDetail;
        if (isWithDetail) {
            dataContent.aid = DeviceInfo.getAndroidID();
            dataContent.brand = TextUtils.isEmpty((CharSequence)Build.BRAND) ? Build.BRAND : Build.BRAND.toUpperCase().replace(" ", "");
            dataContent.androidVersion = Build.VERSION.RELEASE;
            dataContent.cid = 0;
            dataContent.lac = 0;
            dataContent.language = locale.getLanguage() == null ? null : locale.getLanguage().toLowerCase();
            dataContent.mcc = DeviceUtils.getMCC();
            dataContent.mnc = DeviceUtils.getMNC();
            dataContent.model = TextUtils.isEmpty((CharSequence)Build.MODEL) ? Build.MODEL : Build.MODEL.toUpperCase().replace(" ", "");
            dataContent.network = NetUtils.getCurrentNetworkType();
            dataContent.osVersion = String.valueOf(Build.VERSION.SDK_INT);
            dataContent.appVersion = DeviceUtils.getVersionName(CoreUtil.getContext());
            dataContent.appVersionCode = AppUtil.getVersionCode();
            dataContent.token = PushRepository.getInstance().getSpValue("push_token", "");
            dataContent.country = locale.getCountry() == null ? null : locale.getCountry().toUpperCase();
        }
        PushIml.setAppsContent(dataContent);
        dataContent.appId = PushUtils.getAppId();
        dataContent.appKey = PushUtils.getAppKey();
        dataContent.clientId = PushRepository.getInstance().getSpValue("push_client_id", "");
        dataContent.noticeEnable = NotificationAssistUtils.isOpenNotification(CoreUtil.getContext()) ? 1 : 2;
        return dataContent;
    }

    private PushRequest.SelfDestroyContentData generateSelfDestroyInstance() {
        PushRequest.SelfDestroyContentData dataContent = new PushRequest.SelfDestroyContentData();
        dataContent.appId = PushUtils.getAppId();
        dataContent.appKey = PushUtils.getAppKey();
        dataContent.clientId = PushRepository.getInstance().getSpValue("push_client_id", "");
        dataContent.sdkVersion = "1.8.8.07";
        dataContent.sdkVersionCode = 17004;
        dataContent.appVersion = DeviceUtils.getVersionName(CoreUtil.getContext());
        dataContent.appVersionCode = AppUtil.getVersionCode();
        dataContent.confVersion = PushConfigUtils.getConfigVersion();
        dataContent.whitelistVersion = WhiteListUtils.getWhiteListVersion();
        return dataContent;
    }

    private PushRequest.TopicContentData generateTopicInstance(String topic, String action) {
        PushRequest.TopicContentData dataContent = new PushRequest.TopicContentData();
        dataContent.clientId = PushRepository.getInstance().getSpValue("push_client_id", "");
        dataContent.gaid = DeviceInfo.getGAIdInThread();
        dataContent.appId = PushUtils.getAppId();
        dataContent.appKey = PushUtils.getAppKey();
        dataContent.appVersion = AppUtil.getVersionName();
        dataContent.appVersionCode = AppUtil.getVersionCode();
        dataContent.sdkVersion = "1.8.8.07";
        dataContent.sdkVersionCode = 17004;
        if (!TextUtils.isEmpty((CharSequence)topic)) {
            dataContent.topics = new ArrayList();
            dataContent.topics.add(topic.toLowerCase());
        }
        dataContent.action = action;
        return dataContent;
    }
}

