/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.broadcast;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.transsion.push.PushManager;
import com.transsion.push.tracker.Tracker;
import com.transsion.push.utils.NotificationHelper;
import com.transsion.push.utils.PushLogUtils;
import com.transsion.push.utils.ServiceUtils;

public class HandlerBroadcastReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        PushManager.getInstance().init(context.getApplicationContext());
        Tracker.getInstance().init();
        PushLogUtils.LOG.d((Object)("receive messages,action:" + intent.getAction()));
        if ((context.getPackageName() + ".push.action").equals(intent.getAction())) {
            NotificationHelper.handlerClick(context, intent);
        } else if ("tpush.intent.action.TPUSH_MSG_RECEIVER".equals(intent.getAction())) {
            this.handlerReceiverMessage(context, intent);
        }
    }

    private void handlerReceiverMessage(Context context, Intent intent) {
        try {
            Bundle bundle = new Bundle();
            bundle.putString("message", intent.getStringExtra("message"));
            bundle.putString("service_type", "message");
            ServiceUtils.startTargetIntentService(context.getApplicationContext(), bundle);
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("e:" + e.getMessage()));
        }
    }
}

