/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.provider;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import androidx.annotation.Nullable;
import com.transsion.push.utils.PushLogUtils;

final class ProviderDbHelper
extends SQLiteOpenHelper {
    private static final String DB_NAME = "push_provider.db";
    private static final int DB_VERSION = 2;
    static final String TABLE_ACTIVE = "active";
    static final String TABLE_CONFIG = "config";
    private static final String ALTER_ACTIVE_TABLE_V2_1 = "ALTER TABLE active ADD COLUMN vaid TEXT";
    private static final String DROP_ACTIVE_TABLE = "DROP TABLE active";

    public ProviderDbHelper(@Nullable Context context) {
        super(context, DB_NAME, null, 2);
    }

    public void onCreate(SQLiteDatabase db) {
        try {
            db.beginTransaction();
            this.createActiveTable(db);
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
        }
        finally {
            db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        PushLogUtils.LOG.e((Object)("Upgrading app, replacing twibida DB oldVersion = " + oldVersion));
        try {
            db.beginTransaction();
            try {
                if (oldVersion < 2) {
                    db.execSQL(ALTER_ACTIVE_TABLE_V2_1);
                }
            }
            catch (SQLiteException e) {
                PushLogUtils.LOG.e((Object)Log.getStackTraceString((Throwable)e));
                db.execSQL(DROP_ACTIVE_TABLE);
                this.createActiveTable(db);
            }
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)e.toString());
        }
        finally {
            db.endTransaction();
        }
    }

    private void createActiveTable(SQLiteDatabase db) {
        StringBuilder buffer = new StringBuilder("create table ");
        buffer.append(TABLE_ACTIVE);
        buffer.append("(");
        buffer.append("pkg");
        buffer.append(" text PRIMARY KEY, ");
        buffer.append("appId");
        buffer.append(" text, ");
        buffer.append("appKey");
        buffer.append(" text, ");
        buffer.append("vaid");
        buffer.append(" text, ");
        buffer.append("token");
        buffer.append(" text, ");
        buffer.append("update_time");
        buffer.append(" long, ");
        buffer.append("noticeEnable");
        buffer.append(" integer, ");
        buffer.append("sdkVersion");
        buffer.append(" text, ");
        buffer.append("sdkVersionCode");
        buffer.append(" integer)");
        db.execSQL(buffer.toString());
    }
}

