/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.provider;

import android.content.ContentValues;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Build;
import com.transsion.push.bean.PushAppInfo;
import com.transsion.push.provider.ProviderDbHelper;
import com.transsion.push.utils.PushLogUtils;
import java.util.ArrayList;
import java.util.List;

public final class ProviderDbManager {
    private ProviderDbHelper mProviderDbHelper;
    private SQLiteDatabase mDatabase;

    public static ProviderDbManager getInstance() {
        return Holder.INSTANCE;
    }

    private ProviderDbManager() {
    }

    public void init(Context context) {
        this.mProviderDbHelper = new ProviderDbHelper(context);
    }

    public int updateActive(ContentValues values) {
        try {
            PushLogUtils.LOG.d((Object)("update active app value:" + values));
            this.mDatabase = this.mProviderDbHelper.getWritableDatabase();
            int row = (int)this.mDatabase.replace("active", null, values);
            PushLogUtils.LOG.d((Object)"update active app success");
            return row;
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("update active app fail, e:" + e.getMessage()));
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<PushAppInfo> queryActives() {
        Cursor cursor;
        block6: {
            PushLogUtils.LOG.d((Object)"query actives");
            this.mDatabase = this.mProviderDbHelper.getReadableDatabase();
            cursor = null;
            String sql = "select * from active";
            cursor = this.mDatabase.rawQuery(sql, null);
            if (cursor != null) break block6;
            ArrayList<PushAppInfo> arrayList = null;
            this.releaseCursor(cursor);
            return arrayList;
        }
        try {
            ArrayList<PushAppInfo> appInfos = new ArrayList<PushAppInfo>();
            while (cursor.moveToNext()) {
                PushAppInfo info = new PushAppInfo();
                info.pkg = cursor.getString(cursor.getColumnIndex("pkg"));
                info.appId = cursor.getString(cursor.getColumnIndex("appId"));
                info.appKey = cursor.getString(cursor.getColumnIndex("appKey"));
                info.vaid = cursor.getString(cursor.getColumnIndex("vaid"));
                info.token = cursor.getString(cursor.getColumnIndex("token"));
                info.sdkVersion = cursor.getString(cursor.getColumnIndex("sdkVersion"));
                info.sdkVersionCode = cursor.getInt(cursor.getColumnIndex("sdkVersionCode"));
                info.updateTime = cursor.getLong(cursor.getColumnIndex("update_time"));
                info.noticeEnable = cursor.getInt(cursor.getColumnIndex("noticeEnable"));
                appInfos.add(info);
            }
            PushLogUtils.LOG.d((Object)("queryActives appInfos:" + appInfos));
            ArrayList<PushAppInfo> arrayList = appInfos;
            this.releaseCursor(cursor);
            return arrayList;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                this.releaseCursor(cursor);
            }
            catch (Throwable throwable) {
                this.releaseCursor(cursor);
                throw throwable;
            }
        }
        return null;
    }

    public int deleteActiveApp(String selection, String[] selectionArgs) {
        try {
            if (selectionArgs != null && selectionArgs.length > 0) {
                PushLogUtils.LOG.d((Object)("provider delete active app pkg:" + selectionArgs[0]));
            }
            this.mDatabase = this.mProviderDbHelper.getWritableDatabase();
            return this.mDatabase.delete("active", selection, selectionArgs);
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("delete active app fail, e:" + e.getMessage()));
            return -1;
        }
    }

    public void checkAppInfos(Context context, List<PushAppInfo> appInfos) {
        if (appInfos == null || appInfos.size() <= 0) {
            return;
        }
        ArrayList<PushAppInfo> deletes = new ArrayList<PushAppInfo>();
        for (PushAppInfo info : appInfos) {
            try {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(info.pkg, 0);
                info.appVersion = packageInfo.versionName;
                if (Build.VERSION.SDK_INT >= 28) {
                    info.appVersionCode = packageInfo.getLongVersionCode();
                    continue;
                }
                info.appVersionCode = packageInfo.versionCode;
            }
            catch (Exception e) {
                deletes.add(info);
            }
        }
        appInfos.removeAll(deletes);
        PushLogUtils.LOG.d((Object)("check app info, remove app count:" + deletes.size()));
        if (deletes.size() > 0) {
            for (PushAppInfo info : deletes) {
                this.deleteActiveApp("pkg  = ? ", new String[]{info.pkg});
            }
        }
    }

    private void releaseCursor(Cursor cursor) {
        try {
            if (cursor != null) {
                cursor.close();
            }
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("close db fail, e:" + e.getMessage()));
        }
    }

    private static final class Holder {
        private static final ProviderDbManager INSTANCE = new ProviderDbManager();

        private Holder() {
        }
    }
}

