/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.utils;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.messaging.FirebaseMessaging;
import com.transsion.push.config.PushRepository;
import com.transsion.push.utils.PushLogUtils;
import com.transsion.push.utils.PushUtils;
import com.transsion.push.utils.ThreadManager;

public final class FirebaseUtils {
    public static void updateToken() {
        if (!FirebaseUtils.isFirebaseIntegrated()) {
            PushLogUtils.LOG.d((Object)"firebase not integrated");
            return;
        }
        try {
            FirebaseMessaging.getInstance().getToken().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<String>(){

                public void onComplete(@NonNull Task<String> task) {
                    if (!task.isSuccessful()) {
                        return;
                    }
                    String token = (String)task.getResult();
                    if (!TextUtils.isEmpty((CharSequence)token)) {
                        PushUtils.updateToken(token);
                    }
                }
            });
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("updateToken fail" + e));
        }
    }

    public static void updateToken(final IFirebaseTokenListener listener) {
        ThreadManager.executeInBackground(new Runnable(){

            @Override
            public void run() {
                if (!FirebaseUtils.isFirebaseIntegrated()) {
                    PushLogUtils.LOG.d((Object)"firebase  is not integrated");
                    return;
                }
                try {
                    FirebaseMessaging.getInstance().getToken().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<String>(){

                        public void onComplete(@NonNull Task<String> task) {
                            if (!task.isSuccessful()) {
                                return;
                            }
                            String token = (String)task.getResult();
                            if (!TextUtils.isEmpty((CharSequence)token)) {
                                PushRepository.getInstance().putSpValue("push_token", token);
                                if (listener != null) {
                                    listener.onSuccess();
                                }
                            } else {
                                PushLogUtils.LOG.d((Object)"firebase  token is empty");
                                if (listener != null) {
                                    listener.onFail();
                                }
                            }
                        }
                    });
                    return;
                }
                catch (Exception e) {
                    PushLogUtils.LOG.e((Object)e);
                    if (listener != null) {
                        listener.onFail();
                    }
                    return;
                }
            }
        });
    }

    private static boolean isFirebaseIntegrated() {
        try {
            Class.forName("com.google.firebase.FirebaseApp");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static interface IFirebaseTokenListener {
        public void onSuccess();

        public void onFail();
    }
}

