/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.utils;

import com.transsion.push.utils.PushLogUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpUtils {
    private static final int COPY_BUF_SIZE = 8024;

    public static byte[] makePostRequest(String stringUrl, byte[] payload) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(stringUrl).openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(30000);
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("User-Agent", "push");
        OutputStream os = conn.getOutputStream();
        os.write(payload);
        os.flush();
        PushLogUtils.LOG.d((Object)("response code:" + conn.getResponseCode()));
        if (conn.getResponseCode() >= 400) {
            return null;
        }
        return HttpUtils.toBytes(conn.getInputStream());
    }

    public static boolean makeGetRequest(String stringUrl) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(stringUrl).openConnection();
        conn.setRequestMethod("GET");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(30000);
        OutputStream os = conn.getOutputStream();
        os.flush();
        PushLogUtils.LOG.d((Object)("response code:" + conn.getResponseCode()));
        return conn.getResponseCode() == 200;
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        return HttpUtils.copy(input, output, 8024);
    }

    public static long copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        byte[] buffer = new byte[bufferSize];
        long count = 0L;
        int read;
        while ((read = input.read(buffer)) > 0) {
            output.write(buffer, 0, read);
            count += (long)read;
        }
        return count;
    }

    public static byte[] toBytes(InputStream is) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        HttpUtils.copy(is, output);
        return output.toByteArray();
    }
}

