/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.broadcast;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.transsion.core.CoreUtil;
import com.transsion.json.Tson;
import com.transsion.push.PushManager;
import com.transsion.push.bean.PushMessage;
import com.transsion.push.tracker.Tracker;
import com.transsion.push.utils.PushLogUtils;
import com.transsion.push.utils.PushUtils;
import com.transsion.push.utils.ServiceUtils;
import com.transsion.push.utils.StringUtils;
import java.util.Map;

public class FCMMessageService
extends FirebaseMessagingService {
    public void onMessageReceived(RemoteMessage remoteMessage) {
        PushLogUtils.LOG.d((Object)("Receiving FCM messages by FirebaseMessagingService:" + remoteMessage.getData()));
        super.onMessageReceived(remoteMessage);
        Context context = this.getApplicationContext();
        CoreUtil.init((Context)context);
        PushManager.getInstance().init(context.getApplicationContext());
        Tracker.getInstance().trackBroadcastInfoeye();
        Tracker.getInstance().trackBroadcastGcmInfoeye();
        PushMessage message = this.remoteMessageToPushMessage(remoteMessage);
        PushLogUtils.LOG.d((Object)("Receiving FCM messages packageName:" + context.getPackageName() + "  " + message));
        if (!this.checkPushMessage(message)) {
            return;
        }
        Tracker.getInstance().trackMessage(message.messageId, message.type, message.timeStamp, "all", 0);
        String messageContent = null;
        try {
            messageContent = Tson.toJson((Object)message);
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("Receiving FCM messages to messageContent fail, e:" + e.getMessage()));
        }
        if (TextUtils.isEmpty((CharSequence)messageContent)) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("message", messageContent);
        bundle.putString("service_type", "message");
        ServiceUtils.startTargetIntentService(context, bundle);
    }

    public void onNewToken(String token) {
        super.onNewToken(token);
        PushLogUtils.LOG.d((Object)("FCM MessageService onNewToken: " + token));
        if (!TextUtils.isEmpty((CharSequence)token)) {
            PushUtils.updateToken(token);
        }
    }

    private PushMessage remoteMessageToPushMessage(RemoteMessage remoteMessage) {
        PushMessage pushMessage = new PushMessage();
        Map data = remoteMessage.getData();
        if (data == null || data.isEmpty()) {
            return pushMessage;
        }
        pushMessage.messageId = StringUtils.stringToLong((String)data.get("tcm_msg_id"));
        pushMessage.type = StringUtils.stringToInt((String)data.get("tcm_msg_type"));
        pushMessage.pkgId = (String)data.get("tcm_msg_pkg");
        pushMessage.packageName = (String)data.get("tcm_msg_pkgname");
        try {
            pushMessage.rpkg = CoreUtil.getContext().getPackageName();
        }
        catch (Exception e) {
            pushMessage.rpkg = "";
        }
        pushMessage.notiType = StringUtils.stringToInt((String)data.get("noti_type"));
        pushMessage.notiExType = StringUtils.getNotiExType((String)data.get("noti_ex_type"));
        pushMessage.msgTtl = StringUtils.stringToInt((String)data.get("tcm_msg_ttl"));
        pushMessage.ignoreExpire = StringUtils.stringToInt((String)data.get("noti_ignore_expire"));
        pushMessage.groupId = (String)data.get("noti_group_id");
        pushMessage.groupMaxCount = (String)data.get("noti_group_max_count");
        pushMessage.notiTitle = (String)data.get("noti_title");
        pushMessage.notiDes = (String)data.get("noti_desc");
        pushMessage.notiImg = (String)data.get("noti_img");
        pushMessage.notiIcon = (String)data.get("noti_icon");
        pushMessage.notiBtn = (String)data.get("noti_btn");
        pushMessage.notiImgEx = (String)data.get("noti_img_ex");
        pushMessage.notiTitleEx = (String)data.get("noti_title_ex");
        pushMessage.notiTxtEx = (String)data.get("noti_txt_ex");
        pushMessage.notiOpenType = StringUtils.stringToInt((String)data.get("noti_open_type"));
        pushMessage.notiOpenContent = (String)data.get("noti_open_content");
        pushMessage.transData = StringUtils.getBase64Data((String)data.get("trans_data"));
        pushMessage.timeStamp = (String)data.get("tcm_msg_timestamp");
        pushMessage.notiSmallIcon = (String)data.get("noti_small_icon");
        pushMessage.displayPolicy = StringUtils.stringToInt((String)data.get("display_policy"));
        pushMessage.appName = (String)data.get("app_name");
        pushMessage.layoutStyleId = StringUtils.stringToInt((String)data.get("noti_layout_id"));
        pushMessage.channelId = (String)data.get("noti_channel_id");
        pushMessage.channelName = (String)data.get("noti_channel_name");
        pushMessage.iconColor = (String)data.get("noti_small_icon_color");
        pushMessage.impUrlList = (String)data.get("noti_imp_urls");
        pushMessage.clickUrlList = (String)data.get("noti_click_urls");
        pushMessage.isHeadsUp = StringUtils.stringToInt((String)data.get("noti_is_headsup"));
        pushMessage.retraceMsgId = StringUtils.stringToLong((String)data.get("tcm_target_msg_id"));
        pushMessage.notiExtensionBtn = (String)data.get("noti_btn_ex");
        pushMessage.notiBtnBgColor = (String)data.get("noti_btn_background_color");
        pushMessage.notiBtnTxtColor = (String)data.get("noti_btn_word_color");
        pushMessage.notiOptionalIcon = (String)data.get("noti_optional_icon");
        pushMessage.priority = StringUtils.stringToInt((String)data.get("tcm_msg_priority"));
        pushMessage.sdkShow = StringUtils.stringToInt((String)data.get("tcm_msg_sdkshow"));
        pushMessage.floatNotice = (String)data.get("noti_float");
        pushMessage.materialId = (String)data.get("tcm_material_id");
        pushMessage.seq = (String)data.get("tcm_seq");
        pushMessage.sourceType = (String)data.get("tcm_source_type");
        pushMessage.scheduleDate = (String)data.get("tcm_schedule_date");
        pushMessage.tag = (String)data.get("tcm_tag");
        return pushMessage;
    }

    private boolean checkPushMessage(PushMessage message) {
        return message.messageId > 0L && message.type > 0 && !TextUtils.isEmpty((CharSequence)message.pkgId);
    }
}

