/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.provider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.transsion.push.config.PushRepository;
import com.transsion.push.provider.ProviderDbManager;
import com.transsion.push.utils.PushConfigUtils;
import com.transsion.push.utils.PushLogUtils;
import java.util.HashSet;
import java.util.Set;

public class PushContentProvider
extends ContentProvider {
    private static final UriMatcher MATCHER = new UriMatcher(-1);
    private static final String AUTHORITY = "com.transsion.tpush.tpms.PushContentProvider";
    private static final int CODE_ACTIVE = 1;
    private static final int CODE_CONFIG = 2;

    public boolean onCreate() {
        ProviderDbManager.getInstance().init(this.getContext());
        return true;
    }

    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        try {
            if (PushConfigUtils.isSelfDestroy()) {
                PushLogUtils.LOG.d((Object)"PushContentProvider query, system channel self-destroy");
                return null;
            }
            switch (MATCHER.match(uri)) {
                case 1: {
                    PushLogUtils.LOG.d((Object)"PushContentProvider query ----------> active");
                    break;
                }
                case 2: {
                    PushLogUtils.LOG.d((Object)"PushContentProvider query ----------> config");
                    if (projection == null || projection.length <= 0) {
                        return null;
                    }
                    return this.getDestroyInfo(projection[0]);
                }
            }
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("query error, e:" + e.getMessage()));
        }
        return null;
    }

    @Nullable
    public String getType(@NonNull Uri uri) {
        return null;
    }

    @Nullable
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        PushLogUtils.LOG.d((Object)("PushContentProvider insert ---------->values:" + values));
        return null;
    }

    public int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        if (PushConfigUtils.isSelfDestroy()) {
            PushLogUtils.LOG.d((Object)"PushContentProvider delete, system channel self-destroy");
            return -1;
        }
        return ProviderDbManager.getInstance().deleteActiveApp(selection, selectionArgs);
    }

    public int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        PushLogUtils.LOG.d((Object)"PushContentProvider update ---------->");
        if (PushConfigUtils.isSelfDestroy()) {
            PushLogUtils.LOG.d((Object)"PushContentProvider update, system channel self-destroy");
            return -1;
        }
        switch (MATCHER.match(uri)) {
            case 1: {
                PushLogUtils.LOG.d((Object)"PushContentProvider update ----------> active");
                return ProviderDbManager.getInstance().updateActive(values);
            }
            case 2: {
                PushLogUtils.LOG.d((Object)"PushContentProvider update ----------> config");
                break;
            }
        }
        return -1;
    }

    private Cursor getDestroyInfo(String appId) {
        if (TextUtils.isEmpty((CharSequence)appId)) {
            return null;
        }
        MatrixCursor cursor = new MatrixCursor(new String[]{"destroy", "syncInfoInterval"}, 1);
        Set set = PushRepository.getInstance().getSpValue("destroy_app_ids", new HashSet());
        Object[] destroyInfo = new Object[]{set.contains(appId) ? 2 : 1, PushRepository.getInstance().getSpValue("sync_interval", 86400)};
        PushLogUtils.LOG.d((Object)("destroy info destroy:" + destroyInfo[0] + ", interval:" + destroyInfo[1]));
        cursor.addRow(destroyInfo);
        return cursor;
    }

    static {
        MATCHER.addURI(AUTHORITY, "active", 1);
        MATCHER.addURI(AUTHORITY, "config", 2);
    }
}

