/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.service;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.ContentResolver;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Build;
import android.provider.Settings;
import android.service.notification.StatusBarNotification;
import android.text.TextUtils;
import android.util.Log;
import com.transsion.core.CoreUtil;
import com.transsion.core.utils.AppUtil;
import com.transsion.core.utils.SharedPreferencesUtil;
import com.transsion.push.PushManager;
import com.transsion.push.bean.PushMessage;
import com.transsion.push.config.PushRepository;
import com.transsion.push.tracker.Tracker;
import com.transsion.push.utils.BitmapDownloadUtils;
import com.transsion.push.utils.DeviceUtils;
import com.transsion.push.utils.NotificationAssistUtils;
import com.transsion.push.utils.ProviderUtils;
import com.transsion.push.utils.PushConfigUtils;
import com.transsion.push.utils.PushIml;
import com.transsion.push.utils.PushLogUtils;
import com.transsion.push.utils.PushUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public final class PushServiceHelper {
    private static final Object mutexLock = new Object();

    public static void onHandleIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        String type = intent.getStringExtra("service_type");
        PushLogUtils.LOG.d((Object)("PushJobIntentService ---> onHandleWork, type:" + type));
        if (type == null) {
            return;
        }
        switch (type) {
            case "init": {
                break;
            }
            case "token": {
                PushServiceHelper.onHandleUpdateToken(intent);
                break;
            }
            case "message": {
                PushServiceHelper.onHandleTargetMessage(intent);
                break;
            }
            case "sync_config": {
                PushServiceHelper.onHandleSyncConfig(intent);
                break;
            }
            case "force_update": {
                PushServiceHelper.onHandleForceUpdate();
                break;
            }
            default: {
                PushLogUtils.LOG.w((Object)"service type error");
            }
        }
    }

    private static void onHandleChannelMessage(Intent intent) {
        if (intent == null) {
            return;
        }
        PushIml.onHandleChannelMessage(intent);
    }

    private static void onHandleSyncSelfDestroying() {
        try {
            long diff = System.currentTimeMillis() - PushRepository.getInstance().getSpValue("push_self_destroying_time", 0L);
            if (diff > 0L) {
                if (PushIml.isSystemChannel()) {
                    PushRepository.getInstance().syncSelfDestroying();
                } else if (!ProviderUtils.updateConfig(CoreUtil.getContext())) {
                    PushRepository.getInstance().syncSelfDestroying();
                }
            }
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("handle sync self-destroying exception,e:" + e.getMessage()));
        }
    }

    private static void onHandleForceUpdate() {
        try {
            if (PushRepository.getInstance().isReported()) {
                return;
            }
            PushRepository.getInstance().syncActive();
            PushLogUtils.LOG.d((Object)" active reporting");
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("handle sync active exception,e:" + e.getMessage()));
        }
    }

    private static void onHandleSyncActive() {
        Tracker.getInstance().trackActiveSyncProcess();
        PushLogUtils.LOG.d((Object)"onHandleSyncActive");
        if (PushUtils.isForceUpdate()) {
            PushLogUtils.LOG.d((Object)"onHandleSyncActive force update");
            PushServiceHelper.onHandleForceUpdate();
            return;
        }
        try {
            if (PushUtils.isSyncTpmsActive()) {
                PushLogUtils.LOG.d((Object)"tpms sync");
                if (ProviderUtils.updateActive(CoreUtil.getContext())) {
                    ProviderUtils.updateConfig(CoreUtil.getContext());
                    PushRepository.getInstance().saveTpmsReportTime(System.currentTimeMillis() + 86400000L);
                }
            }
            if (PushUtils.isSyncActive() && !ProviderUtils.updateActive(CoreUtil.getContext())) {
                PushRepository.getInstance().syncActive();
            }
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("handle sync active exception,e:" + e.getMessage()));
        }
    }

    private static void onHandleSyncConfig(Intent intent) {
        if (intent == null) {
            return;
        }
        PushServiceHelper.onHandleSyncActive();
    }

    private static void onHandleMsgClick(Intent intent) {
        if (intent == null) {
            return;
        }
        long clickMsgId = intent.getLongExtra("message_id", -1L);
        Tracker.getInstance().trackClick(clickMsgId);
    }

    private static void onHandleMsgShow(Intent intent) {
        if (intent == null) {
            return;
        }
        long showMsgId = intent.getLongExtra("message_id", -1L);
        int showStatus = intent.getIntExtra("message_show_status", -1);
        try {
            Tracker.getInstance().trackShow(showMsgId, 2, String.valueOf(System.currentTimeMillis()), NotificationAssistUtils.isOpenNotification(CoreUtil.getContext()), showStatus);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void onHandleMsgConversion(Intent intent) {
        if (intent == null) {
            return;
        }
        long showMsgId = intent.getLongExtra("message_id", -1L);
        Tracker.getInstance().trackConversion(showMsgId);
    }

    private static void onHandleMsgArrive(Intent intent) {
        if (intent == null) {
            return;
        }
        long msgId = intent.getLongExtra("message_id", -1L);
        Tracker.getInstance().trackTarget(msgId, 2, "", "", "success");
    }

    private static void onHandleTargetMessage(Intent intent) {
        PushLogUtils.LOG.d((Object)"onHandleTargetMessage--->");
        if (intent == null) {
            Tracker.getInstance().trackHandleMsgErrorInfoeye(0L, "intent_null");
            PushLogUtils.LOG.d((Object)"onHandleTargetMessage---> intent is null");
            return;
        }
        PushMessage message = PushUtils.getIntentMessage(intent);
        if (message == null) {
            Tracker.getInstance().trackHandleMsgErrorInfoeye(0L, "msg_null");
            PushLogUtils.LOG.d((Object)"onHandleTargetMessage---> message is null");
            return;
        }
        if (PushConfigUtils.isSelfDestroy()) {
            Tracker.getInstance().trackHandleMsgErrorInfoeye(message.messageId, "self_destroy");
            PushLogUtils.LOG.w((Object)"push self-destroying");
            return;
        }
        if (!PushUtils.checkMessage(message, 1)) {
            Tracker.getInstance().trackHandleMsgErrorInfoeye(message.messageId, "check_fail");
            PushLogUtils.LOG.d((Object)"onHandleTargetMessage---> checkMessage return ");
            return;
        }
        if (PushUtils.retraceMessage(message)) {
            Tracker.getInstance().trackHandleMsgErrorInfoeye(message.messageId, "msg_retreat");
            PushLogUtils.LOG.d((Object)("onHandleTargetMessage---> retraceMessage return, retrace msgId:" + message.retraceMsgId));
            return;
        }
        PushUtils.setMessageMap(message);
        Tracker.getInstance().trackTarget(message.messageId, message.type, message.timeStamp, message.rpkg, "success", message);
        PushUtils.setMessageHandled(message.messageId);
        PushLogUtils.LOG.d((Object)("onHandleTargetMessage---> type:" + message.type));
        switch (message.type) {
            case 1: 
            case 5: 
            case 6: {
                if (message.sdkShow == 0) {
                    PushLogUtils.LOG.d((Object)"sdkShow no show");
                    if (PushManager.getInstance().getPushListener() != null) {
                        PushManager.getInstance().getPushListener().onPushReceive(message.messageId, message, message.priority);
                    }
                    Tracker.getInstance().trackHandleMsgErrorInfoeye(message.messageId, "sdk_show_fail");
                    return;
                }
                long timeNow = System.currentTimeMillis();
                try {
                    PushLogUtils.LOG.d((Object)("message ignoreExpire? " + message.ignoreExpire));
                    PushLogUtils.LOG.d((Object)("isTimeAutomatic: " + PushServiceHelper.isTimeAutomatic()));
                    PushLogUtils.LOG.d((Object)("message schedule time: " + message.getTimeStamp()));
                    PushLogUtils.LOG.d((Object)("message delay: " + (timeNow - Long.parseLong(message.getTimeStamp()))));
                    PushLogUtils.LOG.d((Object)("message ttl: " + (long)message.getMsgTtl() * 1000L));
                    if (message.ignoreExpire == 0) {
                        PushLogUtils.LOG.d((Object)"message expiration check");
                        if (PushServiceHelper.isTimeAutomatic() && timeNow - Long.parseLong(message.getTimeStamp()) > (long)message.getMsgTtl() * 1000L) {
                            PushLogUtils.LOG.d((Object)"message expired, no show");
                            Tracker.getInstance().trackShow(message.messageId, message.type, message.timeStamp, true, 999);
                            return;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!PushManager.getInstance().getNotificationSwitch()) {
                    Tracker.getInstance().trackHandleMsgErrorInfoeye(message.messageId, "noti_off");
                    PushLogUtils.LOG.d((Object)"notification switch is off, do not show noti");
                    return;
                }
                if (BitmapDownloadUtils.checkIsDownloadBitmap(message)) {
                    BitmapDownloadUtils.downloadBitmap(message, new BitmapDownloadUtils.BitmapDownloadListener(){

                        @Override
                        public void downloadComplete(PushMessage message, HashMap<String, Bitmap> images) {
                            PushServiceHelper.showNotification(message, images);
                        }
                    });
                    break;
                }
                PushServiceHelper.showNotification(message, null);
                break;
            }
            case 2: {
                PushServiceHelper.transmitMessage(message);
                break;
            }
            case 7: {
                break;
            }
            default: {
                PushLogUtils.LOG.w((Object)"Display message, message type is not supported");
            }
        }
    }

    private static void showNotification(PushMessage message, HashMap<String, Bitmap> images) {
        PushLogUtils.LOG.d((Object)("display messages\uff0cmessage\uff1a" + message));
        if (message == null) {
            return;
        }
        try {
            PushIml.sendNotification(message, images);
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("Notification show exception:" + e.getMessage()));
        }
    }

    private static synchronized void transmitMessage(PushMessage message) {
        try {
            if (TextUtils.isEmpty((CharSequence)message.packageName)) {
                message.packageName = AppUtil.getPkgName();
            }
            if (!message.packageName.equals(AppUtil.getPkgName())) {
                return;
            }
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("transmitMessage---> e:" + e.getMessage()));
            return;
        }
        if (PushManager.getInstance().getPushListener() != null) {
            PushManager.getInstance().getPushListener().onMessageReceive(message.messageId, message.transData, message.priority);
        } else {
            Log.e((String)"PUSH_", (String)"tpush listener is not registered");
        }
    }

    private static void sort(List<StatusBarNotification> notifications) {
        Collections.sort(notifications, new Comparator<StatusBarNotification>(){

            @Override
            public int compare(StatusBarNotification o1, StatusBarNotification o2) {
                return (int)(o2.getPostTime() - o1.getPostTime());
            }
        });
    }

    private static List<StatusBarNotification> getNotifications(String groupId, NotificationManager notificationManager) {
        if (Build.VERSION.SDK_INT < 23) {
            return null;
        }
        StatusBarNotification[] activeNotifications = notificationManager.getActiveNotifications();
        ArrayList<StatusBarNotification> notifications = new ArrayList<StatusBarNotification>();
        for (StatusBarNotification barNotification : activeNotifications) {
            Notification notification = barNotification.getNotification();
            if (notification == null || notification.extras == null || !notification.extras.getBoolean("extra_from_tpush_noti")) continue;
            if (notification.getGroup() == null && TextUtils.isEmpty((CharSequence)groupId)) {
                notifications.add(barNotification);
                continue;
            }
            if (notification.getGroup() == null || !notification.getGroup().equals(groupId)) continue;
            notifications.add(barNotification);
        }
        return notifications;
    }

    public static void handleMaxLimitMessage(PushMessage message, NotificationManager notificationManager) {
        if (message == null || notificationManager == null) {
            return;
        }
        int maxCount = 0;
        try {
            maxCount = Integer.parseInt(message.groupMaxCount);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (maxCount <= 0 || Build.VERSION.SDK_INT < 23) {
            return;
        }
        String groupId = message.groupId;
        List<StatusBarNotification> notifications = PushServiceHelper.getNotifications(groupId, notificationManager);
        if (notifications == null || notifications.size() < maxCount) {
            return;
        }
        int deleteCount = notifications.size() - maxCount;
        PushServiceHelper.sort(notifications);
        for (int i = 0; i <= deleteCount; ++i) {
            try {
                notificationManager.cancel(notifications.get(notifications.size() - 1 - i).getId());
                continue;
            }
            catch (Exception e) {
                PushLogUtils.LOG.e((Object)("handle max limit message fail, e:" + e.getMessage()));
            }
        }
    }

    private static boolean checkNotification(int id, List<StatusBarNotification> notifications) {
        for (StatusBarNotification notification : notifications) {
            if (notification.getId() != id) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onHandleUpdateToken(Intent intent) {
        Tracker.getInstance().trackTokenUpdateProcess("start");
        if (intent == null) {
            return;
        }
        String token = intent.getStringExtra("TOKEN");
        if (TextUtils.isEmpty((CharSequence)token)) {
            PushLogUtils.LOG.w((Object)"Initialize token to empty");
            return;
        }
        try {
            if (CoreUtil.getContext() == null) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        Object object = mutexLock;
        synchronized (object) {
            Log.d((String)"PUSH_", (String)("Initialize push_token\uff0c packageName:" + DeviceUtils.getPackageName() + ", token\uff1a" + token));
            String oldToken = PushRepository.getInstance().getSpValue("push_token", "");
            if (token.equals(oldToken) && !TextUtils.isEmpty((CharSequence)PushRepository.getInstance().getSpValue("push_client_id", ""))) {
                Tracker.getInstance().trackTokenUpdateProcess("same");
                PushLogUtils.LOG.d((Object)"token does not need to report without modification");
                PushUtils.sendCompleteBroadcast();
                SharedPreferencesUtil.getInstance((String)"sp_push").putLong("update_token_time", System.currentTimeMillis());
                return;
            }
            Tracker.getInstance().trackTokenUpdateProcess("update");
            PushLogUtils.LOG.d((Object)"token updated, do network request");
            try {
                SharedPreferencesUtil.getInstance((String)"sp_push").putLong("update_token_time", System.currentTimeMillis());
            }
            catch (Exception exception) {
                // empty catch block
            }
            PushRepository.getInstance().updateNewToken(token);
            PushServiceHelper.onHandleForceUpdate();
            try {
                ProviderUtils.updateActive(CoreUtil.getContext());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean isTimeAutomatic() {
        if (CoreUtil.getContext() == null) {
            return false;
        }
        return Settings.Global.getInt((ContentResolver)CoreUtil.getContext().getContentResolver(), (String)"auto_time", (int)0) == 1;
    }
}

