/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.tracker;

import android.content.Context;
import android.os.Bundle;
import com.transsion.athena.data.TrackData;
import com.transsion.core.CoreUtil;
import com.transsion.ga.AthenaAnalytics;
import com.transsion.push.PushManager;
import com.transsion.push.tracker.Tracker;
import com.transsion.push.utils.PushLogUtils;

class AthenaTracker {
    private static AthenaTracker instance = null;

    private AthenaTracker() {
    }

    public static AthenaTracker getInstance() {
        if (instance == null) {
            instance = new AthenaTracker();
        }
        return instance;
    }

    void init() {
        if (!this.isAthenaIntegrated()) {
            return;
        }
        AthenaAnalytics.init((Context)CoreUtil.getContext().getApplicationContext(), (String)"push", (int)1041, (boolean)false);
    }

    void track(Tracker.KEY key, Bundle bundle) {
        if (!this.isAthenaIntegrated()) {
            return;
        }
        if (!PushManager.getInstance().getIsSdkInitFinished()) {
            AthenaAnalytics.init((Context)CoreUtil.getContext().getApplicationContext(), (String)"push", (int)1041, (boolean)false);
        }
        try {
            this.printAthena(key, bundle);
            AthenaAnalytics.getInstance((int)key.tid).track(key.event, this.bundleToTrackData(bundle), key.tid);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void printAthena(Tracker.KEY trackerKey, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String key : bundle.keySet()) {
            sb.append(key).append(":").append(bundle.get(key)).append(", ");
        }
        PushLogUtils.LOG.d((Object)("Athena track event:" + trackerKey.event + ", tid:" + trackerKey.tid + ", " + sb.toString()));
    }

    private TrackData bundleToTrackData(Bundle bundle) {
        TrackData trackData = new TrackData();
        if (bundle == null) {
            return trackData;
        }
        for (String bundleKey : bundle.keySet()) {
            trackData.add(bundleKey, bundle.get(bundleKey) + "");
        }
        return trackData;
    }

    private boolean isAthenaIntegrated() {
        try {
            Class.forName("com.transsion.ga.AthenaAnalytics");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

