/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.tracker;

import android.app.Application;
import android.os.Bundle;
import com.transsin.networkmonitor.NetworkMonitor;
import com.transsion.core.CoreUtil;
import com.transsion.core.deviceinfo.DeviceInfo;
import com.transsion.datatracer.com.transsion.datatracer.TDataTracer;
import com.transsion.json.Tson;
import com.transsion.push.PushManager;
import com.transsion.push.tracker.Tracker;
import com.transsion.push.utils.PushLogUtils;
import java.util.HashMap;

class InfoeyeTracker {
    private static final String EVENT_KEY = "hipush_event";
    private static final String EVENT_KEY_NAME = "metrics_name";
    private static final String EVENT_GAID_NAME = "gaid";
    private static InfoeyeTracker instance = null;

    private InfoeyeTracker() {
    }

    public static InfoeyeTracker getInstance() {
        if (instance == null) {
            instance = new InfoeyeTracker();
        }
        return instance;
    }

    void init() {
        if (!this.isInfoeyeIntegrated()) {
            return;
        }
        NetworkMonitor.init((Application)((Application)CoreUtil.getContext().getApplicationContext()), (boolean)false);
    }

    void track(Tracker.KEY key, Bundle bundle) {
        if (key.infoeyeEvent == null || key.infoeyeEvent.isEmpty()) {
            return;
        }
        if (!this.isInfoeyeIntegrated()) {
            return;
        }
        try {
            if (!PushManager.getInstance().getIsSdkInitFinished()) {
                NetworkMonitor.init((Application)((Application)CoreUtil.getContext().getApplicationContext()), (boolean)false);
            }
            this.printInfoeye(key, bundle);
            HashMap<String, Object> bundleMap = new HashMap<String, Object>();
            for (String bundleKey : bundle.keySet()) {
                bundleMap.put(bundleKey, bundle.get(bundleKey));
            }
            bundleMap.put(EVENT_KEY_NAME, key.infoeyeEvent);
            bundleMap.put(EVENT_GAID_NAME, DeviceInfo.getGAIdInThread());
            String extraJson = Tson.toJson(bundleMap);
            TDataTracer.Companion.traceCountType(EVENT_KEY, extraJson, "general_data_collection");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void printInfoeye(Tracker.KEY trackerKey, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String key : bundle.keySet()) {
            sb.append(key).append(":").append(bundle.get(key)).append(", ");
        }
        PushLogUtils.LOG.d((Object)("infoeye track event:" + trackerKey.infoeyeEvent + ", bundle: " + sb.toString()));
    }

    private boolean isInfoeyeIntegrated() {
        try {
            Class.forName("com.transsion.datatracer.com.transsion.datatracer.TDataTracer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

