/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.utils;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import com.transsion.core.CoreUtil;
import com.transsion.ga.AthenaAnalytics;
import com.transsion.push.config.PushRepository;
import com.transsion.push.utils.NotificationAssistUtils;
import com.transsion.push.utils.PushIml;
import com.transsion.push.utils.PushLogUtils;
import com.transsion.push.utils.PushUtils;

public final class ProviderUtils {
    private static final String ACTIVE_URI = "content://com.transsion.tpush.tpms.PushContentProvider/active";
    private static final String CONFIG_URI = "content://com.transsion.tpush.tpms.PushContentProvider/config";

    private static boolean isHaveProviderClass() {
        if (!PushIml.isSystemChannel()) {
            return true;
        }
        try {
            Class.forName("com.transsion.tpush.tpms.PushContentProvider");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean updateActive(Context context) {
        if (!ProviderUtils.isHaveProviderClass()) {
            return false;
        }
        ContentResolver resolver = null;
        try {
            String token = PushRepository.getInstance().getSpValue("push_token", "");
            if (TextUtils.isEmpty((CharSequence)token)) {
                PushLogUtils.LOG.e((Object)"update provider active fail, token is empty");
                return false;
            }
            Uri uri = Uri.parse((String)ACTIVE_URI);
            resolver = context.getContentResolver();
            ContentValues values = new ContentValues();
            values.put("vaid", AthenaAnalytics.getAppVAID((Context)CoreUtil.getContext(), (boolean)true));
            values.put("pkg", context.getPackageName());
            values.put("appId", PushUtils.getAppId());
            values.put("appKey", PushUtils.getAppKey());
            values.put("token", token);
            values.put("update_time", Long.valueOf(System.currentTimeMillis()));
            values.put("noticeEnable", Integer.valueOf(NotificationAssistUtils.isOpenNotification(context) ? 1 : 2));
            values.put("sdkVersion", "2.0.0.01");
            values.put("sdkVersionCode", Integer.valueOf(17004));
            resolver.update(uri, values, null, null);
            return true;
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("update provider active fail, e:" + e.getMessage()));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateConfig(Context context) {
        if (!ProviderUtils.isHaveProviderClass()) {
            return false;
        }
        try (Cursor cursor = null;){
            Uri uri = Uri.parse((String)CONFIG_URI);
            ContentResolver resolver = context.getContentResolver();
            cursor = resolver.query(uri, new String[]{PushUtils.getAppId()}, null, null, null);
            if (cursor != null && cursor.getCount() > 0) {
                cursor.moveToNext();
                int destroy = cursor.getInt(cursor.getColumnIndex("destroy"));
                int interval = cursor.getInt(cursor.getColumnIndex("syncInfoInterval"));
                PushLogUtils.LOG.d((Object)("updateConfig----->destroy:" + destroy + ", interval:" + interval));
                PushRepository.getInstance().putSpValue("push_self_destroying", destroy);
                PushRepository.getInstance().putSpValue("push_self_destroying_interval", interval);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }
}

