/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.utils;

import com.transsion.push.bean.ConfigInfo;
import com.transsion.push.config.PushRepository;
import com.transsion.push.utils.NetUtils;

public final class PushConfigUtils {
    public static int getConfigVersion() {
        ConfigInfo.Config config = PushRepository.getInstance().getConfig();
        if (config != null && config.version > 0) {
            return config.version;
        }
        return 0;
    }

    public static long getReportActiveInterval() {
        if (NetUtils.isWifi()) {
            ConfigInfo.Config config = PushRepository.getInstance().getConfig();
            if (config != null && config.uploadInterval > 0) {
                return config.uploadInterval * 1000;
            }
            int appUploadInterval = PushRepository.getInstance().getSpValue("app_upload_interval", -1);
            if (appUploadInterval > 0) {
                return appUploadInterval * 1000;
            }
        } else {
            ConfigInfo.Config config = PushRepository.getInstance().getConfig();
            if (config != null && config.mobileUploadInterval > 0) {
                return config.mobileUploadInterval * 1000;
            }
            int appMUploadInterval = PushRepository.getInstance().getSpValue("app_m_upload_interval", -1);
            if (appMUploadInterval > 0) {
                return appMUploadInterval * 1000;
            }
        }
        return 43200000L;
    }

    public static long getCheckInterval() {
        ConfigInfo.Config config = PushRepository.getInstance().getConfig();
        if (config != null && config.alarmCheckInterval > 0) {
            return config.alarmCheckInterval * 1000;
        }
        int appCheckInterval = PushRepository.getInstance().getSpValue("app_check_interval", -1);
        if (appCheckInterval > 0) {
            return appCheckInterval * 1000;
        }
        return 0x6DDD00L;
    }

    public static long getRetryInterval() {
        ConfigInfo.Config config = PushRepository.getInstance().getConfig();
        if (config != null && config.retryInterval > 0) {
            return config.retryInterval * 1000;
        }
        return 20000L;
    }

    public static int getRetryCount() {
        ConfigInfo.Config config = PushRepository.getInstance().getConfig();
        if (config != null && config.retryCount > 0) {
            return config.retryCount;
        }
        return 2;
    }

    public static long getSelfDestroyingInterval() {
        int interval = PushRepository.getInstance().getSpValue("push_self_destroying_interval", 86400);
        return interval * 1000;
    }

    public static boolean isSelfDestroy() {
        return 2 == PushRepository.getInstance().getSpValue("push_self_destroying", 1);
    }

    public static long getTrackerReportInterval() {
        long reportTime = PushRepository.getInstance().getSpValue("tracker_report_interval", -1L);
        return Math.min(86400000L, Math.max(900000L, reportTime));
    }

    public static boolean isImmediatelyTracker() {
        return PushRepository.getInstance().getSpValue("is_immediately_tracker", false);
    }
}

