/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.push.utils;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.transsion.push.bean.PushMessage;
import com.transsion.push.service.PushJobIntentService;
import com.transsion.push.service.PushServiceHelper;
import com.transsion.push.utils.PushLogUtils;
import com.transsion.push.utils.ThreadManager;

public final class ServiceUtils {
    public static void startTargetIntentService(PushMessage message) {
    }

    public static void startTargetIntentService(Context context, Bundle bundle) {
        Intent intent = new Intent();
        intent.putExtras(bundle);
        ServiceUtils.startJobIntentService(context, intent);
    }

    public static void startJobThread(final Context context, final Bundle bundle) {
        ThreadManager.executeInBackground(new Runnable(){

            @Override
            public void run() {
                Intent intent = new Intent();
                intent.putExtras(bundle);
                ServiceUtils.startJobThreadInbackground(context, intent);
            }
        });
    }

    private static void startJobIntentService(Context context, Intent intent) {
        try {
            PushJobIntentService.enqueueWork(context, PushJobIntentService.class, 1003, intent.setComponent(new ComponentName(context, PushJobIntentService.class)));
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("start job intent service exception, e:" + e.getMessage()));
        }
    }

    private static void startJobThreadInbackground(Context context, Intent intent) {
        try {
            PushServiceHelper.onHandleIntent(intent);
        }
        catch (Exception e) {
            PushLogUtils.LOG.e((Object)("start job intent service exception, e:" + e.getMessage()));
        }
    }
}

